/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor;

import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class JavaUtil {
    public static String getFullQName(IType parent, String type) {
        IType javaType;
        if (type.indexOf(46) >= 0) {
            return type;
        }
        if (JavaUtil.isPrimitive(type)) {
            return type;
        }
        IJavaProject project = parent.getJavaProject();
        try {
            javaType = project.findType("java.lang." + type);
            if (javaType != null && javaType.exists()) {
                return javaType.getFullyQualifiedName();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        while (true) {
            try {
                javaType = project.findType(String.valueOf(parent.getFullyQualifiedName()) + "." + type);
                if (javaType != null && javaType.exists()) {
                    return String.valueOf(parent.getFullyQualifiedName()) + "." + type;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                javaType = project.findType(String.valueOf(parent.getPackageFragment().getElementName()) + "." + type);
                if (javaType != null && javaType.exists()) {
                    return javaType.getFullyQualifiedName();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                IImportDeclaration[] imports = parent.getCompilationUnit().getImports();
                int i = 0;
                while (i < imports.length) {
                    String importName = imports[i].getElementName();
                    if (importName.endsWith("." + type)) {
                        return importName;
                    }
                    if (importName.endsWith(".*")) {
                        try {
                            IType javaType2 = project.findType(importName.replaceFirst("\\*$", type));
                            if (javaType2 != null && javaType2.exists()) {
                                return javaType2.getFullyQualifiedName();
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                String superClass;
                if (parent.getSuperclassTypeSignature() == null || (superClass = JavaUtil.getFullQName(parent, Signature.toString((String)parent.getSuperclassTypeSignature()))).startsWith("java.lang.")) break;
                parent = parent.getJavaProject().findType(superClass);
            }
            catch (JavaModelException javaModelException) {}
        }
        return type;
    }

    public static boolean isPrimitive(String type) {
        return type.equals("int") || type.equals("long") || type.equals("double") || type.equals("float") || type.equals("char") || type.equals("boolean") || type.equals("byte");
    }
}

