/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IOUtil {
    public static byte[] readStream(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int len = 0;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        byte[] result = out.toByteArray();
        IOUtil.closeQuietly(in);
        IOUtil.closeQuietly(out);
        return result;
    }

    public static void copyFolder(File from, File to) throws IOException {
        File[] files = from.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                File newDir = new File(to, files[i].getName());
                if (!newDir.exists()) {
                    newDir.mkdir();
                    IOUtil.copyFolder(files[i], newDir);
                }
            } else {
                File newFile = new File(to, files[i].getName());
                if (!newFile.exists()) {
                    FileInputStream in = new FileInputStream(files[i]);
                    FileOutputStream out = new FileOutputStream(newFile);
                    byte[] buf = new byte[8216];
                    int length = 0;
                    while ((length = ((InputStream)in).read(buf)) != -1) {
                        ((OutputStream)out).write(buf, 0, length);
                    }
                    IOUtil.closeQuietly(in);
                    IOUtil.closeQuietly(out);
                }
            }
            ++i;
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {}
        }
    }

    public static IFile getIFile(Object file) {
        IFile ifile = null;
        if (file instanceof IFile) {
            ifile = (IFile)file;
        } else if (file instanceof File) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath location = Path.fromOSString((String)((File)file).getAbsolutePath());
            ifile = workspace.getRoot().getFileForLocation(location);
        }
        return ifile;
    }
}

