/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;

public class HTMLProjectParams {
    private String root = "/";
    private boolean useDTD = true;
    private boolean validateXML = true;
    private boolean validateHTML = true;
    private boolean validateJSP = true;
    private boolean validateDTD = true;
    private boolean validateJS = true;
    private boolean removeMarkers = false;
    private boolean detectTaskTag = false;
    private String[] javaScripts = new String[0];
    private String[] javaScriptCompleters = new String[0];
    private String[] javaScriptLibPaths = new String[0];
    private int javaScriptIndentSize = 4;
    private char javaScriptIndentChar = (char)32;
    private boolean javaScriptPreserveNewlines = true;
    private int javaScriptInitIndentLevel = 0;
    private boolean javaScriptSpaceAfterAnonFunc = false;
    private boolean javaScriptBracesOnOwnLine = true;
    private String javaScriptAccessControls;
    private String javaScriptCheckRegExp;
    private String javaScriptCheckTypes;
    private String javaScriptCheckVars;
    private String javaScriptDeprecated;
    private String javaScriptFileoverviewTags;
    private String javaScriptInvalidCasts;
    private String javaScriptMissingProperties;
    private String javaScriptNonStandardJsDocs;
    private String javaScriptStrictModuleDepCheck;
    private String javaScriptUndefinedVars;
    private String javaScriptUnknownDefines;
    private String javaScriptVisibility;
    private String javaScriptUseUndefined;
    public static final String P_ROOT = "root";
    public static final String P_USE_DTD = "useDTD";
    public static final String P_VALIDATE_XML = "validateXML";
    public static final String P_VALIDATE_HTML = "validateHTML";
    public static final String P_VALIDATE_JSP = "validateJSP";
    public static final String P_VALIDATE_DTD = "validateDTD";
    public static final String P_VALIDATE_JS = "validateJS";
    public static final String P_REMOVE_MARKERS = "removeMarkers";
    public static final String P_JAVA_SCRIPTS = "javaScripts";
    public static final String P_JAVA_SCRIPT_COMPLETERS = "javaScriptCompleters";
    public static final String P_JAVA_SCRIPT_REQUIRE_PATHS = "javaScriptLibPaths";
    public static final String P_JAVA_SCRIPT_F_INDENT_SIZE = "javaScriptIndentSize";
    public static final String P_JAVA_SCRIPT_F_INDENT_CHAR = "javaScriptIndentChar";
    public static final String P_JAVA_SCRIPT_F_PRESERVE_NEWLINES = "javaScriptPreserveNewlines";
    public static final String P_JAVA_SCRIPT_F_INIT_INDENT_LEVEL = "javaScriptInitIndentLevel";
    public static final String P_JAVA_SCRIPT_F_SPACE_AFTER_ANON_FUNC = "javaScriptSpaceAfterAnonFunc";
    public static final String P_JAVA_SCRIPT_F_BRACES_ON_OWN_LINES = "javaScriptBracesOnOwnLine";
    public static final String P_JAVA_SCRIPT_V_ACCESS_CONTROLL = "javaScriptAccessControls";
    public static final String P_JAVA_SCRIPT_V_CHECK_REG_EXP = "javaScriptCheckRegExp";
    public static final String P_JAVA_SCRIPT_V_CHECK_TYPES = "javaScriptCheckTypes";
    public static final String P_JAVA_SCRIPT_V_CHECK_VARS = "javaScriptCheckVars";
    public static final String P_JAVA_SCRIPT_V_DEPRECATED = "javaScriptDeprecated";
    public static final String P_JAVA_SCRIPT_V_FILE_OVERVIEW_TAGS = "javaScriptFileoverviewTags";
    public static final String P_JAVA_SCRIPT_V_INVALID_CASTS = "javaScriptInvalidCasts";
    public static final String P_JAVA_SCRIPT_V_MISSING_PROP = "javaScriptMissingProperties";
    public static final String P_JAVA_SCRIPT_V_NON_STANDARD_JSDOC = "javaScriptNonStandardJsDocs";
    public static final String P_JAVA_SCRIPT_V_STRICT_MODULE_DEP_CHECK = "javaScriptStrictModuleDepCheck";
    public static final String P_JAVA_SCRIPT_V_UNDEFINED_VARS = "javaScriptUndefinedVars";
    public static final String P_JAVA_SCRIPT_V_UNKNOWN_DEFINES = "javaScriptUnknownDefines";
    public static final String P_JAVA_SCRIPT_V_VISIBILITY = "javaScriptVisibility";
    public static final String P_JAVA_SCRIPT_V_USE_UNDEFINED = "javaScriptUseUndefined";

    public HTMLProjectParams() {
    }

    public HTMLProjectParams(IProject project) throws Exception {
        this.load(project);
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String webAppRoot) {
        this.root = webAppRoot;
    }

    public void setUseDTD(boolean useDTD) {
        this.useDTD = useDTD;
    }

    public boolean getUseDTD() {
        return this.useDTD;
    }

    public void setValidateHTML(boolean validateHTML) {
        this.validateHTML = validateHTML;
    }

    public boolean getValidateHTML() {
        return this.validateHTML;
    }

    public void setValidateJSP(boolean validateJSP) {
        this.validateJSP = validateJSP;
    }

    public boolean getValidateJSP() {
        return this.validateJSP;
    }

    public void setValidateDTD(boolean validateDTD) {
        this.validateDTD = validateDTD;
    }

    public boolean getValidateDTD() {
        return this.validateDTD;
    }

    public void setValidateJavaScript(boolean validateJS) {
        this.validateJS = validateJS;
    }

    public boolean getValidateJavaScript() {
        return this.validateJS;
    }

    public void setValidateXML(boolean validateXML) {
        this.validateXML = validateXML;
    }

    public boolean getValidateXML() {
        return this.validateXML;
    }

    public void setRemoveMarkers(boolean removeMarkers) {
        this.removeMarkers = removeMarkers;
    }

    public boolean getRemoveMarkers() {
        return this.removeMarkers;
    }

    public void setDetectTaskTag(boolean detectTaskTag) {
        this.detectTaskTag = detectTaskTag;
    }

    public boolean getDetectTaskTag() {
        return this.detectTaskTag;
    }

    public void setJavaScripts(String[] javaScripts) {
        this.javaScripts = javaScripts;
    }

    public String[] getJavaScripts() {
        return this.javaScripts;
    }

    public void setJavaScriptCompleters(String[] javaScriptCompleters) {
        this.javaScriptCompleters = javaScriptCompleters;
    }

    public String[] getJavaScriptCompleters() {
        return this.javaScriptCompleters;
    }

    public void save(IProject project) throws Exception {
        IFile configFile = project.getFile(".amateras");
        Properties props = new Properties();
        props.put(P_ROOT, this.root);
        props.put(P_USE_DTD, String.valueOf(this.useDTD));
        props.put(P_VALIDATE_XML, String.valueOf(this.validateXML));
        props.put(P_VALIDATE_HTML, String.valueOf(this.validateHTML));
        props.put(P_VALIDATE_JSP, String.valueOf(this.validateJSP));
        props.put(P_VALIDATE_DTD, String.valueOf(this.validateDTD));
        props.put(P_VALIDATE_JS, String.valueOf(this.validateJS));
        props.put(P_REMOVE_MARKERS, String.valueOf(this.removeMarkers));
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.javaScripts.length) {
            if (i != 0) {
                sb.append('\n');
            }
            sb.append(this.javaScripts[i]);
            ++i;
        }
        props.put(P_JAVA_SCRIPTS, sb.toString());
        sb.setLength(0);
        i = 0;
        while (i < this.javaScriptCompleters.length) {
            if (i != 0) {
                sb.append('\n');
            }
            sb.append(this.javaScriptCompleters[i]);
            ++i;
        }
        props.put(P_JAVA_SCRIPT_COMPLETERS, sb.toString());
        sb.setLength(0);
        i = 0;
        while (i < this.javaScriptLibPaths.length) {
            if (i != 0) {
                sb.append('\n');
            }
            sb.append(this.javaScriptLibPaths[i]);
            ++i;
        }
        props.put(P_JAVA_SCRIPT_REQUIRE_PATHS, sb.toString());
        props.put(P_JAVA_SCRIPT_V_ACCESS_CONTROLL, this.javaScriptAccessControls);
        props.put(P_JAVA_SCRIPT_V_CHECK_REG_EXP, this.javaScriptCheckRegExp);
        props.put(P_JAVA_SCRIPT_V_CHECK_TYPES, this.javaScriptCheckTypes);
        props.put(P_JAVA_SCRIPT_V_CHECK_VARS, this.javaScriptCheckVars);
        props.put(P_JAVA_SCRIPT_V_DEPRECATED, this.javaScriptDeprecated);
        props.put(P_JAVA_SCRIPT_V_FILE_OVERVIEW_TAGS, this.javaScriptFileoverviewTags);
        props.put(P_JAVA_SCRIPT_V_INVALID_CASTS, this.javaScriptInvalidCasts);
        props.put(P_JAVA_SCRIPT_V_MISSING_PROP, this.javaScriptMissingProperties);
        props.put(P_JAVA_SCRIPT_V_NON_STANDARD_JSDOC, this.javaScriptNonStandardJsDocs);
        props.put(P_JAVA_SCRIPT_V_STRICT_MODULE_DEP_CHECK, this.javaScriptStrictModuleDepCheck);
        props.put(P_JAVA_SCRIPT_V_UNDEFINED_VARS, this.javaScriptUndefinedVars);
        props.put(P_JAVA_SCRIPT_V_UNKNOWN_DEFINES, this.javaScriptUnknownDefines);
        props.put(P_JAVA_SCRIPT_V_VISIBILITY, this.javaScriptVisibility);
        props.put(P_JAVA_SCRIPT_V_USE_UNDEFINED, this.javaScriptUseUndefined);
        props.put(P_JAVA_SCRIPT_F_INDENT_SIZE, Integer.toString(this.javaScriptIndentSize));
        props.put(P_JAVA_SCRIPT_F_INDENT_CHAR, Character.toString(this.javaScriptIndentChar));
        props.put(P_JAVA_SCRIPT_F_PRESERVE_NEWLINES, Boolean.toString(this.javaScriptPreserveNewlines));
        props.put(P_JAVA_SCRIPT_F_INIT_INDENT_LEVEL, Integer.toString(this.javaScriptInitIndentLevel));
        props.put(P_JAVA_SCRIPT_F_SPACE_AFTER_ANON_FUNC, Boolean.toString(this.javaScriptSpaceAfterAnonFunc));
        props.put(P_JAVA_SCRIPT_F_BRACES_ON_OWN_LINES, Boolean.toString(this.javaScriptBracesOnOwnLine));
        File file = configFile.getLocation().makeAbsolute().toFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        props.store(new FileOutputStream(file), "EclipseHTMLEditor configuration file");
        if (this.detectTaskTag) {
            this.addNature(project);
        } else {
            this.removeNature(project);
        }
        project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
    }

    private void addNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals("com.poscoict.mobileframework.htmleditor.HTMLProjectNature")) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "com.poscoict.mobileframework.htmleditor.HTMLProjectNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    private void removeNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        ArrayList<String> newNatures = new ArrayList<String>();
        int i = 0;
        while (i < natures.length) {
            if (!natures[i].equals("com.poscoict.mobileframework.htmleditor.HTMLProjectNature")) {
                newNatures.add(natures[i]);
            }
            ++i;
        }
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        project.setDescription(description, null);
    }

    public void load(IProject project) throws Exception {
        IFile configFile = project.getFile(".amateras");
        String useDTD = null;
        String validateXML = null;
        String validateHTML = null;
        String validateJSP = null;
        String validateDTD = null;
        String validateJS = null;
        String removeMarkers = null;
        String javaScripts = "";
        String javaScriptCompleters = "ECMA Script\nFireFox";
        String javaScriptLibPaths = "";
        String indentSize = "4";
        String indentChar = " ";
        String preserveNewlines = "true";
        String initIndentLevel = "0";
        String spaceAfterAnonFunc = "false";
        String bracesOnOwnLine = "true";
        String javaScriptAccessControls = "Off";
        String javaScriptCheckRegExp = "Off";
        String javaScriptCheckTypes = "Off";
        String javaScriptCheckVars = "Off";
        String javaScriptDeprecated = "Off";
        String javaScriptFileoverviewTags = "Off";
        String javaScriptInvalidCasts = "Off";
        String javaScriptMissingProperties = "Off";
        String javaScriptNonStandardJsDocs = "Off";
        String javaScriptStrictModuleDepCheck = "Off";
        String javaScriptUndefinedVars = "Off";
        String javaScriptUnknownDefines = "Off";
        String javaScriptVisibility = "Off";
        String javaScriptUseUndefined = "Off";
        if (configFile.exists()) {
            File file = configFile.getLocation().makeAbsolute().toFile();
            Properties props = new Properties();
            props.load(new FileInputStream(file));
            this.root = props.getProperty(P_ROOT);
            useDTD = props.getProperty(P_USE_DTD);
            validateXML = props.getProperty(P_VALIDATE_XML);
            validateHTML = props.getProperty(P_VALIDATE_HTML);
            validateJSP = props.getProperty(P_VALIDATE_JSP);
            validateDTD = props.getProperty(P_VALIDATE_DTD);
            validateJS = props.getProperty(P_VALIDATE_JS);
            removeMarkers = props.getProperty(P_REMOVE_MARKERS);
            javaScripts = props.getProperty(P_JAVA_SCRIPTS);
            if (javaScripts == null) {
                javaScripts = "";
            }
            if ((javaScriptCompleters = props.getProperty(P_JAVA_SCRIPT_COMPLETERS)) == null) {
                javaScriptCompleters = "ECMA Script\nFireFox";
            }
            if ((javaScriptLibPaths = props.getProperty(P_JAVA_SCRIPT_REQUIRE_PATHS)) == null) {
                javaScriptLibPaths = "";
            }
            if ((javaScriptAccessControls = props.getProperty(P_JAVA_SCRIPT_V_ACCESS_CONTROLL)) == null) {
                javaScriptAccessControls = "Off";
            }
            if ((javaScriptCheckRegExp = props.getProperty(P_JAVA_SCRIPT_V_CHECK_REG_EXP)) == null) {
                javaScriptCheckRegExp = "Off";
            }
            if ((javaScriptCheckTypes = props.getProperty(P_JAVA_SCRIPT_V_CHECK_TYPES)) == null) {
                javaScriptCheckTypes = "Off";
            }
            if ((javaScriptCheckVars = props.getProperty(P_JAVA_SCRIPT_V_CHECK_VARS)) == null) {
                javaScriptCheckVars = "Off";
            }
            if ((javaScriptDeprecated = props.getProperty(P_JAVA_SCRIPT_V_DEPRECATED)) == null) {
                javaScriptDeprecated = "Off";
            }
            if ((javaScriptFileoverviewTags = props.getProperty(P_JAVA_SCRIPT_V_FILE_OVERVIEW_TAGS)) == null) {
                javaScriptFileoverviewTags = "Off";
            }
            if ((javaScriptInvalidCasts = props.getProperty(P_JAVA_SCRIPT_V_INVALID_CASTS)) == null) {
                javaScriptInvalidCasts = "Off";
            }
            if ((javaScriptMissingProperties = props.getProperty(P_JAVA_SCRIPT_V_MISSING_PROP)) == null) {
                javaScriptMissingProperties = "Off";
            }
            if ((javaScriptNonStandardJsDocs = props.getProperty(P_JAVA_SCRIPT_V_NON_STANDARD_JSDOC)) == null) {
                javaScriptNonStandardJsDocs = "Off";
            }
            if ((javaScriptStrictModuleDepCheck = props.getProperty(P_JAVA_SCRIPT_V_STRICT_MODULE_DEP_CHECK)) == null) {
                javaScriptStrictModuleDepCheck = "Off";
            }
            if ((javaScriptUndefinedVars = props.getProperty(P_JAVA_SCRIPT_V_UNDEFINED_VARS)) == null) {
                javaScriptUndefinedVars = "Off";
            }
            if ((javaScriptUnknownDefines = props.getProperty(P_JAVA_SCRIPT_V_UNKNOWN_DEFINES)) == null) {
                javaScriptUnknownDefines = "Off";
            }
            if ((javaScriptVisibility = props.getProperty(P_JAVA_SCRIPT_V_VISIBILITY)) == null) {
                javaScriptVisibility = "Off";
            }
            if ((javaScriptUseUndefined = props.getProperty(P_JAVA_SCRIPT_V_USE_UNDEFINED)) == null) {
                javaScriptUseUndefined = "Off";
            }
            if ((indentSize = props.getProperty(P_JAVA_SCRIPT_F_INDENT_SIZE)) == null) {
                indentSize = "4";
            }
            if ((indentChar = props.getProperty(P_JAVA_SCRIPT_F_INDENT_CHAR)) == null) {
                indentChar = " ";
            }
            if ((preserveNewlines = props.getProperty(P_JAVA_SCRIPT_F_PRESERVE_NEWLINES)) == null) {
                preserveNewlines = "true";
            }
            if ((initIndentLevel = props.getProperty(P_JAVA_SCRIPT_F_INIT_INDENT_LEVEL)) == null) {
                initIndentLevel = "0";
            }
            if ((spaceAfterAnonFunc = props.getProperty(P_JAVA_SCRIPT_F_SPACE_AFTER_ANON_FUNC)) == null) {
                spaceAfterAnonFunc = "false";
            }
            if ((bracesOnOwnLine = props.getProperty(P_JAVA_SCRIPT_F_BRACES_ON_OWN_LINES)) == null) {
                bracesOnOwnLine = "true";
            }
        } else {
            this.root = project.getPersistentProperty(new QualifiedName(HTMLPlugin.getDefault().getPluginId(), P_ROOT));
            useDTD = project.getPersistentProperty(new QualifiedName(HTMLPlugin.getDefault().getPluginId(), P_USE_DTD));
            validateHTML = project.getPersistentProperty(new QualifiedName(HTMLPlugin.getDefault().getPluginId(), P_VALIDATE_HTML));
        }
        if (this.root == null) {
            this.root = "/";
        }
        this.useDTD = this.getBooleanValue(useDTD, true);
        this.validateXML = this.getBooleanValue(validateXML, true);
        this.validateHTML = this.getBooleanValue(validateHTML, true);
        this.validateJSP = this.getBooleanValue(validateJSP, true);
        this.validateDTD = this.getBooleanValue(validateDTD, true);
        this.validateJS = this.getBooleanValue(validateJS, true);
        this.removeMarkers = this.getBooleanValue(removeMarkers, false);
        this.detectTaskTag = project.hasNature("com.poscoict.mobileframework.htmleditor.HTMLProjectNature");
        String[] dim = javaScripts.split("\n");
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < dim.length) {
            if (dim[i].trim().length() != 0) {
                list.add(dim[i]);
            }
            ++i;
        }
        this.javaScripts = list.toArray(new String[list.size()]);
        dim = javaScriptCompleters.split("\n");
        list = new ArrayList();
        i = 0;
        while (i < dim.length) {
            if (dim[i].trim().length() != 0) {
                list.add(dim[i]);
            }
            ++i;
        }
        this.javaScriptCompleters = list.toArray(new String[list.size()]);
        dim = javaScriptLibPaths.split("\n");
        list = new ArrayList();
        i = 0;
        while (i < dim.length) {
            if (dim[i].trim().length() != 0) {
                list.add(dim[i]);
            }
            ++i;
        }
        this.javaScriptLibPaths = list.toArray(new String[list.size()]);
        this.javaScriptAccessControls = javaScriptAccessControls;
        this.javaScriptCheckRegExp = javaScriptCheckRegExp;
        this.javaScriptCheckTypes = javaScriptCheckTypes;
        this.javaScriptCheckVars = javaScriptCheckVars;
        this.javaScriptDeprecated = javaScriptDeprecated;
        this.javaScriptFileoverviewTags = javaScriptFileoverviewTags;
        this.javaScriptInvalidCasts = javaScriptInvalidCasts;
        this.javaScriptMissingProperties = javaScriptMissingProperties;
        this.javaScriptNonStandardJsDocs = javaScriptNonStandardJsDocs;
        this.javaScriptStrictModuleDepCheck = javaScriptStrictModuleDepCheck;
        this.javaScriptUndefinedVars = javaScriptUndefinedVars;
        this.javaScriptUnknownDefines = javaScriptUnknownDefines;
        this.javaScriptVisibility = javaScriptVisibility;
        this.javaScriptUseUndefined = javaScriptUseUndefined;
        try {
            this.javaScriptIndentSize = Integer.parseInt(indentSize);
        }
        catch (Exception exception) {}
        this.javaScriptIndentChar = (char)(indentChar.length() > 0 ? (int)indentChar.charAt(0) : 32);
        try {
            this.javaScriptPreserveNewlines = Boolean.parseBoolean(preserveNewlines);
        }
        catch (Exception exception) {}
        try {
            this.javaScriptInitIndentLevel = Integer.parseInt(initIndentLevel);
        }
        catch (Exception exception) {}
        try {
            this.javaScriptSpaceAfterAnonFunc = Boolean.parseBoolean(spaceAfterAnonFunc);
        }
        catch (Exception exception) {}
        try {
            this.javaScriptBracesOnOwnLine = Boolean.parseBoolean(bracesOnOwnLine);
        }
        catch (Exception exception) {}
    }

    private boolean getBooleanValue(String value, boolean defaultValue) {
        if (value != null) {
            if (value.equals("true")) {
                return true;
            }
            if (value.equals("false")) {
                return false;
            }
        }
        return defaultValue;
    }

    public String[] getJavaScriptLibPaths() {
        return this.javaScriptLibPaths;
    }

    public void setJavaScriptLibPaths(String[] libPaths) {
        this.javaScriptLibPaths = libPaths;
    }

    public int getJavaScriptIndentSize() {
        return this.javaScriptIndentSize;
    }

    public void setJavaScriptIndentSize(int javaScriptIndentSize) {
        this.javaScriptIndentSize = javaScriptIndentSize;
    }

    public char getJavaScriptIndentChar() {
        return this.javaScriptIndentChar;
    }

    public void setJavaScriptIndentChar(char javaScriptIndentChar) {
        this.javaScriptIndentChar = javaScriptIndentChar;
    }

    public boolean isJavaScriptPreserveNewlines() {
        return this.javaScriptPreserveNewlines;
    }

    public void setJavaScriptPreserveNewlines(boolean javaScriptPreserveNewlines) {
        this.javaScriptPreserveNewlines = javaScriptPreserveNewlines;
    }

    public int getJavaScriptInitIndentLevel() {
        return this.javaScriptInitIndentLevel;
    }

    public void setJavaScriptInitIndentLevel(int javaScriptInitIndentLevel) {
        this.javaScriptInitIndentLevel = javaScriptInitIndentLevel;
    }

    public boolean isJavaScriptSpaceAfterAnonFunc() {
        return this.javaScriptSpaceAfterAnonFunc;
    }

    public void setJavaScriptSpaceAfterAnonFunc(boolean javaScriptSpaceAfterAnonFunc) {
        this.javaScriptSpaceAfterAnonFunc = javaScriptSpaceAfterAnonFunc;
    }

    public boolean isJavaScriptBracesOnOwnLine() {
        return this.javaScriptBracesOnOwnLine;
    }

    public void setJavaScriptBracesOnOwnLine(boolean javaScriptBracesOnOwnLine) {
        this.javaScriptBracesOnOwnLine = javaScriptBracesOnOwnLine;
    }

    public String getJavaScriptAccessControls() {
        return this.javaScriptAccessControls;
    }

    public void setJavaScriptAccessControls(String javaScriptAccessControls) {
        this.javaScriptAccessControls = javaScriptAccessControls;
    }

    public String getJavaScriptCheckRegExp() {
        return this.javaScriptCheckRegExp;
    }

    public void setJavaScriptCheckRegExp(String javaScriptCheckRegExp) {
        this.javaScriptCheckRegExp = javaScriptCheckRegExp;
    }

    public String getJavaScriptCheckTypes() {
        return this.javaScriptCheckTypes;
    }

    public void setJavaScriptCheckTypes(String javaScriptCheckTypes) {
        this.javaScriptCheckTypes = javaScriptCheckTypes;
    }

    public String getJavaScriptCheckVars() {
        return this.javaScriptCheckVars;
    }

    public void setJavaScriptCheckVars(String javaScriptCheckVars) {
        this.javaScriptCheckVars = javaScriptCheckVars;
    }

    public String getJavaScriptDeprecated() {
        return this.javaScriptDeprecated;
    }

    public void setJavaScriptDeprecated(String javaScriptDeprecated) {
        this.javaScriptDeprecated = javaScriptDeprecated;
    }

    public String getJavaScriptFileoverviewTags() {
        return this.javaScriptFileoverviewTags;
    }

    public void setJavaScriptFileoverviewTags(String javaScriptFileoverviewTags) {
        this.javaScriptFileoverviewTags = javaScriptFileoverviewTags;
    }

    public String getJavaScriptInvalidCasts() {
        return this.javaScriptInvalidCasts;
    }

    public void setJavaScriptInvalidCasts(String javaScriptInvalidCasts) {
        this.javaScriptInvalidCasts = javaScriptInvalidCasts;
    }

    public String getJavaScriptMissingProperties() {
        return this.javaScriptMissingProperties;
    }

    public void setJavaScriptMissingProperties(String javaScriptMissingProperties) {
        this.javaScriptMissingProperties = javaScriptMissingProperties;
    }

    public String getJavaScriptNonStandardJsDocs() {
        return this.javaScriptNonStandardJsDocs;
    }

    public void setJavaScriptNonStandardJsDocs(String javaScriptNonStandardJsDocs) {
        this.javaScriptNonStandardJsDocs = javaScriptNonStandardJsDocs;
    }

    public String getJavaScriptStrictModuleDepCheck() {
        return this.javaScriptStrictModuleDepCheck;
    }

    public void setJavaScriptStrictModuleDepCheck(String javaScriptStrictModuleDepCheck) {
        this.javaScriptStrictModuleDepCheck = javaScriptStrictModuleDepCheck;
    }

    public String getJavaScriptUndefinedVars() {
        return this.javaScriptUndefinedVars;
    }

    public void setJavaScriptUndefinedVars(String javaScriptUndefinedVars) {
        this.javaScriptUndefinedVars = javaScriptUndefinedVars;
    }

    public String getJavaScriptUnknownDefines() {
        return this.javaScriptUnknownDefines;
    }

    public void setJavaScriptUnknownDefines(String javaScriptUnknownDefines) {
        this.javaScriptUnknownDefines = javaScriptUnknownDefines;
    }

    public String getJavaScriptVisibility() {
        return this.javaScriptVisibility;
    }

    public void setJavaScriptVisibility(String javaScriptVisibility) {
        this.javaScriptVisibility = javaScriptVisibility;
    }

    public String getJavaScriptUseUndefined() {
        return this.javaScriptUseUndefined;
    }

    public void setJavaScriptUseUndefined(String javaScriptUseUndefined) {
        this.javaScriptUseUndefined = javaScriptUseUndefined;
    }
}

