/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import com.poscoict.mobileframework.htmleditor.tasktag.AbstractTaskTagDetector;
import com.poscoict.mobileframework.htmleditor.tasktag.HTMLTaskTagDetector;
import com.poscoict.mobileframework.htmleditor.tasktag.ITaskTagDetector;
import com.poscoict.mobileframework.htmleditor.tasktag.TaskTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class HTMLProjectBuilder
extends IncrementalProjectBuilder {
    private final List<AbstractTaskTagDetector> taskTagDetectors = new ArrayList<AbstractTaskTagDetector>();
    private TaskTag[] tags;

    public HTMLProjectBuilder() {
        this.taskTagDetectors.add(new HTMLTaskTagDetector());
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta;
        List<TaskTag> list = TaskTag.loadFromPreference(false);
        this.tags = list.toArray(new TaskTag[list.size()]);
        IProject[] nproject = new IProject[]{};
        nproject = null;
        if (this.getProject() == null) {
            return nproject;
        }
        if (kind == 6) {
            this.processContainer((IContainer)this.getProject());
        }
        if ((delta = this.getDelta(this.getProject())) == null) {
            return nproject;
        }
        this.processDelta(delta);
        this.getProject().refreshLocal(2, monitor);
        return nproject;
    }

    private void processContainer(IContainer project) {
        try {
            IResource[] resources = project.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IContainer) {
                    this.processContainer((IContainer)resources[i]);
                } else if (resources[i] instanceof IFile) {
                    int j = 0;
                    while (j < this.taskTagDetectors.size()) {
                        ITaskTagDetector detector = this.taskTagDetectors.get(j);
                        if (detector.isSupported((IFile)resources[i])) {
                            this.applyDetector(resources[i], detector);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private void processDelta(IResourceDelta delta) {
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            int kind = children[i].getFlags();
            if (kind != 131072) {
                IResource resource = children[i].getResource();
                if (resource != null && resource instanceof IFile && resource.exists()) {
                    int j = 0;
                    while (j < this.taskTagDetectors.size()) {
                        ITaskTagDetector detector = this.taskTagDetectors.get(j);
                        if (detector.isSupported((IFile)resource)) {
                            this.applyDetector(resource, detector);
                            break;
                        }
                        ++j;
                    }
                }
                this.processDelta(children[i]);
            }
            ++i;
        }
    }

    private void applyDetector(final IResource resource, final ITaskTagDetector detector) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            try {
                                resource.deleteMarkers("org.eclipse.core.resources.taskmarker", false, 0);
                                detector.detect((IFile)resource, HTMLProjectBuilder.this.tags);
                            }
                            catch (Exception ex) {
                                HTMLPlugin.logException(ex);
                            }
                        }
                    }, null);
                }
                catch (Exception ex) {
                    HTMLPlugin.logException(ex);
                }
            }
        });
    }

    public static void doBuild(IProject project) {
        try {
            if (project.hasNature("com.poscoict.mobileframework.htmleditor.HTMLProjectNature")) {
                project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                project.build(6, "com.poscoict.mobileframework.htmleditor.HTMLProjectBuilder", new HashMap(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }
}

