/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import com.poscoict.mobileframework.htmleditor.IHyperlinkProvider;
import com.poscoict.mobileframework.htmleditor.editors.HTMLEditor;
import com.poscoict.mobileframework.htmleditor.editors.HTMLHyperlinkInfo;
import com.poscoict.mobileframework.htmleditor.editors.HTMLSourceEditor;
import java.util.ArrayList;
import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class HTMLHyperlinkDetector
implements IHyperlinkDetector {
    private HTMLSourceEditor editor;
    private final List<IHyperlinkProvider> providers = new ArrayList<IHyperlinkProvider>();

    public void setEditor(HTMLSourceEditor editor) {
        this.editor = editor;
    }

    public void addHyperlinkProvider(IHyperlinkProvider provider) {
        this.providers.add(provider);
    }

    private IProject getProject() {
        IEditorInput input = this.editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getProject();
        }
        return null;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink hyperlink = this.detectHyperlink(textViewer.getDocument(), region.getOffset());
        if (hyperlink != null) {
            return new IHyperlink[]{hyperlink};
        }
        return new IHyperlink[1];
    }

    private IHyperlink detectHyperlink(IDocument doc, int offset) {
        FuzzyXMLDocument document = new FuzzyXMLParser().parse(this.editor.getHTMLSource());
        FuzzyXMLElement element = document.getElementByOffset(offset);
        if (element == null) {
            return null;
        }
        FuzzyXMLAttribute[] attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i].getOffset() < offset && offset < attrs[i].getOffset() + attrs[i].getLength()) {
                int attrOffset = this.getAttributeValueOffset(doc.get(), attrs[i]);
                int attrLength = attrs[i].getValue().length();
                if (attrOffset >= 0 && attrLength >= 0 && attrOffset <= offset) {
                    HTMLHyperlinkInfo info = this.getOpenFileInfo(document, element, attrs[i].getName(), attrs[i].getValue(), offset - attrOffset);
                    if (info == null || info.getObject() == null) {
                        return null;
                    }
                    return new HTMLHyperlink((IRegion)new Region(attrOffset + info.getOffset(), info.getLength()), info.getObject(), info.getTargetOffset());
                }
            }
            ++i;
        }
        return null;
    }

    private HTMLHyperlinkInfo getOpenFileInfo(FuzzyXMLDocument doc, FuzzyXMLElement element, String attrName, String attrValue, int offset) {
        IProject project;
        block10: {
            project = this.getProject();
            if (project != null) break block10;
            return null;
        }
        try {
            IFile file = ((IFileEditorInput)this.editor.getEditorInput()).getFile();
            int i = 0;
            while (i < this.providers.size()) {
                IHyperlinkProvider provider = this.providers.get(i);
                HTMLHyperlinkInfo info = provider.getHyperlinkInfo(file, doc, element, attrName, attrValue, offset);
                if (info != null && info.getObject() != null) {
                    return info;
                }
                ++i;
            }
            if (attrName.equalsIgnoreCase("href")) {
                IPath path;
                IResource resource;
                FuzzyXMLElement target;
                String href = attrValue;
                String name = null;
                if (href.startsWith("#") && (target = HTMLHyperlinkDetector.getNameElement(doc, href.substring(1))) != null) {
                    HTMLHyperlinkInfo info = new HTMLHyperlinkInfo();
                    info.setObject(file);
                    info.setOffset(0);
                    info.setLength(attrValue.length());
                    info.setTargetOffset(target.getOffset());
                    return info;
                }
                if (href.indexOf("#") > 0) {
                    name = href.substring(href.indexOf("#") + 1);
                    href = href.substring(0, href.indexOf("#"));
                }
                if ((resource = project.findMember((path = file.getParent().getProjectRelativePath()).append(href))) != null && resource.exists() && resource instanceof IFile) {
                    FuzzyXMLElement target2;
                    HTMLHyperlinkInfo info = new HTMLHyperlinkInfo();
                    info.setObject(resource);
                    info.setOffset(0);
                    info.setLength(attrValue.length());
                    if (name != null && (target2 = HTMLHyperlinkDetector.getNameElement(new FuzzyXMLParser().parse(((IFile)resource).getContents()), name)) != null) {
                        info.setTargetOffset(target2.getOffset());
                    }
                    return info;
                }
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
        return null;
    }

    private static FuzzyXMLElement getNameElement(FuzzyXMLDocument doc, String value) {
        FuzzyXMLElement root = doc.getDocumentElement();
        return HTMLHyperlinkDetector.getNameFromElement(root, value);
    }

    private static FuzzyXMLElement getNameFromElement(FuzzyXMLElement element, String value) {
        int i;
        if (element.getName().equalsIgnoreCase("a")) {
            FuzzyXMLAttribute[] attrs = element.getAttributes();
            i = 0;
            while (i < attrs.length) {
                if (attrs[i].getName().equalsIgnoreCase("name") && attrs[i].getValue().equals(value)) {
                    return element;
                }
                ++i;
            }
        }
        FuzzyXMLNode[] nodes = element.getChildren();
        i = 0;
        while (i < nodes.length) {
            FuzzyXMLElement result;
            if (nodes[i] instanceof FuzzyXMLElement && (result = HTMLHyperlinkDetector.getNameFromElement((FuzzyXMLElement)nodes[i], value)) != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private int getAttributeValueOffset(String source, FuzzyXMLAttribute attr) {
        int offset = source.indexOf(61, attr.getOffset());
        if (offset == -1) {
            return -1;
        }
        int c = 32;
        while (c == 32 || c == 9 || c == 13 || c == 10 || c == 34 || c == 39) {
            if (source.length() == ++offset + 1) break;
            c = source.charAt(offset);
        }
        return offset;
    }

    private class HTMLHyperlink
    implements IHyperlink {
        private final IRegion region;
        private final Object openObject;
        private int offset = -1;

        public HTMLHyperlink(IRegion region, Object openObject, int offset) {
            this.region = region;
            this.openObject = openObject;
            this.offset = offset;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return null;
        }

        public void open() {
            try {
                if (this.openObject instanceof IFile) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IEditorPart editor = IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)((IFile)this.openObject), (String)"com.poscoict.mobileframework.htmleditor.editors.HTMLEditor", (boolean)true);
                    if (this.offset >= 0 && editor instanceof HTMLEditor) {
                        ((HTMLEditor)editor).getPaletteTarget().selectAndReveal(this.offset, 0);
                    }
                } else if (this.openObject instanceof IJavaElement) {
                    JavaUI.revealInEditor((IEditorPart)JavaUI.openInEditor((IJavaElement)((IJavaElement)this.openObject)), (IJavaElement)((IJavaElement)this.openObject));
                }
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
    }
}

