/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.mobileframework.htmleditor;

import com.poscoict.mobileframework.htmleditor.HTMLPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class FormatterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Spinner indent;
    private Spinner lineChars;
    private Button useTab;

    public FormatterPreferencePage() {
        super(HTMLPlugin.getResourceString("FormatterPreferencePage.Title"));
        this.setPreferenceStore(HTMLPlugin.getDefault().getPreferenceStore());
        this.setDescription(HTMLPlugin.getResourceString("FormatterPreferencePage.Description"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.useTab = new Button(composite, 32);
        this.useTab.setText(HTMLPlugin.getResourceString("FormatterPreferencePage.UseTab"));
        GridData griddata = new GridData();
        griddata.horizontalSpan = 2;
        this.useTab.setLayoutData((Object)griddata);
        this.useTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FormatterPreferencePage.this.updateStatus();
            }
        });
        new Label(composite, 0).setText(HTMLPlugin.getResourceString("FormatterPreferencePage.Indent"));
        this.indent = new Spinner(composite, 2048);
        new Label(composite, 0).setText(HTMLPlugin.getResourceString("FormatterPreferencePage.LineChars"));
        this.lineChars = new Spinner(composite, 2048);
        this.lineChars.setMaximum(1000);
        IPreferenceStore store = this.getPreferenceStore();
        this.useTab.setSelection(store.getBoolean("_pref_formatter_tab"));
        this.indent.setSelection(store.getInt("_pref_formatter_indent"));
        this.lineChars.setSelection(store.getInt("_pref_formatter_line"));
        this.updateStatus();
        return composite;
    }

    private void updateStatus() {
        this.indent.setEnabled(!this.useTab.getSelection());
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.useTab.setSelection(store.getDefaultBoolean("_pref_formatter_tab"));
        this.indent.setSelection(store.getDefaultInt("_pref_formatter_indent"));
        this.lineChars.setSelection(store.getDefaultInt("_pref_formatter_line"));
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("_pref_formatter_tab", this.useTab.getSelection());
        store.setValue("_pref_formatter_indent", this.indent.getSelection());
        store.setValue("_pref_formatter_line", this.lineChars.getSelection());
        return true;
    }
}

