CREATE TABLE SERVICE_INFO (
    SERVICE_NAME VARCHAR2(100) NOT NULL,
    INITIAL_ACTIVITY VARCHAR2(100) NOT NULL,
    constraint PK_SERVICE primary key (SERVICE_NAME)
) ;

CREATE TABLE SERVICE_TX_MAPPING  (
    SERVICE_NAME VARCHAR2(100) NOT NULL,
    TX_NAME VARCHAR2(50) NOT NULL,
    TX_VAL VARCHAR2(5) NOT NULL,
    constraint PK_SERVICE_TX primary key (SERVICE_NAME,TX_NAME),
    constraint FK_SERVICE_TX foreign key (SERVICE_NAME) references SERVICE_INFO(SERVICE_NAME)
) ;

CREATE TABLE SERVICE_ACTIVITY_INFO  (
    SERVICE_NAME VARCHAR2(100) NOT NULL,
    ACTIVITY_NAME VARCHAR2(100) NOT NULL,
    ACTIVITY_CLASS VARCHAR2(500) NOT NULL ,
    constraint PK_ACTIVITY primary key (SERVICE_NAME,ACTIVITY_NAME),
    constraint FK_ACTIVITY foreign key (SERVICE_NAME) references SERVICE_INFO(SERVICE_NAME)
) ;

CREATE TABLE SERVICE_ACTIVITY_FLOW  (
    SERVICE_NAME VARCHAR2(100) NOT NULL,
    ACTIVITY_NAME VARCHAR2(100) NOT NULL,
    TRANSITION_NAME VARCHAR2(50) NOT NULL,
    TRANSITION_VAL VARCHAR2(100) NOT NULL,
    constraint PK_ACTIVITY_TRANSITION primary key (SERVICE_NAME,ACTIVITY_NAME,TRANSITION_NAME),
    constraint FK_ACTIVITY_TRANSITION foreign key (SERVICE_NAME,ACTIVITY_NAME) references SERVICE_ACTIVITY_INFO(SERVICE_NAME,ACTIVITY_NAME)
) ;

CREATE TABLE SERVICE_ACTIVITY_PROPERTY  (
    SERVICE_NAME VARCHAR2(100) NOT NULL,
    ACTIVITY_NAME VARCHAR2(100) NOT NULL,
    PROPERTY_NAME VARCHAR2(100) NOT NULL,
    PROPERTY_VAL VARCHAR2(2000) NOT NULL,
    constraint PK_ACTIVITY_PROPERTY primary key (SERVICE_NAME,ACTIVITY_NAME,PROPERTY_NAME),
    constraint FK_ACTIVITY_PROPERTY foreign key (SERVICE_NAME,ACTIVITY_NAME) references SERVICE_ACTIVITY_INFO(SERVICE_NAME,ACTIVITY_NAME)
) ;
