/* Create Sequences */

CREATE SEQUENCE SQ_TASK_EXECUTION_ID;
CREATE SEQUENCE SQ_JOB_EXECUTION_ID;



/* Create Tables */

-- TASK
CREATE TABLE SCHEDULED_TASK_HISTORY
(
	EXECUTION_ID number NOT NULL,
	SERVICE_NAME varchar2(50),
	START_TIME timestamp NOT NULL,
	END_TIME timestamp DEFAULT NULL ,
	STATUS varchar2(10),
	LAST_UPDATED timestamp,
	ERROR_MESSAGE varchar2(2500),
	CONSTRAINT SYS_C0016033 PRIMARY KEY (EXECUTION_ID)
);


-- JOB 
CREATE TABLE SCHEDULED_JOB_HISTORY
(
	EXECUTION_ID number NOT NULL,
	INSTANCE_NAME varchar2(80) NOT NULL,
	TRIGGER_NAME varchar2(80) NOT NULL,
	TRIGGER_GROUP varchar2(80) NOT NULL,
	JOB_NAME varchar2(80) NOT NULL,
	JOB_GROUP varchar2(80) NOT NULL,
	START_TIME timestamp NOT NULL,
	END_TIME timestamp,
	NEXT_START_TIME timestamp,
	STATUS varchar2(16) NOT NULL,
	LAST_UPDATED timestamp NOT NULL,
	SERVER_ADDRESS varchar2(40),
	SERVER_PORT varchar2(10),
	IS_VOLATILE varchar2(1),
	IS_STATEFUL varchar2(1),
	REQUESTS_RECOVERY varchar2(1),
	RESULT_FLAG varchar2(1),
	JOB_DATA varchar2(4000),
	CONSTRAINT SYS_C0016044 PRIMARY KEY (EXECUTION_ID)
);



/* Comments */

COMMENT ON TABLE SCHEDULED_TASK_HISTORY IS 'SCHEDULED_TASK_HISTORY : TASK';
COMMENT ON COLUMN SCHEDULED_TASK_HISTORY.EXECUTION_ID IS 'EXECUTION_ID';
COMMENT ON COLUMN SCHEDULED_TASK_HISTORY.SERVICE_NAME IS 'SERVICE_NAME';
COMMENT ON COLUMN SCHEDULED_TASK_HISTORY.START_TIME IS 'START_TIME';
COMMENT ON COLUMN SCHEDULED_TASK_HISTORY.END_TIME IS 'END_TIME';
COMMENT ON COLUMN SCHEDULED_TASK_HISTORY.STATUS IS 'STATUS';
COMMENT ON COLUMN SCHEDULED_TASK_HISTORY.LAST_UPDATED IS 'LAST_UPDATED';
COMMENT ON COLUMN SCHEDULED_TASK_HISTORY.ERROR_MESSAGE IS 'ERROR_MESSAGE';
COMMENT ON TABLE SCHEDULED_JOB_HISTORY IS 'SCHEDULED_JOB_HISTORY : JOB ';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.EXECUTION_ID IS 'EXECUTION_ID';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.INSTANCE_NAME IS 'INSTANCE_NAME';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.TRIGGER_NAME IS 'TRIGGER_NAME';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.TRIGGER_GROUP IS 'TRIGGER_GROUP';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.JOB_NAME IS 'JOB_NAME';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.JOB_GROUP IS 'JOB_GROUP';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.START_TIME IS 'START_TIME';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.END_TIME IS 'END_TIME';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.NEXT_START_TIME IS 'NEXT_START_TIME';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.STATUS IS 'STATUS';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.LAST_UPDATED IS 'LAST_UPDATED';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.SERVER_ADDRESS IS 'SERVER_ADDRESS';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.SERVER_PORT IS 'SERVER_PORT';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.IS_VOLATILE IS 'IS_VOLATILE';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.IS_STATEFUL IS 'IS_STATEFUL';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.REQUESTS_RECOVERY IS 'REQUESTS_RECOVERY';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.RESULT_FLAG IS 'RESULT_FLAG';
COMMENT ON COLUMN SCHEDULED_JOB_HISTORY.JOB_DATA IS 'JOB_DATA';



