/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.scheduling.server;

import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.scheduling.remote.GlueDefaultJobEventProcessor;
import com.poscoict.glueframework.scheduling.server.GlueHttpServerProtocolCodecFactory;
import com.poscoict.glueframework.scheduling.server.GlueServerHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.filter.LoggingFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class GlueSchedulerHttpServer {
    private static final Logger a = LoggerFactory.getLogger(GlueSchedulerHttpServer.class);
    private Scheduler b;
    private int c = 8805;
    private String d = "127.0.0.1";

    public GlueSchedulerHttpServer() {
        String string = GlueStaticContext.getSystemProperty((String)"glue.scheduler.server.port");
        String string2 = GlueStaticContext.getSystemProperty((String)"glue.scheduler.server.address");
        a.info("server address from property - {}:{}", (Object)string2, (Object)string);
        if (string2 == null || string2.length() == 0) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                this.d = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                a.error("Fail to get server address..");
                this.d = "127.0.0.1";
            }
            System.setProperty("glue.scheduler.server.address", this.d);
        } else {
            this.d = string2;
        }
        try {
            this.c = string != null && string.length() > 0 ? Integer.valueOf(string) : 8805;
            System.setProperty("glue.scheduler.server.port", String.valueOf(this.c));
        }
        catch (Exception exception) {
            a.error("Fail to configure server port:{}", (Object)string);
            a.error("so, default server port is configured :{}", (Object)8805);
            this.c = 8805;
        }
        a.info("server address - {}:{}", (Object)this.d, (Object)this.c);
    }

    public Scheduler getScheduler() {
        return this.b;
    }

    public int getPort() {
        return this.c;
    }

    public String getAddress() {
        return this.d;
    }

    public static void main(String[] stringArray) {
        try {
            GlueStaticContext.getBeanFactory();
            GlueSchedulerHttpServer glueSchedulerHttpServer = new GlueSchedulerHttpServer();
            if (stringArray.length == 0) {
                a.info("try to launch Quartz using '{}'", (Object)"quartz_scheduler.xml");
                glueSchedulerHttpServer.a("quartz_scheduler.xml");
                glueSchedulerHttpServer.a(glueSchedulerHttpServer.c);
            } else if (stringArray.length > 1 && stringArray[0].equalsIgnoreCase("quartz")) {
                a.info("try to launch Quartz Scheduler using '{}'", (Object)stringArray[1]);
                glueSchedulerHttpServer.a(stringArray[1]);
                glueSchedulerHttpServer.a(glueSchedulerHttpServer.c);
            } else if (stringArray.length > 1 && stringArray[0].equalsIgnoreCase("spring")) {
                a.info("try to launch Task Scheduler using '{}'", (Object)stringArray[1]);
                glueSchedulerHttpServer.b(stringArray[1]);
            } else {
                System.out.println();
                System.out.println("Usage : java [-options] -jar jarfile [args...]");
                System.out.println();
                System.out.println("The following options are available:");
                System.out.println("     -DCONFING_PATH=<value>                       the location of 'glue.properties'");
                System.out.println("     -Dglue.scheduler.server.port=<value>         default is 8805");
                System.out.println("     -Dglue.scheduler.server.address=<value>      the host address");
                System.out.println("Two arguments are required.");
                System.out.println("     The first is 'quartz' or 'spring'.");
                System.out.println("     The second is a file name like 'quartz_scheduler.xml' or 'spring_schduler.xml'.");
            }
        }
        catch (Throwable throwable) {
            a.error("Fail to execute GlueSchedulerHttpServer:" + throwable.getMessage(), throwable);
            GlueStaticContext.destroyApplictionContext();
            System.exit(-1);
        }
    }

    private void a(String string) {
        ClassPathXmlApplicationContext classPathXmlApplicationContext = new ClassPathXmlApplicationContext(string);
        this.b = (Scheduler)classPathXmlApplicationContext.getBean("scheduler", Scheduler.class);
    }

    private void b(String string) {
        ClassPathXmlApplicationContext classPathXmlApplicationContext = new ClassPathXmlApplicationContext(string);
    }

    private void a(int n) throws IOException {
        SocketAcceptor socketAcceptor = new SocketAcceptor();
        SocketAcceptorConfig socketAcceptorConfig = new SocketAcceptorConfig();
        socketAcceptorConfig.setReuseAddress(true);
        socketAcceptorConfig.getFilterChain().addLast("protocolFilter", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new GlueHttpServerProtocolCodecFactory()));
        socketAcceptorConfig.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        socketAcceptor.bind((SocketAddress)new InetSocketAddress(n), (IoHandler)new GlueServerHandler(new GlueDefaultJobEventProcessor(this.b)), (IoServiceConfig)socketAcceptorConfig);
        a.debug(socketAcceptor.getManagedServiceAddresses().toString());
        a.debug(socketAcceptor.getDefaultConfig().toString());
        a.info("Server now listening on port {}", (Object)n);
    }
}

