/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.scheduling.server;

import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.scheduling.server.GlueHttpRequestMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.demux.MessageDecoderAdapter;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;
import org.apache.mina.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlueHttpRequestDecoder
extends MessageDecoderAdapter {
    private final Logger a = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final byte[] b = new String("Content-Length:").getBytes();
    private final CharsetDecoder c = CharsetUtil.getDefaultCharset().newDecoder();
    private GlueHttpRequestMessage d = null;
    private final String e = this.a();

    public GlueHttpRequestDecoder() {
        this.a.debug("URL Decoder Charset : {}", (Object)this.e);
    }

    private String a() {
        String string = "EUC-KR";
        try {
            string = GlueStaticContext.getSystemProperty((String)"glue.scheduler.server.urldecoder.charset");
            string = string == null || "".equals(string) ? "EUC-KR" : string;
        }
        catch (Exception exception) {
            this.a.warn("Fail to get url decoder charset: {}", (Object)exception.getMessage());
            this.a.warn("Default charset is applied 'euc-kr'");
        }
        return string;
    }

    public MessageDecoderResult decodable(IoSession ioSession, ByteBuffer byteBuffer) {
        try {
            return this.a(byteBuffer) ? MessageDecoderResult.OK : MessageDecoderResult.NEED_DATA;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return MessageDecoderResult.NOT_OK;
        }
    }

    public MessageDecoderResult decode(IoSession ioSession, ByteBuffer byteBuffer, ProtocolDecoderOutput protocolDecoderOutput) throws Exception {
        GlueHttpRequestMessage glueHttpRequestMessage = this.b(byteBuffer);
        if (glueHttpRequestMessage == null) {
            return MessageDecoderResult.NEED_DATA;
        }
        protocolDecoderOutput.write((Object)glueHttpRequestMessage);
        return MessageDecoderResult.OK;
    }

    private boolean a(ByteBuffer byteBuffer) throws Exception {
        int n = byteBuffer.remaining() - 1;
        if (byteBuffer.remaining() < 4) {
            return false;
        }
        if (byteBuffer.get(0) == 71 && byteBuffer.get(1) == 69 && byteBuffer.get(2) == 84) {
            return byteBuffer.get(n) == 10 && byteBuffer.get(n - 1) == 13 && byteBuffer.get(n - 2) == 10 && byteBuffer.get(n - 3) == 13;
        }
        if (byteBuffer.get(0) == 80 && byteBuffer.get(1) == 79 && byteBuffer.get(2) == 83 && byteBuffer.get(3) == 84) {
            int n2;
            int n3 = -1;
            for (n2 = n; n2 > 2; --n2) {
                if (byteBuffer.get(n2) != 10 || byteBuffer.get(n2 - 1) != 13 || byteBuffer.get(n2 - 2) != 10 || byteBuffer.get(n2 - 3) != 13) continue;
                n3 = n2 + 1;
                break;
            }
            if (n3 == -1) {
                return false;
            }
            for (n2 = 0; n2 < n; ++n2) {
                boolean bl = false;
                for (int i = 0; i < b.length; ++i) {
                    if (byteBuffer.get(n2 + i) != b[i]) {
                        bl = false;
                        break;
                    }
                    bl = true;
                }
                if (!bl) continue;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = n2 + b.length; i < n && byteBuffer.get(i) != 13; ++i) {
                    stringBuffer.append(new String(new byte[]{byteBuffer.get(i)}));
                }
                return Integer.parseInt(stringBuffer.toString().trim()) + n3 == byteBuffer.remaining();
            }
        }
        return false;
    }

    private Map<String, String[]> b(Map<String, String[]> map) throws UnsupportedEncodingException {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>(map.size());
        for (String string : map.keySet()) {
            Object object;
            String[] stringArray = map.get(string);
            String string2 = null;
            string2 = stringArray instanceof String[] ? (((String[])(object = stringArray)).length == 0 ? "" : object[0]) : (String)stringArray;
            object = URLDecoder.decode(string2, this.e);
            hashMap.put(string, new String[]{object});
        }
        return hashMap;
    }

    protected String a(Map<String, String[]> map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : map.keySet()) {
            String[] stringArray = map.get(string);
            String string2 = stringArray.length == 0 ? "" : stringArray[0];
            stringBuffer.append(string).append("=").append(string2).append(",");
        }
        return stringBuffer.toString();
    }

    private GlueHttpRequestMessage b(ByteBuffer byteBuffer) {
        this.d = new GlueHttpRequestMessage();
        try {
            Map<String, String[]> map = this.a(new StringReader(byteBuffer.getString(this.c)));
            try {
                map = this.b(map);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.a.error("Cannot decode parsedRequests: {}", (Object)unsupportedEncodingException.getMessage());
            }
            this.d.setHeaders(map);
            return this.d;
        }
        catch (CharacterCodingException characterCodingException) {
            this.a.error(characterCodingException.getMessage(), (Throwable)characterCodingException);
            return null;
        }
    }

    private Map<String, String[]> a(Reader reader) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String string = bufferedReader.readLine();
            String[] stringArray = string.split(" ");
            if (stringArray.length < 3) {
                return hashMap;
            }
            hashMap.put("URI", new String[]{string});
            hashMap.put("Method", new String[]{stringArray[0].toUpperCase()});
            hashMap.put("Context", new String[]{stringArray[1].substring(1)});
            hashMap.put("Protocol", new String[]{stringArray[2]});
            while ((string = bufferedReader.readLine()) != null && string.length() > 0) {
                String[] stringArray2 = string.split(": ");
                hashMap.put(stringArray2[0], new String[]{stringArray2[1]});
            }
            if (stringArray[0].equalsIgnoreCase("POST")) {
                int n = Integer.parseInt(((String[])hashMap.get("Content-Length"))[0]);
                char[] cArray = new char[n];
                if (bufferedReader.read(cArray) == n) {
                    string = String.copyValueOf(cArray);
                }
            } else if (stringArray[0].equalsIgnoreCase("GET")) {
                int n = stringArray[1].indexOf(63);
                if (n != -1) {
                    hashMap.put("Context", new String[]{stringArray[1].substring(1, n)});
                    string = stringArray[1].substring(n + 1);
                } else {
                    string = null;
                }
            }
            if (string != null) {
                String[] stringArray3 = string.split("\\&");
                block7: for (int i = 0; i < stringArray3.length; ++i) {
                    String[] stringArray4 = new String[1];
                    String[] stringArray5 = stringArray3[i].split("=");
                    switch (stringArray5.length) {
                        case 0: {
                            hashMap.put("@".concat(stringArray3[i]), new String[0]);
                            continue block7;
                        }
                        case 1: {
                            hashMap.put("@".concat(stringArray5[0]), new String[0]);
                            continue block7;
                        }
                        default: {
                            String string2 = "@".concat(stringArray5[0]);
                            if (hashMap.containsKey(string2)) {
                                stringArray4 = (String[])hashMap.get(string2);
                                String[] stringArray6 = new String[stringArray4.length + 1];
                                for (int j = 0; j < stringArray4.length; ++j) {
                                    stringArray6[j] = stringArray4[j];
                                }
                                stringArray4 = null;
                                stringArray4 = stringArray6;
                            }
                            stringArray4[stringArray4.length - 1] = stringArray5[1].trim();
                            hashMap.put(string2, stringArray4);
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashMap;
    }
}

