/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.scheduling.remote;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.scheduling.GlueSchedulerException;
import com.poscoict.glueframework.scheduling.remote.GlueJobDefinition;
import com.poscoict.glueframework.scheduling.remote.GlueJobEventSender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class GlueHttpJobEventSender
implements GlueJobEventSender,
InitializingBean {
    private final Logger b = LoggerFactory.getLogger(this.getClass());
    protected static final String a = "http://";
    private String c;
    private String d;
    private int e;
    private String f = "EUC-KR";

    public GlueHttpJobEventSender() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.d = inetAddress.getHostAddress();
            this.b.info("Local host address :{}", (Object)this.d);
        }
        catch (UnknownHostException unknownHostException) {
            throw new GlueException("Cannot get localhost address -" + unknownHostException.getMessage());
        }
        this.e = 2;
        this.b.info("Http request retry count :{}", (Object)this.e);
    }

    public String getAddress() {
        return this.d;
    }

    public void setAddress(String string) {
        this.d = string;
    }

    public int getRetryCount() {
        return this.e;
    }

    public void setRetryCount(int n) {
        this.e = n;
    }

    @Override
    public String sendJobEvent(GlueJobDefinition glueJobDefinition, String string) {
        if (string == null) {
            throw new GlueSchedulerException("Cannot sent JobEvent, 'scheduler server target url' is null");
        }
        if (string.indexOf(a) == -1) {
            string = a + string;
        }
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(string);
        postMethod.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + this.f);
        postMethod.setRequestBody(this.a(glueJobDefinition));
        postMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(this.e, false));
        String string2 = null;
        try {
            int n = httpClient.executeMethod((HttpMethod)postMethod);
            if (n != 700) {
                this.b.error("Method failed: {}", (Object)postMethod.getStatusLine());
            }
            string2 = new String(postMethod.getResponseBody());
            this.b.info("Response Body :{}", (Object)string2);
            this.b.info("Status Line :{}", (Object)postMethod.getStatusLine());
        }
        catch (HttpException httpException) {
            throw new GlueException("Fatal protocol violation: " + httpException.getMessage(), (Throwable)httpException);
        }
        catch (IOException iOException) {
            throw new GlueException("Fatal transport error: " + iOException.getMessage(), (Throwable)iOException);
        }
        finally {
            postMethod.releaseConnection();
        }
        return string2;
    }

    @Override
    public String sendJobEvent(GlueJobDefinition glueJobDefinition) {
        if (this.c == null) {
            String string = GlueStaticContext.getSystemProperty((String)"glue.scheduler.server.targeturl");
            if (string == null) {
                throw new GlueSchedulerException("Plz specify 'scheduler server target url' via java option: like that '-Dglue.scheduler.server.targeturl=127.0.0.1:8805/glue-scheduler'");
            }
            if (string.indexOf(a) == -1) {
                this.c = a + string;
            }
        }
        this.b.info("Scheduler Server Target URL : {}", (Object)this.c);
        return this.sendJobEvent(glueJobDefinition, this.c);
    }

    protected NameValuePair[] a(GlueJobDefinition glueJobDefinition) {
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        arrayList.add(new NameValuePair("request_id", glueJobDefinition.getRequestId()));
        arrayList.add(new NameValuePair("job_name", glueJobDefinition.getJobName()));
        arrayList.add(new NameValuePair("client_ip", this.d));
        Map<String, Object> map = glueJobDefinition.getParameters();
        if (map != null && map.size() > 0) {
            for (Object e : map.keySet()) {
                Object object = map.get(e);
                String string = object != null ? object.toString() : "";
                arrayList.add(new NameValuePair("jobParam-" + e, string));
            }
        }
        this.b.debug(arrayList.toString());
        NameValuePair[] nameValuePairArray = new NameValuePair[arrayList.size()];
        nameValuePairArray = arrayList.toArray(nameValuePairArray);
        return nameValuePairArray;
    }

    public String getCharset() {
        return this.f;
    }

    public void setCharset(String string) {
        this.f = string;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

