/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.util;

import com.poscoict.glueframework.GlueException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlueFileResourceUtil {
    private static final Logger a = LoggerFactory.getLogger(GlueFileResourceUtil.class);

    public static URL getResource(String string) throws GlueException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        if (uRL == null) {
            String string2 = string.replaceAll("\\\\", "/");
            uRL = Thread.currentThread().getContextClassLoader().getResource(string2);
            if (uRL == null) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append(" - File not found from class root path");
                URL uRL2 = Thread.currentThread().getContextClassLoader().getResource(File.pathSeparator);
                if (uRL2 == null) {
                    uRL2 = Thread.currentThread().getContextClassLoader().getResource("/");
                }
                stringBuffer.append("[").append(uRL2.getPath()).append("]");
                throw new GlueException(stringBuffer.toString());
            }
        }
        return uRL;
    }

    public static InputStream getResourceAsStream(String string) throws GlueException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            String string2 = string.replaceAll("\\\\", "/");
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string2);
            if (inputStream == null) {
                StringBuffer stringBuffer = new StringBuffer("File not found from class root path");
                URL uRL = Thread.currentThread().getContextClassLoader().getResource(File.pathSeparator);
                if (uRL == null) {
                    uRL = Thread.currentThread().getContextClassLoader().getResource("/");
                }
                stringBuffer.append("[" + uRL.getPath() + "]");
                throw new GlueException(stringBuffer.toString());
            }
        }
        return inputStream;
    }

    public static List<File> getListOfFiles(File file) {
        File[] fileArray;
        File[] fileArray2;
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.isFile()) {
            File[] fileArray3 = new File[1];
            fileArray2 = fileArray3;
            fileArray3[0] = file;
        } else {
            fileArray2 = fileArray = file.listFiles();
        }
        if (fileArray == null || fileArray.length == 0) {
            return arrayList;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                arrayList.addAll(GlueFileResourceUtil.getListOfFiles(fileArray[i]));
                continue;
            }
            if (!fileArray[i].isFile()) continue;
            arrayList.add(fileArray[i]);
        }
        return arrayList;
    }

    public static List<File> getListOfFiles(File file, boolean bl) {
        File[] fileArray;
        File[] fileArray2;
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.isFile()) {
            File[] fileArray3 = new File[1];
            fileArray2 = fileArray3;
            fileArray3[0] = file;
        } else {
            fileArray2 = fileArray = file.listFiles();
        }
        if (fileArray == null || fileArray.length == 0) {
            return arrayList;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory() && bl) {
                arrayList.addAll(GlueFileResourceUtil.getListOfFiles(fileArray[i]));
                continue;
            }
            if (!fileArray[i].isFile()) continue;
            arrayList.add(fileArray[i]);
        }
        return arrayList;
    }

    public static List<String> readFile(File file) throws GlueException {
        return GlueFileResourceUtil.readFile(file, Charset.defaultCharset());
    }

    public static List<String> readFile(File file, Charset charset) throws GlueException {
        ArrayList<String> arrayList = new ArrayList<String>();
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().length() == 0) {
                    break;
                }
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            throw new GlueException("Fail to read line from file. - " + exception.getMessage());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    a.warn("Fail to close reader stream: {}", (Object)exception.getMessage());
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {
                    a.warn("Fail to close reader stream: {}", (Object)exception.getMessage());
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    a.warn("Fail to close input stream: {}", (Object)exception.getMessage());
                }
            }
        }
        return arrayList;
    }
}

