/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.transaction;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.transaction.GlueDefaultTransactionDefinition;
import com.poscoict.glueframework.transaction.GlueTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

public class GlueDataSourceTransactionManager
extends DataSourceTransactionManager
implements GlueTransactionManager {
    private static final long serialVersionUID = 6430886423996455800L;
    private final Logger a = LoggerFactory.getLogger(this.getClass());
    private TransactionDefinition b = null;
    private final ThreadLocal<TransactionStatus> c = new ThreadLocal();

    private TransactionStatus a() {
        return this.c.get();
    }

    public void setTransactionDefinition(TransactionDefinition transactionDefinition) {
        this.b = transactionDefinition;
        this.a.info("[{}] transaction definition is re-configured -> {}", (Object)transactionDefinition.getName(), (Object)transactionDefinition.toString());
    }

    @Override
    public void startTransaction() throws GlueException {
        TransactionStatus transactionStatus = this.a();
        if (transactionStatus == null) {
            transactionStatus = this.getTransaction(this.b);
            this.c.set(transactionStatus);
            this.a.info("Transaction Start");
        } else {
            this.a.warn("------------------------------------------");
            this.a.warn("Already transaction was started!!");
            this.a.warn("Do not invoke 'startTransaction' twice!!");
            this.a.warn("------------------------------------------");
        }
    }

    @Override
    public boolean commit() throws GlueException {
        try {
            TransactionStatus transactionStatus = this.a();
            if (transactionStatus == null) {
                this.a.warn("Transaction Status is empty. Commit operation is aborted");
                boolean bl = false;
                return bl;
            }
            super.commit(transactionStatus);
            this.a.info("Commit Complete");
        }
        catch (TransactionException transactionException) {
            this.a.info("fail to Commit");
            throw new GlueException(transactionException.getMessage(), transactionException);
        }
        finally {
            this.c.remove();
            this.a.info("Transaction Status is cleared");
        }
        return true;
    }

    @Override
    public boolean rollback() throws GlueException {
        try {
            TransactionStatus transactionStatus = this.a();
            if (transactionStatus == null) {
                this.a.warn("Transaction Status is empty. Rollback operation is aborted");
                boolean bl = false;
                return bl;
            }
            super.rollback(transactionStatus);
            this.a.info("Rollback Complete");
        }
        catch (TransactionException transactionException) {
            this.a.info("fail to Rollback");
            throw new GlueException(transactionException.getMessage(), transactionException);
        }
        finally {
            this.c.remove();
            this.a.info("Transaction Status is cleared");
        }
        return true;
    }

    @Override
    public TransactionStatus changeTransaction(TransactionStatus transactionStatus) throws GlueException {
        TransactionStatus transactionStatus2 = this.a();
        this.c.remove();
        try {
            if (transactionStatus == null) {
                this.a.info("creating new Transaction");
                this.startTransaction();
            } else {
                if (transactionStatus2 != null && !transactionStatus2.isCompleted()) {
                    this.a.warn("previous transaction is not completed...");
                }
                this.c.set(transactionStatus);
                this.a.info("TransactionStatus in ThreadLocal is changed: input transaction");
            }
        }
        catch (TransactionException transactionException) {
            throw new GlueException(transactionException.getMessage(), transactionException);
        }
        return transactionStatus2;
    }

    public void afterPropertiesSet() {
        if (this.b == null) {
            this.b = new GlueDefaultTransactionDefinition();
        }
        super.afterPropertiesSet();
    }
}

