/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.message.layout;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.dao.jdbc.GlueGenericJdbcDao;
import com.poscoict.glueframework.dao.vo.GlueParameter;
import com.poscoict.glueframework.message.GlueMESMessageImpl;
import com.poscoict.glueframework.message.GlueMessage;
import com.poscoict.glueframework.message.GlueMessageAttributeDefinition;
import com.poscoict.glueframework.message.layout.GlueAbstractFixedLengthMessageLayout;
import com.poscoict.glueframework.message.layout.GlueMessageDefinitionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class GlueDBMessageLayout
extends GlueAbstractFixedLengthMessageLayout {
    private GlueGenericJdbcDao b = null;
    private String c = null;

    public GlueGenericJdbcDao getDao() {
        return this.b;
    }

    public void setDao(GlueGenericJdbcDao glueGenericJdbcDao) {
        this.b = glueGenericJdbcDao;
    }

    public String getQueryId() {
        return this.c;
    }

    public void setQueryId(String string) {
        this.c = string;
    }

    @Override
    public List<GlueMessageAttributeDefinition> getAttributesDefinition(String string) throws GlueMessageDefinitionException {
        ArrayList<GlueMessageAttributeDefinition> arrayList = new ArrayList<GlueMessageAttributeDefinition>();
        try {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(string);
            List list = this.b.find(this.c, new GlueParameter(arrayList2));
            for (Map map : list) {
                GlueMessageAttributeDefinition glueMessageAttributeDefinition = new GlueMessageAttributeDefinition();
                if (map.get("MDL_DEFINE_DT_NM_SEQ") == null) {
                    throw new GlueMessageDefinitionException("seq couldn't be null!!");
                }
                glueMessageAttributeDefinition.setSeq(Integer.parseInt(map.get("MDL_DEFINE_DT_NM_SEQ").toString()));
                glueMessageAttributeDefinition.setType((String)map.get("MDL_DEFINE_DT_NM_GROUP_TP"));
                glueMessageAttributeDefinition.setId((String)map.get("STANDARD_ENGLISH_ID"));
                glueMessageAttributeDefinition.setName((String)map.get("STANDARD_KOREAN_NAME"));
                if (map.get("MDL_DEFINE_DT_NM_DATA_TP") == null) {
                    throw new GlueMessageDefinitionException("datatype couldn't be null!!");
                }
                Number number = (Number)map.get("MDL_DEFINE_DT_NM_DATA_TP");
                if (number.intValue() == 2) {
                    glueMessageAttributeDefinition.setDatatype("NUMBER");
                    if (map.get("MDL_DEFINE_DT_NM_V_DECI_PREC") == null) {
                        throw new GlueMessageDefinitionException("precision couldn't be null!!");
                    }
                    glueMessageAttributeDefinition.setPrecision(Integer.parseInt(map.get("MDL_DEFINE_DT_NM_V_DECI_PREC").toString()));
                } else if (number.intValue() == 3 || number.intValue() == 4) {
                    glueMessageAttributeDefinition.setDatatype("DATE");
                    glueMessageAttributeDefinition.setPrecision(0);
                } else if (number.intValue() == 6) {
                    glueMessageAttributeDefinition.setDatatype("ARRAY");
                    glueMessageAttributeDefinition.setPrecision(0);
                } else {
                    glueMessageAttributeDefinition.setDatatype("STRING");
                    glueMessageAttributeDefinition.setPrecision(0);
                }
                if (map.get("MDL_DEFINE_DT_NM_LEN") == null) {
                    throw new GlueMessageDefinitionException("length couldn't be null!!");
                }
                glueMessageAttributeDefinition.setLength(Integer.parseInt(map.get("MDL_DEFINE_DT_NM_LEN").toString()));
                arrayList.add(glueMessageAttributeDefinition);
            }
        }
        catch (Exception exception) {
            throw new GlueMessageDefinitionException("Message Definition loading error!!", exception);
        }
        if (arrayList.size() == 0) {
            throw new GlueMessageDefinitionException("Message Definition doesn't exist!! [" + string + "]");
        }
        return arrayList;
    }

    @Override
    public GlueMessage createMessageObject(String string) {
        GlueMESMessageImpl glueMESMessageImpl = new GlueMESMessageImpl();
        glueMESMessageImpl.setTC(string);
        return glueMESMessageImpl;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.b, (String)"GlueGenericJdbcDao must be provided");
        if (this.c == null) {
            this.a.info("try to set 'queryId' using 'get_msg_layout_query' in applicationContext.xml");
            this.c = "get_msg_layout_query";
        }
        if (this.b.getQueryManager().getQueryDefinition(this.c) == null) {
            throw new GlueException("Incorrect query id [" + this.c + "]");
        }
    }
}

