/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.message.layout;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.cache.GlueCacheManager;
import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.message.GlueMessage;
import com.poscoict.glueframework.message.GlueMessageAttributeDefinition;
import com.poscoict.glueframework.message.GlueMessageDefinition;
import com.poscoict.glueframework.message.layout.GlueMessageDefinitionException;
import com.poscoict.glueframework.message.layout.GlueMessageLayout;
import com.poscoict.glueframework.message.layout.GlueMessageParserException;
import com.poscoict.glueframework.message.layout.GlueMessageUtil;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class GlueAbstractFixedLengthMessageLayout
implements GlueMessageLayout,
DisposableBean,
InitializingBean {
    public static final String MSG_TYPE_BYTE = "byte";
    public static final String MSG_TYPE_STRING = "string";
    public static final String RULE_NUMBER_NULL_TO_ZERO = "NULL_TO_ZERO_WHEN_TYPE_IS_NUMBER";
    public static final String RULE_STRING_ZERO_TO_SPACE = "ZERO_TO_SPACE_WHEN_TYPE_IS_STRING";
    protected Logger a = LoggerFactory.getLogger(this.getClass());
    private String b = null;
    private Set<String> c = null;
    private Charset d = Charset.defaultCharset();
    private GlueCacheManager e = null;

    public GlueCacheManager getCacheManager() {
        return this.e;
    }

    public void setCacheManager(GlueCacheManager glueCacheManager) {
        this.e = glueCacheManager;
    }

    public String getMsgParsingType() {
        return this.b;
    }

    public void setMsgParsingType(String string) {
        this.b = string;
        this.a.info("changed Message Parsing Type : {}", (Object)this.b);
    }

    public Set<String> getMsgParsingRule() {
        return this.c;
    }

    public void setMsgParsingRule(Set<String> set) {
        this.c = set;
    }

    public Charset getCharset() {
        return this.d;
    }

    public void setCharset(Charset charset) {
        this.d = charset;
    }

    @Override
    public String makeMessageString(GlueMessageDefinition glueMessageDefinition, GlueMessage glueMessage) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = glueMessageDefinition.getLength();
        for (int i = 0; i < n; ++i) {
            GlueMessageAttributeDefinition glueMessageAttributeDefinition = glueMessageDefinition.getAttribute(i);
            if ("G".equals(glueMessageAttributeDefinition.getType())) {
                List<GlueMessageAttributeDefinition> list = glueMessageDefinition.getGroupAttrs(i);
                int n2 = glueMessageAttributeDefinition.getLength();
                for (int j = 0; j < n2; ++j) {
                    int n3 = list.size();
                    for (int k = 0; k < n3; ++k) {
                        glueMessageAttributeDefinition = list.get(k);
                        stringBuffer.append(this.a(glueMessageAttributeDefinition, glueMessage, j));
                    }
                }
                continue;
            }
            if (!"E".equals(glueMessageAttributeDefinition.getType())) continue;
            stringBuffer.append(this.a(glueMessageAttributeDefinition, glueMessage, 0));
        }
        return stringBuffer.toString();
    }

    private String a(GlueMessageAttributeDefinition glueMessageAttributeDefinition, GlueMessage glueMessage, int n) {
        String string = "";
        String string2 = glueMessageAttributeDefinition.getDatatype();
        if ("STRING".equals(string2)) {
            string = MSG_TYPE_STRING.equalsIgnoreCase(this.b) ? GlueMessageUtil.getMsgString(glueMessageAttributeDefinition, glueMessage, n) : GlueMessageUtil.getByteMsgString(glueMessageAttributeDefinition, glueMessage, n, this.d);
        } else if ("NUMBER".equals(string2)) {
            string = GlueMessageUtil.getMsgNumber(glueMessageAttributeDefinition, glueMessage, n);
        } else if ("DATE".equals(string2)) {
            string = GlueMessageUtil.getMsgDate(glueMessageAttributeDefinition, glueMessage, n);
        } else {
            this.a.error("Not support Message Type : Attribute ID-{} DataType-{} Value-{}", new Object[]{glueMessageAttributeDefinition.getId(), glueMessageAttributeDefinition.getDatatype(), glueMessage.get(glueMessageAttributeDefinition.getId())});
        }
        this.a.debug("{} = {}", (Object)glueMessageAttributeDefinition.getId(), (Object)string);
        return string;
    }

    @Override
    public GlueMessage makeMessageParsing(GlueMessageDefinition glueMessageDefinition, String string) throws GlueMessageParserException {
        GlueMessage glueMessage = this.createMessageObject(string);
        byte[] byArray = string.getBytes(this.getCharset());
        boolean bl = MSG_TYPE_STRING.equalsIgnoreCase(this.b);
        int n = bl ? string.length() : byArray.length;
        try {
            int n2 = 0;
            int n3 = 0;
            int n4 = glueMessageDefinition.getLength();
            for (int i = 0; i < n4; ++i) {
                Object object;
                GlueMessageAttributeDefinition glueMessageAttributeDefinition = glueMessageDefinition.getAttribute(i);
                if ("G".equals(glueMessageAttributeDefinition.getType())) {
                    int n5;
                    object = glueMessageDefinition.getGroupAttrs(i);
                    int n6 = glueMessageAttributeDefinition.getLength();
                    for (n5 = 0; n5 < n6; ++n5) {
                        int n7 = object.size();
                        for (int j = 0; j < n7; ++j) {
                            CharSequence charSequence;
                            GlueMessageAttributeDefinition glueMessageAttributeDefinition2 = object.get(j);
                            if (n < (n3 += glueMessageAttributeDefinition2.getLength())) {
                                charSequence = new StringBuffer("Short Message Length : Message Attribute-").append(glueMessageAttributeDefinition.getId()).append(n5);
                                ((StringBuffer)charSequence).append(", Message Atttribute Length-").append(n3);
                                ((StringBuffer)charSequence).append(", Message Total Length-").append(n);
                                throw new GlueMessageParserException(((StringBuffer)charSequence).toString());
                            }
                            charSequence = bl ? GlueMessageUtil.rightTrim(string.substring(n2, n3)) : GlueMessageUtil.rightTrim(new String(byArray, n2, glueMessageAttributeDefinition2.getLength(), this.getCharset()));
                            glueMessage.setObject(glueMessageAttributeDefinition2.getId() + n5, this.a(glueMessageAttributeDefinition2, (String)charSequence, n5));
                            n2 = n3;
                        }
                    }
                    n6 = object.size();
                    for (n5 = 0; n5 < n6; ++n5) {
                        GlueMessageAttributeDefinition glueMessageAttributeDefinition3 = object.get(n5);
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        int n8 = glueMessageAttributeDefinition.getLength();
                        for (int j = 0; j < n8; ++j) {
                            arrayList.add(j, glueMessage.get(glueMessageAttributeDefinition3.getId() + j));
                        }
                        glueMessage.setObject(glueMessageAttributeDefinition3.getId(), arrayList);
                    }
                    continue;
                }
                if (!"E".equals(glueMessageAttributeDefinition.getType())) continue;
                if (n >= (n3 += glueMessageAttributeDefinition.getLength())) {
                    object = bl ? GlueMessageUtil.rightTrim(string.substring(n2, n3)) : GlueMessageUtil.rightTrim(new String(byArray, n2, glueMessageAttributeDefinition.getLength(), this.getCharset()));
                    glueMessage.setObject(glueMessageAttributeDefinition.getId(), this.a(glueMessageAttributeDefinition, (String)object, 0));
                    n2 = n3;
                    continue;
                }
                object = new StringBuffer("Short Message Length : Message Attribute-").append(glueMessageAttributeDefinition.getId());
                ((StringBuffer)object).append(", Message Atttribute Length-").append(n3);
                ((StringBuffer)object).append(", Message Total Length-").append(n);
                throw new GlueMessageParserException(((StringBuffer)object).toString());
            }
        }
        catch (GlueMessageParserException glueMessageParserException) {
            throw glueMessageParserException;
        }
        catch (Exception exception) {
            throw new GlueMessageParserException("Message Parseing Error!! - " + exception.getMessage(), exception);
        }
        return glueMessage;
    }

    public abstract GlueMessage createMessageObject(String var1);

    private Object a(GlueMessageAttributeDefinition glueMessageAttributeDefinition, String string, int n) {
        String string2 = glueMessageAttributeDefinition.getDatatype();
        if ("STRING".equals(string2)) {
            if (this.c != null && this.c.contains(RULE_STRING_ZERO_TO_SPACE)) {
                return string.equals("0") ? " " : string;
            }
            return string;
        }
        if ("NUMBER".equals(string2)) {
            if (string != null && string.trim().length() > 0) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(string);
                    if (glueMessageAttributeDefinition.getPrecision() > 0) {
                        bigDecimal = bigDecimal.movePointLeft(glueMessageAttributeDefinition.getPrecision());
                    }
                    return bigDecimal;
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuffer stringBuffer = new StringBuffer("NumberFormatException : Message Attribute-");
                    stringBuffer.append(glueMessageAttributeDefinition.getId()).append(glueMessageAttributeDefinition.getType().equals("GE") ? String.valueOf(n) : "");
                    stringBuffer.append(", Message Data-").append(string);
                    stringBuffer.append(", Data Type-").append(string2);
                    this.a.error(stringBuffer.toString(), (Throwable)numberFormatException);
                    throw new GlueMessageParserException(stringBuffer.toString(), numberFormatException);
                }
            }
            if (this.c != null && this.c.contains(RULE_NUMBER_NULL_TO_ZERO)) {
                return new BigDecimal(0);
            }
        } else if ("DATE".equals(string2)) {
            try {
                return GlueMessageUtil.convertStringToDate(string);
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer("DateFormatException : Message Attribute-");
                stringBuffer.append(glueMessageAttributeDefinition.getId()).append(glueMessageAttributeDefinition.getType().equals("GE") ? String.valueOf(n) : "");
                stringBuffer.append(", Message Data-").append(string);
                stringBuffer.append(", Data Type-").append(string2);
                this.a.error(stringBuffer.toString(), (Throwable)exception);
                throw new GlueMessageParserException(stringBuffer.toString(), exception);
            }
        }
        return null;
    }

    @Override
    public GlueMessageDefinition getAttributes(String string) throws GlueMessageDefinitionException {
        GlueMessageDefinition glueMessageDefinition = (GlueMessageDefinition)this.e.getCacheObject((Object)string, "_message-definition-region");
        if (glueMessageDefinition == null) {
            this.a.info("CacheRegion is not loading MessageDefinition");
            glueMessageDefinition = new GlueMessageDefinition();
            glueMessageDefinition.setAttributes(this.getAttributesDefinition(string));
            this.e.putCacheObject(string, glueMessageDefinition, "_message-definition-region");
        }
        return glueMessageDefinition;
    }

    public abstract List<GlueMessageAttributeDefinition> getAttributesDefinition(String var1);

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.e, (String)"GlueCacheManager must be provided");
        if (this.getMsgParsingType() == null) {
            this.a.info("try to set 'msgParsingType' using 'msg.parsing.type' in glue.properties");
            String string = GlueStaticContext.getGlueProperty("msg.parsing.type");
            if (MSG_TYPE_STRING.equalsIgnoreCase(string)) {
                this.setMsgParsingType(MSG_TYPE_STRING);
            } else if (MSG_TYPE_BYTE.equalsIgnoreCase(string) || string == null || string.trim().length() < 1) {
                this.setMsgParsingType(MSG_TYPE_BYTE);
            } else {
                throw new GlueException("not supported type [" + string + "]");
            }
        }
        this.a.info("Message Parsing Type : {}", (Object)this.getMsgParsingType());
    }

    public void destroy() throws Exception {
        this.e.clear("_message-definition-region");
        this.a.info("clear cache in '{}'", (Object)"_message-definition-region");
    }
}

