/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.dao.jdbc;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.dao.GlueBadSqlGrammarException;
import com.poscoict.glueframework.dao.GlueDaoException;
import com.poscoict.glueframework.dao.GlueDataIntegrityViolationException;
import com.poscoict.glueframework.dao.GlueUncategorizedSQLException;
import com.poscoict.glueframework.dao.jdbc.GlueGenericJdbcDao;
import com.poscoict.glueframework.dao.jdbc.GlueJdbcTemplate;
import com.poscoict.glueframework.dao.manager.GlueColumnManager;
import com.poscoict.glueframework.dao.manager.GlueQueryDefinition;
import com.poscoict.glueframework.dao.manager.GlueQueryManager;
import com.poscoict.glueframework.dao.sequence.GlueSequence;
import com.poscoict.glueframework.dao.sequence.GlueSequenceFactory;
import com.poscoict.glueframework.dao.vo.GlueAuditAttributes;
import com.poscoict.glueframework.dao.vo.GlueColumnDef;
import com.poscoict.glueframework.dao.vo.GluePageSet;
import com.poscoict.glueframework.dao.vo.GluePageSetImpl;
import com.poscoict.glueframework.dao.vo.GlueParameter;
import com.poscoict.glueframework.dao.vo.GlueRow;
import com.poscoict.glueframework.dao.vo.GlueRowImpl;
import com.poscoict.glueframework.dao.vo.GlueRowSet;
import com.poscoict.glueframework.dao.vo.GlueRowSetImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcDaoSupport;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.jdbc.object.SqlUpdate;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;

public class GlueJdbcDao
extends NamedParameterJdbcDaoSupport
implements GlueGenericJdbcDao {
    private final Logger d = LoggerFactory.getLogger(this.getClass());
    protected GlueQueryManager a;
    private GlueColumnManager e = null;
    protected GlueSequence b = null;
    protected LobHandler c = null;
    private int f = 30000;
    private int g = 0;
    private boolean h = false;
    private String i = "unknown DBMS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JdbcTemplate createJdbcTemplate(DataSource dataSource) {
        GlueJdbcTemplate glueJdbcTemplate = new GlueJdbcTemplate(dataSource);
        this.setJdbcTemplate(glueJdbcTemplate);
        try {
            if (this.getDataSource() instanceof SingleConnectionDataSource) {
                this.d.debug("Loaded JDBC Driver: Dummy Single Connection Driver for Master Data Module");
                this.d.debug("real dbms information will be specified after this processing phase...");
            } else {
                Connection connection = null;
                try {
                    connection = DataSourceUtils.getConnection((DataSource)this.getDataSource());
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    this.i = databaseMetaData.getDatabaseProductName();
                    this.d.debug("Loaded JDBC Driver: {}", (Object)databaseMetaData.getDriverName());
                    this.d.debug("Loaded JDBC Driver Version: {}", (Object)databaseMetaData.getDriverVersion());
                    this.d.debug("DBMS Name: {}", (Object)databaseMetaData.getDatabaseProductName());
                    this.d.debug("DBMS Version: {}", (Object)databaseMetaData.getDatabaseProductVersion());
                    this.d.debug("DBMS URL: {}", (Object)databaseMetaData.getURL());
                    this.d.debug("Batch Update: {}", (Object)databaseMetaData.supportsBatchUpdates());
                }
                finally {
                    DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.getDataSource());
                }
            }
            this.b = GlueSequenceFactory.createSequence(this.getDataSource(), this.i);
            this.c = new DefaultLobHandler();
            this.d.info("Default Lob Handler is registered");
        }
        catch (Exception exception) {
            this.d.warn("No Suitable Driver: {}", (Object)exception.getMessage());
        }
        return glueJdbcTemplate;
    }

    @Override
    public GlueQueryManager getQueryManager() {
        return this.a;
    }

    public void setQueryManager(GlueQueryManager glueQueryManager) {
        this.a = glueQueryManager;
    }

    public void setColumnManager(GlueColumnManager glueColumnManager) {
        this.e = glueColumnManager;
    }

    public GlueColumnManager getColumnManager() {
        return this.e;
    }

    public void setTypeCast(boolean bl) {
        this.h = bl;
    }

    @Override
    public GlueSequence getSequence() {
        if (this.b == null) {
            throw new GlueException("Cannot get sequence: sequence object is null");
        }
        return this.b;
    }

    public void setSequence(GlueSequence glueSequence) {
        if (this.b != null) {
            this.d.info("Sequence Increamenter is changed... : {}", (Object)glueSequence);
        } else {
            this.d.info("Custom Sequence Increamenter is setted... : {}", (Object)glueSequence);
        }
        this.b = glueSequence;
    }

    public void setLobHandler(LobHandler lobHandler) {
        if (this.c != null) {
            this.d.info("Lob Handler is changed... : {}", (Object)lobHandler);
        }
        this.c = lobHandler;
    }

    public int getBatchUpdateLimit() {
        return this.f;
    }

    public void setBatchUpdateLimit(int n) {
        this.f = n;
    }

    public void setFetchSize(int n) {
        this.g = n;
    }

    public String getDatabaseProductName() {
        return this.i;
    }

    public Connection getDBConnection() {
        return this.getConnection();
    }

    public void releaseDBConnection(Connection connection) {
        this.releaseConnection(connection);
    }

    @Override
    public <T> List<T> find(String string) {
        return this.find(string, null);
    }

    @Override
    public <T, P> List<T> find(String string, GlueParameter<P> glueParameter) {
        return this.a(this.a(string), glueParameter);
    }

    @Override
    public <T, P> List<T> find(String string, String string2, GlueParameter<P> glueParameter) {
        GlueQueryDefinition glueQueryDefinition = this.a(string);
        boolean bl = glueQueryDefinition.isNamedQuery();
        GlueQueryDefinition glueQueryDefinition2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append("SELECT * FROM ( ");
            stringBuffer.append(glueQueryDefinition.getQueryStatement());
            stringBuffer.append(" ) INNER_QRY_ ");
            stringBuffer.append("WHERE ");
            stringBuffer.append(string2);
            glueQueryDefinition2 = new GlueQueryDefinition(string, stringBuffer.toString(), bl);
        } else {
            glueQueryDefinition2 = new GlueQueryDefinition(string, glueQueryDefinition.getQueryStatement(), bl);
        }
        return this.a(glueQueryDefinition2, glueParameter);
    }

    @Override
    public <T> List<T> findByQueryStatement(String string) {
        return this.findByQueryStatement(string, null);
    }

    @Override
    public <T, P> List<T> findByQueryStatement(String string, GlueParameter<P> glueParameter) {
        boolean bl = glueParameter != null && glueParameter.getParameter() instanceof Map;
        GlueQueryDefinition glueQueryDefinition = new GlueQueryDefinition("undefined", string, bl);
        return this.a(glueQueryDefinition, glueParameter);
    }

    @Override
    public GluePageSet findForNavigationPage(String string, int n, int n2) {
        return this.findForNavigationPage(string, null, n, n2);
    }

    @Override
    public <P> GluePageSet findForNavigationPage(String string, GlueParameter<P> glueParameter, int n, int n2) {
        return this.a(this.a(string), glueParameter, n, n2);
    }

    @Override
    public GluePageSet findForNavigationPageByQuery(String string, int n, int n2) {
        return this.findForNavigationPageByQuery(string, null, n, n2);
    }

    @Override
    public <P> GluePageSet findForNavigationPageByQuery(String string, GlueParameter<P> glueParameter, int n, int n2) {
        boolean bl = glueParameter != null && glueParameter.getParameter() instanceof Map;
        GlueQueryDefinition glueQueryDefinition = new GlueQueryDefinition("pageSet", string, bl);
        return this.a(glueQueryDefinition, glueParameter, n, n2);
    }

    @Override
    public int update(String string) {
        return this.update(string, null);
    }

    @Override
    public <P> int update(String string, GlueParameter<P> glueParameter) {
        return this.a(this.a(string), glueParameter, 2);
    }

    @Override
    public int updateByQueryStatement(String string) {
        return this.updateByQueryStatement(string, null);
    }

    @Override
    public <P> int updateByQueryStatement(String string, GlueParameter<P> glueParameter) {
        boolean bl = glueParameter != null && glueParameter.getParameter() instanceof Map;
        GlueQueryDefinition glueQueryDefinition = new GlueQueryDefinition("update", string, bl);
        return this.a(glueQueryDefinition, glueParameter, 2);
    }

    @Override
    public int insert(String string) {
        return this.insert(string, null);
    }

    @Override
    public <P> int insert(String string, GlueParameter<P> glueParameter) {
        return this.a(this.a(string), glueParameter, 3);
    }

    @Override
    public int insertByQueryStatement(String string) {
        return this.insertByQueryStatement(string, null);
    }

    @Override
    public <P> int insertByQueryStatement(String string, GlueParameter<P> glueParameter) {
        boolean bl = glueParameter != null && glueParameter.getParameter() instanceof Map;
        GlueQueryDefinition glueQueryDefinition = new GlueQueryDefinition("insert", string, bl);
        return this.a(glueQueryDefinition, glueParameter, 3);
    }

    @Override
    public int delete(String string) {
        return this.delete(string, null);
    }

    @Override
    public <P> int delete(String string, GlueParameter<P> glueParameter) {
        return this.a(this.a(string), glueParameter, 4);
    }

    @Override
    public int deleteByQueryStatement(String string) {
        return this.deleteByQueryStatement(string, null);
    }

    @Override
    public <P> int deleteByQueryStatement(String string, GlueParameter<P> glueParameter) {
        boolean bl = glueParameter != null && glueParameter.getParameter() instanceof Map;
        GlueQueryDefinition glueQueryDefinition = new GlueQueryDefinition("delete", string, bl);
        return this.a(glueQueryDefinition, glueParameter, 4);
    }

    protected <T, P> List<T> a(GlueQueryDefinition glueQueryDefinition, GlueParameter<P> glueParameter) {
        List list;
        String string = glueQueryDefinition.getQueryStatement();
        String string2 = glueQueryDefinition.getMappedClassName();
        boolean bl = glueQueryDefinition.isNamedQuery();
        super.getJdbcTemplate().setFetchSize(this.g);
        if (string2 != null) {
            list = null;
            try {
                P p;
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string2);
                long l = System.currentTimeMillis();
                this.d.info("Executing Query StartTime[{}]", (Object)new Date(l));
                if (bl && glueParameter != null) {
                    p = glueParameter.getParameter();
                    list = this.getNamedParameterJdbcTemplate().query(string, (Map)p, (RowMapper)new BeanPropertyRowMapper(clazz));
                } else if (glueParameter != null) {
                    p = glueParameter.getParameter();
                    list = this.getJdbcTemplate().query(string, (RowMapper)new BeanPropertyRowMapper(clazz), ((List)p).toArray());
                } else {
                    list = this.getJdbcTemplate().query(string, (RowMapper)new BeanPropertyRowMapper(clazz));
                }
                long l2 = System.currentTimeMillis();
                this.d.info("Executing Query EndTime[{}] RunTime:[{}]", (Object)new Date(l2), (Object)(l2 - l));
                return list;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.d.error(string2, (Throwable)classNotFoundException);
            }
        }
        try {
            P p;
            list = null;
            long l = System.currentTimeMillis();
            this.d.info("Executing Query StartTime[{}]", (Object)new Date(l));
            if (bl && glueParameter != null) {
                p = glueParameter.getParameter();
                list = this.getNamedParameterJdbcTemplate().queryForList(string, (Map)p);
            } else if (glueParameter != null) {
                p = glueParameter.getParameter();
                list = this.getJdbcTemplate().queryForList(string, ((List)p).toArray());
            } else {
                list = this.getJdbcTemplate().queryForList(string);
            }
            long l3 = System.currentTimeMillis();
            this.d.info("Executing Query EndTime[{}] RunTime:[{}]", (Object)new Date(l3), (Object)(l3 - l));
            if (this.e != null) {
                GlueRowSet<GlueRow<String, Object>> glueRowSet = this.b(list);
                GlueColumnDef[] glueColumnDefArray = this.e.getColumnDefinition(this.getDataSource(), glueQueryDefinition, glueParameter);
                glueRowSet.setColumnDefs(glueColumnDefArray);
                return glueRowSet;
            }
            if (this.h) {
                return this.b(list);
            }
            return list;
        }
        catch (DataAccessException dataAccessException) {
            GlueDaoException glueDaoException = this.a(dataAccessException);
            if (glueDaoException.getSql() == null) {
                glueDaoException.setSql(string);
            }
            throw glueDaoException;
        }
    }

    private <P> int a(GlueQueryDefinition glueQueryDefinition, GlueParameter<P> glueParameter, int n) throws GlueDaoException {
        String string = glueQueryDefinition.getQueryStatement();
        int n2 = 0;
        try {
            if (glueParameter == null) {
                long l = System.currentTimeMillis();
                this.d.info("Executing Query StartTime[{}]", (Object)new Date(l));
                n2 = this.getJdbcTemplate().update(string);
                long l2 = System.currentTimeMillis();
                this.d.info("Executing Query EndTime[{}] RunTime:[{}]", (Object)new Date(l2), (Object)(l2 - l));
            } else {
                boolean bl = glueQueryDefinition.isNamedQuery();
                GlueAuditAttributes glueAuditAttributes = glueParameter.getAuditAttributes();
                P p = glueParameter.getParameter();
                if (bl) {
                    Map map = (Map)p;
                    if (glueAuditAttributes != null) {
                        map.putAll(glueAuditAttributes.getAuditValue());
                    }
                    if (this.a(map)) {
                        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement((String)string);
                        MapSqlParameterSource mapSqlParameterSource = new MapSqlParameterSource(map);
                        String string2 = NamedParameterUtils.substituteNamedParameters((ParsedSql)parsedSql, (SqlParameterSource)mapSqlParameterSource);
                        Object[] objectArray = NamedParameterUtils.buildValueArray((ParsedSql)parsedSql, (SqlParameterSource)mapSqlParameterSource, null);
                        n2 = this.a(string2, objectArray);
                    } else {
                        long l = System.currentTimeMillis();
                        this.d.info("Executing Query StartTime[{}]", (Object)new Date(l));
                        n2 = this.getNamedParameterJdbcTemplate().update(string, map);
                        long l3 = System.currentTimeMillis();
                        this.d.info("Executing Query EndTime[{}] RunTime:[{}]", (Object)new Date(l3), (Object)(l3 - l));
                    }
                } else {
                    LinkedList<Object> linkedList = new LinkedList<Object>();
                    if (glueAuditAttributes != null) {
                        if (n == 3) {
                            linkedList.addAll(glueAuditAttributes.getInsertAuditValue());
                        } else if (n == 2) {
                            linkedList.addAll(glueAuditAttributes.getUpdateAuditValue());
                        }
                    }
                    linkedList.addAll((List)p);
                    if (this.c(linkedList)) {
                        n2 = this.a(string, linkedList.toArray());
                    } else {
                        long l = System.currentTimeMillis();
                        this.d.info("Executing Query StartTime[{}]", (Object)new Date(l));
                        n2 = this.getJdbcTemplate().update(string, linkedList.toArray());
                        long l4 = System.currentTimeMillis();
                        this.d.info("Executing Query EndTime[{}] RunTime:[{}]", (Object)new Date(l4), (Object)(l4 - l));
                    }
                }
            }
        }
        catch (DataAccessException dataAccessException) {
            GlueDaoException glueDaoException = this.a(dataAccessException);
            if (glueDaoException.getSql() == null) {
                glueDaoException.setSql(string);
            }
            throw glueDaoException;
        }
        catch (Throwable throwable) {
            throw new GlueDaoException("unknown [" + throwable.getMessage() + "]", throwable);
        }
        return n2;
    }

    private int a(String string, Object[] objectArray) {
        if (objectArray == null) {
            throw new GlueException("Value of parameter is null. In doing DML for lob type, it must have a parameter value");
        }
        SqlUpdate sqlUpdate = new SqlUpdate(this.getDataSource(), string);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            int n = 12;
            if (objectArray[i] instanceof File || objectArray[i] instanceof byte[] || objectArray[i] instanceof InputStream) {
                n = 2004;
                objectArray[i] = object = this.a(objectArray[i]);
            } else if (objectArray[i] instanceof Date) {
                n = 93;
            } else if (objectArray[i] instanceof String && ((String)objectArray[i]).length() > 32765) {
                n = 2005;
                objectArray[i] = object = this.a(objectArray[i]);
            }
            sqlUpdate.declareParameter(new SqlParameter(n));
        }
        sqlUpdate.compile();
        long l = System.currentTimeMillis();
        this.d.info("Executing Query StartTime[{}]", (Object)new Date(l));
        int n = sqlUpdate.update(objectArray);
        long l2 = System.currentTimeMillis();
        this.d.info("Executing Query EndTime[{}] RunTime:[{}]", (Object)new Date(l2), (Object)(l2 - l));
        return n;
    }

    private <P> GluePageSet a(GlueQueryDefinition glueQueryDefinition, GlueParameter<P> glueParameter, int n, int n2) {
        String string;
        String string2 = glueQueryDefinition.getQueryStatement();
        boolean bl = glueQueryDefinition.isNamedQuery();
        if (bl) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT COUNT(");
        if (this.i.indexOf("MYSQL") >= 0) {
            stringBuffer.append("0");
        } else {
            stringBuffer.append("1");
        }
        stringBuffer.append(") as CNT FROM (");
        if (this.i.indexOf("SQL") >= 0 && this.i.indexOf("SERVER") >= 0) {
            string = string2.toUpperCase();
            int n3 = string.indexOf("SELECT");
            stringBuffer.append("SELECT TOP 100 PERCENT ");
            stringBuffer.append(string2.substring(n3 + "SELECT".length()));
        } else {
            stringBuffer.append(string2);
        }
        stringBuffer.append(") FIND_FOR_NAVIGATION_PAGE");
        string = stringBuffer.toString();
        GlueJdbcTemplate glueJdbcTemplate = (GlueJdbcTemplate)this.getJdbcTemplate();
        int n4 = glueJdbcTemplate.getFetchSize();
        glueJdbcTemplate.setFetchSize(100);
        List<Map<String, Object>> list = null;
        List list2 = null;
        if (glueParameter == null) {
            long l = System.currentTimeMillis();
            this.d.info("Executing Query StartTime[{}]", (Object)new Date(l));
            list = glueJdbcTemplate.query(string2, n, n2);
            long l2 = System.currentTimeMillis();
            this.d.info("Executing Query EndTime[{}] RunTime:[{}]", (Object)new Date(l2), (Object)(l2 - l));
            list2 = this.getJdbcTemplate().queryForList(string);
        } else {
            P p = glueParameter.getParameter();
            long l = System.currentTimeMillis();
            this.d.info("Executing Query StartTime[{}]", (Object)new Date(l));
            list = glueJdbcTemplate.query(string2, (List)p, n, n2);
            long l3 = System.currentTimeMillis();
            this.d.info("Executing Query EndTime[{}] RunTime:[{}]", (Object)new Date(l3), (Object)(l3 - l));
            list2 = this.getJdbcTemplate().queryForList(string, ((List)p).toArray());
        }
        int n5 = list2 != null && list2.get(0) != null ? new Integer(((Map)list2.get(0)).get("cnt").toString()) : 0;
        GluePageSet gluePageSet = this.a(list);
        gluePageSet.setTotalRowCount(n5);
        gluePageSet.setCurrentPage(n2);
        gluePageSet.setPageSize(n);
        glueJdbcTemplate.setFetchSize(n4);
        return gluePageSet;
    }

    private GluePageSet a(List<Map<String, Object>> list) {
        int n = list.size();
        ArrayList<GlueRow<String, Object>> arrayList = new ArrayList<GlueRow<String, Object>>(n);
        for (int i = 0; i < n; ++i) {
            GlueRowImpl glueRowImpl = new GlueRowImpl(list.get(i));
            arrayList.add(glueRowImpl);
        }
        return new GluePageSetImpl((List<GlueRow<String, Object>>)arrayList);
    }

    private GlueRowSet<GlueRow<String, Object>> b(List<Map<String, Object>> list) {
        GlueRowSetImpl glueRowSetImpl = new GlueRowSetImpl(list.size());
        for (Map<String, Object> map : list) {
            glueRowSetImpl.add(new GlueRowImpl(map));
        }
        return glueRowSetImpl;
    }

    protected GlueDaoException a(DataAccessException dataAccessException) {
        GlueDaoException glueDaoException = null;
        if (dataAccessException instanceof BadSqlGrammarException) {
            BadSqlGrammarException badSqlGrammarException = (BadSqlGrammarException)dataAccessException;
            glueDaoException = new GlueBadSqlGrammarException(badSqlGrammarException.getMessage(), (Throwable)badSqlGrammarException);
            glueDaoException.setErrorCode(badSqlGrammarException.getSQLException().getErrorCode());
            glueDaoException.setSql(badSqlGrammarException.getSql());
        } else if (dataAccessException instanceof DataIntegrityViolationException) {
            DataIntegrityViolationException dataIntegrityViolationException = (DataIntegrityViolationException)dataAccessException;
            glueDaoException = new GlueDataIntegrityViolationException(dataIntegrityViolationException.getMessage(), dataIntegrityViolationException.getCause());
        } else if (dataAccessException instanceof UncategorizedSQLException) {
            UncategorizedSQLException uncategorizedSQLException = (UncategorizedSQLException)dataAccessException;
            glueDaoException = new GlueUncategorizedSQLException(uncategorizedSQLException.getMessage(), uncategorizedSQLException.getCause());
            glueDaoException.setErrorCode(uncategorizedSQLException.getSQLException().getErrorCode());
            glueDaoException.setSql(uncategorizedSQLException.getSql());
        } else {
            glueDaoException = new GlueDaoException(dataAccessException.getMessage(), dataAccessException.getCause());
        }
        return glueDaoException;
    }

    private GlueQueryDefinition a(String string) throws GlueDaoException {
        GlueQueryDefinition glueQueryDefinition = this.a.getQueryDefinition(string);
        if (glueQueryDefinition == null) {
            throw new GlueDaoException("Incorrect query id [" + string + "]");
        }
        return glueQueryDefinition;
    }

    private boolean c(List<?> list) {
        Object[] objectArray = list.toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (objectArray[i] instanceof File || objectArray[i] instanceof byte[] || objectArray[i] instanceof InputStream) {
                return true;
            }
            if (!(objectArray[i] instanceof String) || ((String)objectArray[i]).length() <= 32765) continue;
            return true;
        }
        return false;
    }

    private boolean a(Map<String, Object> map) {
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (object instanceof File || object instanceof byte[] || object instanceof InputStream) {
                return true;
            }
            if (!(object instanceof String) || ((String)object).length() <= 32765) continue;
            return true;
        }
        return false;
    }

    private Object a(Object object) {
        SqlLobValue sqlLobValue = null;
        try {
            if (object instanceof File) {
                File file = (File)object;
                FileInputStream fileInputStream = new FileInputStream(file);
                sqlLobValue = new SqlLobValue((InputStream)fileInputStream, (int)file.length(), this.c);
            } else if (object instanceof byte[]) {
                sqlLobValue = new SqlLobValue((byte[])object, this.c);
            } else if (object instanceof InputStream) {
                InputStream inputStream = (InputStream)object;
                sqlLobValue = new SqlLobValue(inputStream, inputStream.available(), this.c);
            } else if (object instanceof String) {
                sqlLobValue = new SqlLobValue((String)object, this.c);
            }
        }
        catch (IOException iOException) {
            throw new GlueException("Fail to process lob type attribute :" + iOException.getMessage());
        }
        return sqlLobValue;
    }

    @Override
    public <P> int[] batchUpdate(String string, GlueParameter<P>[] glueParameterArray) {
        GlueQueryDefinition glueQueryDefinition = this.a(string);
        return this.a(glueQueryDefinition, glueParameterArray);
    }

    @Override
    public <P> int[] batchUpdateByQueryStatement(String string, GlueParameter<P>[] glueParameterArray) {
        boolean bl = glueParameterArray != null && glueParameterArray[0].getParameter() instanceof Map;
        GlueQueryDefinition glueQueryDefinition = new GlueQueryDefinition("dml", string, bl);
        return this.a(glueQueryDefinition, glueParameterArray);
    }

    @Override
    public int[] batchUpdate(String string, GlueParameter<List<?>>[] glueParameterArray, int[] nArray) {
        GlueQueryDefinition glueQueryDefinition = this.a(string);
        if (glueQueryDefinition.isNamedQuery()) {
            throw new GlueException("Not supported .. ");
        }
        return this.a(glueQueryDefinition, glueParameterArray, nArray);
    }

    @Override
    public int[] batchUpdate(String string, GlueParameter<Map<?, ?>>[] glueParameterArray, Map<String, Integer> map) {
        GlueQueryDefinition glueQueryDefinition = this.a(string);
        if (!glueQueryDefinition.isNamedQuery()) {
            throw new GlueException("Not supported .. ");
        }
        return this.batchUpdateByQueryStatement(glueQueryDefinition.getQueryStatement(), glueParameterArray, map);
    }

    @Override
    public int[] batchUpdateByQueryStatement(String string, GlueParameter<List<?>>[] glueParameterArray, int[] nArray) {
        GlueQueryDefinition glueQueryDefinition = new GlueQueryDefinition("dml", string, false);
        return this.a(glueQueryDefinition, glueParameterArray, nArray);
    }

    @Override
    public int[] batchUpdateByQueryStatement(String string, GlueParameter<Map<?, ?>>[] glueParameterArray, Map<String, Integer> map) {
        MapSqlParameterSource[] mapSqlParameterSourceArray = new MapSqlParameterSource[glueParameterArray.length];
        int n = glueParameterArray.length;
        for (int i = 0; i < n; ++i) {
            Map<?, ?> map2 = glueParameterArray[i].getParameter();
            for (String string2 : map.keySet()) {
                switch (map.get(string2)) {
                    case 93: 
                    case 2004: 
                    case 2005: {
                        Object object = this.a(map2.get(string2));
                        map2.put(string2, object);
                        break;
                    }
                }
            }
            if (glueParameterArray[i].getAuditAttributes() != null) {
                map2.putAll(glueParameterArray[i].getAuditAttributes().getAuditValue());
            }
            mapSqlParameterSourceArray[i] = new MapSqlParameterSource(map2);
            for (String string2 : map.keySet()) {
                mapSqlParameterSourceArray[i].registerSqlType(string2, map.get(string2).intValue());
            }
        }
        return this.getNamedParameterJdbcTemplate().batchUpdate(string, (SqlParameterSource[])mapSqlParameterSourceArray);
    }

    private <P> int[] a(GlueQueryDefinition glueQueryDefinition, GlueParameter<P>[] glueParameterArray) {
        if (glueParameterArray == null || glueParameterArray.length == 0) {
            throw new IllegalArgumentException("Check ur GlueParameter values");
        }
        int[] nArray = null;
        nArray = glueQueryDefinition.isNamedQuery() ? this.getNamedParameterJdbcTemplate().batchUpdate(glueQueryDefinition.getQueryStatement(), (Map[])this.a(glueParameterArray)) : (glueQueryDefinition.getQueryStatement().toLowerCase().startsWith("insert") ? this.getJdbcTemplate().batchUpdate(glueQueryDefinition.getQueryStatement(), this.a(glueParameterArray, 3)) : (glueQueryDefinition.getQueryStatement().toLowerCase().startsWith("update") ? this.getJdbcTemplate().batchUpdate(glueQueryDefinition.getQueryStatement(), this.a(glueParameterArray, 2)) : this.getJdbcTemplate().batchUpdate(glueQueryDefinition.getQueryStatement(), this.a(glueParameterArray, -1))));
        return nArray;
    }

    private int[] a(GlueQueryDefinition glueQueryDefinition, GlueParameter<List<?>>[] glueParameterArray, int[] nArray) {
        if (glueParameterArray == null || glueParameterArray.length == 0) {
            throw new IllegalArgumentException("Check ur GlueParameter values");
        }
        for (GlueParameter<List<?>> glueParameter : glueParameterArray) {
            List<?> list = glueParameter.getParameter();
            int n = nArray.length;
            block4: for (int i = 0; i < n; ++i) {
                switch (nArray[i]) {
                    case 93: 
                    case 2004: 
                    case 2005: {
                        Object object = this.a(list.get(i));
                        list.set(i, object);
                        continue block4;
                    }
                }
            }
        }
        Object[] objectArray = null;
        objectArray = glueQueryDefinition.getQueryStatement().toLowerCase().startsWith("insert") ? (Object[])this.getJdbcTemplate().batchUpdate(glueQueryDefinition.getQueryStatement(), this.a(glueParameterArray, 3), nArray) : (glueQueryDefinition.getQueryStatement().toLowerCase().startsWith("update") ? (Object[])this.getJdbcTemplate().batchUpdate(glueQueryDefinition.getQueryStatement(), this.a(glueParameterArray, 2), nArray) : (Object[])this.getJdbcTemplate().batchUpdate(glueQueryDefinition.getQueryStatement(), this.a(glueParameterArray, -1), nArray));
        return objectArray;
    }

    private List<Object[]> a(GlueParameter<List<?>>[] glueParameterArray, int n) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(glueParameterArray.length);
        for (int i = 0; i < glueParameterArray.length; ++i) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            if (glueParameterArray[i].getAuditAttributes() != null) {
                if (n == 3) {
                    linkedList.addAll(glueParameterArray[i].getAuditAttributes().getInsertAuditValue());
                } else if (n == 2) {
                    linkedList.addAll(glueParameterArray[i].getAuditAttributes().getUpdateAuditValue());
                }
            }
            linkedList.addAll((Collection)glueParameterArray[i].getParameter());
            arrayList.add(linkedList.toArray());
        }
        return arrayList;
    }

    private Map<String, ?>[] a(GlueParameter<Map<String, ?>>[] glueParameterArray) {
        Map[] mapArray = new Map[glueParameterArray.length];
        for (int i = 0; i < mapArray.length; ++i) {
            mapArray[i] = glueParameterArray[i].getParameter();
            if (glueParameterArray[i].getAuditAttributes() == null) continue;
            mapArray[i].putAll(glueParameterArray[i].getAuditAttributes().getAuditValue());
        }
        return mapArray;
    }
}

