/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.context;

import com.poscoict.glueframework.GlueInvalidLicenseException;
import com.poscoict.glueframework.bean.GlueBeanFactory;
import com.poscoict.glueframework.bean.GlueBeanFactoryImpl;
import com.poscoict.glueframework.context.GlueProperties;
import com.poscoict.glueframework.util.license.GlueLicenseManager;
import com.poscoict.glueframework.util.license.GlueSolution;
import com.poscoict.license.LicenseAPI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ResourceBundleMessageSource;

public final class GlueStaticContext {
    public static final String config = "applicationContext.xml";
    private static final Logger a = LoggerFactory.getLogger(GlueStaticContext.class);
    private static Map<ClassLoader, GlueBeanFactory> b = new HashMap<ClassLoader, GlueBeanFactory>(5);
    private static Properties c = System.getProperties();
    private static Properties d = new GlueProperties();
    private static Properties e = new GlueProperties();
    private static LicenseAPI f;
    private static LicenseAPI.LicenseMode g;
    private static String h;
    private static LicenseAPI.Solution i;

    public static void reloadLicense() {
        File file;
        f = null;
        g = LicenseAPI.LicenseMode.EDUCATION;
        String string = c.getProperty("CONFIG_PATH");
        if (string != null && (file = new File(string)).isDirectory()) {
            for (String string2 : GlueStaticContext.a(file)) {
                try {
                    f = GlueLicenseManager.getLicenseAPI(file.getAbsolutePath() + File.separator + string2);
                }
                catch (GlueInvalidLicenseException glueInvalidLicenseException) {
                    a.error(glueInvalidLicenseException.getLocalizedMessage());
                }
                catch (Exception exception) {
                    a.error("Get LicenseAPI Fail!!", (Throwable)exception);
                }
            }
            try {
                g = f.getLicenseMode(i);
            }
            catch (Exception exception) {
                a.error("Fail to get license mode!!", (Throwable)exception);
            }
        }
        a.info("Solution : {}, License Mode : {}", (Object)i, (Object)g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadGlueProperties() {
        String string = c.getProperty("CONFIG_PATH");
        if (string != null) {
            File file = new File(string);
            if (file.isDirectory()) {
                File file2 = new File(file.getPath() + File.separator + "glue.properties");
                if (file2.isFile()) {
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(file2);
                        d.load(fileInputStream);
                        a.error("{}Loaded [{}] path: {}", new Object[]{h, "glue.properties", file2.getPath()});
                        a.info("{}Loaded [{}] count: {}", new Object[]{h, "glue.properties", d.size()});
                        a.info("{}Loaded [{}] content: {}", new Object[]{h, "glue.properties", d.toString()});
                        String string2 = d.getProperty("glue.custom.property");
                        if (string2 == null || string2.isEmpty()) {
                            a.info("Does not exist [{}] key or value", (Object)"glue.custom.property");
                        }
                        if (!new File(string2).isFile()) {
                            a.info("Does not exist custom property file: {}", (Object)string2);
                        }
                        file2 = new File(string2);
                        fileInputStream = new FileInputStream(file2);
                        String string3 = file2.getName();
                        e.load(fileInputStream);
                        a.error("{}Loaded [{}] path: {}", new Object[]{h, string3, string2});
                        a.info("{}Loaded [{}] count: {}", new Object[]{h, string3, e.size()});
                        a.info("{}Loaded [{}] content: {}", new Object[]{h, string3, e.toString()});
                    }
                    catch (Exception exception) {
                        a.error(exception.getMessage(), (Throwable)exception);
                    }
                    finally {
                        if (fileInputStream != null) {
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    a.warn("Check 'glue.properties' in {}", (Object)string);
                }
            } else {
                a.warn("Check Java Option 'CONFIG_PATH'. it's value : {}", (Object)string);
            }
        } else {
            a.warn("Check Java Option 'CONFIG_PATH'");
        }
        h = "re-";
    }

    public static GlueBeanFactory getBeanFactory() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        GlueBeanFactory glueBeanFactory = b.get(classLoader);
        if (glueBeanFactory == null) {
            glueBeanFactory = new GlueBeanFactoryImpl(config);
            b.put(classLoader, glueBeanFactory);
        }
        return glueBeanFactory;
    }

    public static void destroyApplictionContext() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        GlueBeanFactory glueBeanFactory = b.get(classLoader);
        if (glueBeanFactory != null) {
            ((GlueBeanFactoryImpl)glueBeanFactory).closeContext();
            b.remove(classLoader);
        }
    }

    public static String getSystemProperty(String string) {
        return c.getProperty(string);
    }

    public static String getSystemProperty(String string, String string2) {
        return c.getProperty(string, string2);
    }

    public static String getGlueProperty(String string) {
        return d != null ? d.getProperty(string) : null;
    }

    public static String getGlueProperty(String string, String string2) {
        return d != null ? d.getProperty(string, string2) : string2;
    }

    public static String getCustomProperty(String string) {
        return e.getProperty(string);
    }

    public static String getCustomProperty(String string, String string2) {
        return e.getProperty(string, string2);
    }

    public static String getTimeZoneFormat(Date date, int n) {
        return GlueStaticContext.getTimeZoneFormat(date, n, null);
    }

    public static String getTimeZoneFormat(Date date, int n, String string) {
        String string2 = "";
        String[] stringArray = TimeZone.getAvailableIDs(n * 60 * 1000);
        if (stringArray == null || stringArray.length <= 0) {
            a.warn("not available Timezone.");
            return "";
        }
        string2 = stringArray[0];
        return GlueStaticContext.getTimeZoneFormat(date, string2, string);
    }

    public static String getTimeZoneFormat(Date date, String string) {
        return GlueStaticContext.getTimeZoneFormat(date, string, null);
    }

    public static String getTimeZoneFormat(Date date, String string, String string2) {
        TimeZone timeZone = null;
        if (string2 == null || string2.equals("")) {
            string2 = "yyyy-MM-dd HH:mm:ss (z Z)";
        }
        timeZone = string == null || string.equals("") ? TimeZone.getDefault() : TimeZone.getTimeZone(string);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        simpleDateFormat.setTimeZone(timeZone);
        return simpleDateFormat.format(date);
    }

    public static String getResourceMessage(String string) {
        return GlueStaticContext.getResourceMessage("messageSource", string, null, null);
    }

    public static String getResourceMessage(String string, Object[] objectArray) {
        return GlueStaticContext.getResourceMessage("messageSource", string, objectArray, null);
    }

    public static String getResourceMessage(String string, Locale locale) {
        return GlueStaticContext.getResourceMessage("messageSource", string, null, locale);
    }

    public static String getResourceMessage(String string, Object[] objectArray, Locale locale) {
        return GlueStaticContext.getResourceMessage("messageSource", string, objectArray, locale);
    }

    public static String getResourceMessage(String string, String string2, Object[] objectArray, Locale locale) {
        String string3;
        if (locale == null) {
            string3 = d.getProperty("default.msg.locale");
            locale = string3 == null ? Locale.getDefault() : GlueStaticContext.getDefaultLocale(string3);
        }
        string3 = GlueStaticContext.getBeanFactory().getBeanObject(string, ResourceBundleMessageSource.class);
        return string3.getMessage(string2, objectArray, locale);
    }

    public static Locale getDefaultUILocale() {
        try {
            String string = d.getProperty("default.ui.locale");
            if (string != null) {
                return GlueStaticContext.getDefaultLocale(string);
            }
            return Locale.getDefault();
        }
        catch (Throwable throwable) {
            return Locale.getDefault();
        }
    }

    public static Locale getDefaultLocale(String string) {
        String[] stringArray;
        if (string != null && (stringArray = string.split("_")) != null && stringArray.length > 1) {
            return new Locale(stringArray[0], stringArray[1]);
        }
        return Locale.getDefault();
    }

    public static boolean isAudit() {
        String string = GlueStaticContext.getGlueProperty("audit.insert.key");
        String string2 = GlueStaticContext.getGlueProperty("audit.update.key");
        return string != null && string2 != null;
    }

    public static LicenseAPI.LicenseMode getLicenseMode() {
        return g;
    }

    public static boolean checkLicense() {
        boolean bl = false;
        if (f != null && g != LicenseAPI.LicenseMode.EDUCATION) {
            try {
                bl = f.checkLicense(i);
            }
            catch (Exception exception) {
                a.error("Fail to check license!!", (Throwable)exception);
            }
        }
        return bl;
    }

    private static String[] a(File file) {
        return file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.indexOf("license_info_") != -1 && string.endsWith(".xml");
            }
        });
    }

    static {
        h = "";
        i = GlueSolution.get();
        a.info("glueframework version : 4.2.14-RELEASE");
        GlueStaticContext.reloadLicense();
        GlueStaticContext.reloadGlueProperties();
    }
}

