/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.cache.remote;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.cache.remote.GlueCacheEvent;
import com.poscoict.glueframework.cache.remote.GlueCacheEventSender;
import com.poscoict.glueframework.cache.remote.GlueRemoteCacheException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class GlueHttpCacheEventSender
implements GlueCacheEventSender,
InitializingBean {
    private final Logger a = LoggerFactory.getLogger(this.getClass());
    private HttpClient b;
    private List<String> c;
    private int d = 0;
    private long e = 15000L;
    private String f;
    private int g = 0;

    public List<String> getTargetUrl() {
        return this.c;
    }

    public void setTargetUrl(List<String> list) {
        this.c = list;
    }

    public long getTimeout() {
        return this.e;
    }

    public void setTimeout(long l) {
        this.e = l;
    }

    public int getRequestRetryCount() {
        return this.g;
    }

    public void setRequestRetryCount(int n) {
        this.g = n;
    }

    @Override
    public String sendEvent(GlueCacheEvent glueCacheEvent) {
        String[] stringArray = new String[this.d];
        glueCacheEvent.setRequestor(this.f);
        for (int i = 0; i < this.d; ++i) {
            stringArray[i] = this.a(glueCacheEvent, this.c.get(i));
        }
        return this.a(stringArray);
    }

    private String a(GlueCacheEvent glueCacheEvent, String string) {
        PostMethod postMethod = this.b(glueCacheEvent, string);
        postMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(this.g, false));
        postMethod.getParams().setParameter("http.socket.timeout", (Object)new Integer((int)this.e));
        String string2 = null;
        try {
            int n = this.b.executeMethod((HttpMethod)postMethod);
            string2 = new String(postMethod.getResponseBody());
            if (n == 800) {
                throw new GlueRemoteCacheException("Cannot remove remote cached object : target[" + string + "], event info[" + glueCacheEvent.toString() + "], remote error message[" + string2 + "]");
            }
            this.a.info("response:{}", (Object)string2);
            this.a.info("status line:{}", (Object)postMethod.getStatusLine());
        }
        catch (HttpException httpException) {
            throw new GlueException("Fatal protocol violation: " + httpException.getMessage(), httpException);
        }
        catch (IOException iOException) {
            throw new GlueException("Fatal transport error: " + iOException.getMessage(), iOException);
        }
        catch (GlueRemoteCacheException glueRemoteCacheException) {
            throw glueRemoteCacheException;
        }
        finally {
            postMethod.releaseConnection();
        }
        return string2;
    }

    private PostMethod b(GlueCacheEvent glueCacheEvent, String string) {
        PostMethod postMethod = new PostMethod(string);
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>(5);
        arrayList.add(new NameValuePair("__cache_key__", glueCacheEvent.getCacheKey()));
        arrayList.add(new NameValuePair("__region_name__", glueCacheEvent.getRegionName()));
        arrayList.add(new NameValuePair("__requestor__", glueCacheEvent.getRequestor()));
        this.a.debug("Cache Event Parameters : {}", arrayList);
        NameValuePair[] nameValuePairArray = new NameValuePair[arrayList.size()];
        postMethod.setRequestBody(arrayList.toArray(nameValuePairArray));
        return postMethod;
    }

    private String a(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(this.c.get(i)).append("=").append(stringArray[i]).append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.c == null || this.c.size() < 0) {
            throw new GlueException("Plz specify targetUrl in applicationContext.xml");
        }
        this.d = this.c.size();
        for (int i = 0; i < this.d; ++i) {
            this.a.info("Remote target URLs [{}]", (Object)this.c.get(i));
        }
        this.f = InetAddress.getLocalHost().getHostAddress();
        this.a.info("Local host address : {}", (Object)this.f);
        this.b = new HttpClient();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }
}

