/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.cache.jcs;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.cache.GlueCacheLoader;
import com.poscoict.glueframework.cache.GlueCacheManager;
import com.poscoict.glueframework.cache.jcs.GlueJCSCacheHolder;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class GlueJCSCacheManager
implements GlueCacheManager,
DisposableBean,
InitializingBean {
    protected final Logger a = LoggerFactory.getLogger(this.getClass());
    protected GlueJCSCacheHolder b = GlueJCSCacheHolder.getInstance();

    private JCS a(String string) {
        JCS jCS = (JCS)this.b.getCache(string);
        if (jCS == null) {
            this.a.debug("Cache does not exist for region [{}]. Create new cache object", (Object)string);
            try {
                jCS = JCS.getInstance((String)string);
            }
            catch (CacheException cacheException) {
                throw new GlueException(cacheException.getMessage(), cacheException);
            }
            this.b.putCache(string, jCS);
        }
        return jCS;
    }

    @Override
    public Object getCacheObject(Object object) {
        return this.getCacheObject(object, "_default-region");
    }

    @Override
    public <T> T getCacheObject(Object object, Class<T> clazz) {
        return this.getCacheObject(object, "_default-region", clazz);
    }

    @Override
    public Object getCacheObject(Object object, String string) {
        return this.getCacheObject(object, string, null, Object.class);
    }

    @Override
    public <T> T getCacheObject(Object object, String string, Class<T> clazz) {
        return this.getCacheObject(object, string, null, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getCacheObject(Object object, String string, GlueCacheLoader glueCacheLoader) {
        JCS jCS = this.a(string);
        Object object2 = jCS.get(object);
        if (object2 == null && glueCacheLoader != null) {
            GlueCacheLoader glueCacheLoader2 = glueCacheLoader;
            synchronized (glueCacheLoader2) {
                object2 = glueCacheLoader.loadCacheObject(object, string);
            }
            if (object2 != null) {
                try {
                    jCS.put(object, object2);
                }
                catch (CacheException cacheException) {
                    throw new GlueException(cacheException.getMessage(), cacheException);
                }
            }
        }
        return object2;
    }

    @Override
    public <T> T getCacheObject(Object object, String string, GlueCacheLoader glueCacheLoader, Class<T> clazz) {
        Object object2 = this.getCacheObject(object, string, glueCacheLoader);
        if (object2 != null && clazz.isAssignableFrom(object2.getClass())) {
            return (T)object2;
        }
        return null;
    }

    @Override
    public void putCacheObject(Object object, Object object2) {
        this.putCacheObject(object, object2, "_default-region");
    }

    @Override
    public void putCacheObject(Object object, Object object2, String string) {
        JCS jCS = this.a(string);
        try {
            jCS.put(object, object2);
        }
        catch (CacheException cacheException) {
            throw new GlueException(cacheException.getMessage(), cacheException);
        }
    }

    @Override
    public boolean isPresent(Object object) {
        return this.isPresent(object, "_default-region");
    }

    @Override
    public boolean isPresent(Object object, String string) {
        Object object2 = this.a(string).get(object);
        return object2 != null;
    }

    @Override
    public void removeCacheObject(Object object) {
        this.removeCacheObject(object, "_default-region");
    }

    @Override
    public void removeCacheObject(Object object, String string) {
        try {
            this.a(string).remove(object);
        }
        catch (CacheException cacheException) {
            throw new GlueException(cacheException.getMessage(), cacheException);
        }
    }

    @Override
    public void clear() {
        this.clear("_default-region");
    }

    @Override
    public void clear(String string) {
        try {
            this.a(string).clear();
        }
        catch (CacheException cacheException) {
            throw new GlueException(cacheException.getMessage(), cacheException);
        }
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void destroy() throws Exception {
        this.clear("_default-region");
        this.a.info("clear cache in '{}'", (Object)"_default-region");
    }
}

