/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.biz.control;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.GlueInvalidLicenseException;
import com.poscoict.glueframework.biz.control.GlueBizController;
import com.poscoict.glueframework.biz.control.GlueMoniHelper;
import com.poscoict.glueframework.biz.control.GlueService;
import com.poscoict.glueframework.biz.control.GlueServiceManager;
import com.poscoict.glueframework.context.GlueContext;
import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.dao.vo.GlueAuditAttributes;
import com.poscoict.glueframework.transaction.GlueTransactionManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import org.springframework.transaction.TransactionStatus;

public final class GlueBizControllerImpl
implements GlueBizController {
    private static GlueBizController a = null;
    private static int b = 0;
    private final Logger c = LoggerFactory.getLogger(this.getClass());
    private final GlueServiceManager d = GlueStaticContext.getBeanFactory().getBeanObject("serviceManager", GlueServiceManager.class);
    private GlueMoniHelper e = null;

    private GlueBizControllerImpl() {
        if (GlueStaticContext.getBeanFactory().containsBean("moniHelper")) {
            this.e = GlueStaticContext.getBeanFactory().getBeanObject("moniHelper", GlueMoniHelper.class);
        }
    }

    public static GlueBizController getController() {
        if (a == null) {
            a = new GlueBizControllerImpl();
        }
        return a;
    }

    private void a(List<String> list) {
        GlueTransactionManager glueTransactionManager = null;
        for (String string : list) {
            glueTransactionManager = GlueStaticContext.getBeanFactory().getBeanObject(string, GlueTransactionManager.class);
            if (glueTransactionManager == null) continue;
            glueTransactionManager.startTransaction();
            this.c.debug("Start TX : {}", (Object)string);
        }
    }

    private Map<String, TransactionStatus> b(List<String> list) {
        HashMap<String, TransactionStatus> hashMap = new HashMap<String, TransactionStatus>();
        GlueTransactionManager glueTransactionManager = null;
        for (String string : list) {
            glueTransactionManager = GlueStaticContext.getBeanFactory().getBeanObject(string, GlueTransactionManager.class);
            if (glueTransactionManager == null) continue;
            TransactionStatus transactionStatus = glueTransactionManager.changeTransaction(null);
            if (transactionStatus != null) {
                hashMap.put(string, transactionStatus);
            }
            this.c.debug("Start TX : {}", (Object)string);
        }
        return hashMap;
    }

    private void a(Map<String, TransactionStatus> map) {
        GlueTransactionManager glueTransactionManager = null;
        if (map != null) {
            for (Map.Entry<String, TransactionStatus> entry : map.entrySet()) {
                String string = entry.getKey();
                glueTransactionManager = GlueStaticContext.getBeanFactory().getBeanObject(string, GlueTransactionManager.class);
                if (glueTransactionManager == null) continue;
                TransactionStatus transactionStatus = entry.getValue();
                glueTransactionManager.changeTransaction(transactionStatus);
            }
        }
    }

    private void a(Map<String, Boolean> map, List<String> list) {
        GlueTransactionManager glueTransactionManager = null;
        for (int i = list.size(); i > 0; --i) {
            boolean bl;
            String string = list.get(i - 1);
            glueTransactionManager = GlueStaticContext.getBeanFactory().getBeanObject(string, GlueTransactionManager.class);
            if (glueTransactionManager == null) continue;
            if (map.get(string).booleanValue()) {
                bl = glueTransactionManager.commit();
                if (!bl || !this.c.isDebugEnabled()) continue;
                this.c.debug("Commit TX : {}", (Object)string);
                continue;
            }
            bl = glueTransactionManager.rollback();
            if (!bl || !this.c.isDebugEnabled()) continue;
            this.c.debug("Rollback TX : {}", (Object)string);
        }
    }

    private void c(List<String> list) {
        GlueTransactionManager glueTransactionManager = null;
        for (int i = list.size(); i > 0; --i) {
            String string = list.get(i - 1);
            glueTransactionManager = GlueStaticContext.getBeanFactory().getBeanObject(string, GlueTransactionManager.class);
            if (glueTransactionManager == null) continue;
            try {
                boolean bl = glueTransactionManager.rollback();
                if (!bl || !this.c.isDebugEnabled()) continue;
                this.c.debug("Rollback TX : {}", (Object)string);
                continue;
            }
            catch (Throwable throwable) {
                this.c.error("Rollback TX : {}", (Object)string);
                this.c.error("Rollback Transaction Error", throwable);
            }
        }
    }

    @Override
    public GlueContext doAction(GlueContext glueContext) {
        String string;
        if (this.c.isTraceEnabled()) {
            this.c.trace(glueContext.toString());
        }
        if ((string = (String)glueContext.get("ServiceName")) == null) {
            throw new GlueException("ServiceName doesn't exist");
        }
        switch (GlueStaticContext.getLicenseMode()) {
            case EDUCATION: {
                this.c.warn("running in EDUCATION MODE : {}", (Object)(b + 1));
                if (b >= 50) {
                    for (int i = 0; i < 10; ++i) {
                        this.c.error("it exceeds run limit in EDUCATION mode!!");
                        System.out.println("it exceeds run limit in EDUCATION mode!!");
                    }
                    throw new GlueInvalidLicenseException("it exceeds run limit!!");
                }
                ++b;
                break;
            }
            case DEVELOPMENT: 
            case PRODUCT: {
                if (GlueStaticContext.checkLicense()) break;
                this.c.error("Please check license file!! : Glue Service is delayed by 10 seconds!!");
                try {
                    Thread.sleep(10000L);
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        long l = System.currentTimeMillis();
        Object object = null;
        if (this.e != null) {
            object = this.e.startMonitoring(string);
        }
        this.c.info("ServiceName:[{}] StartTime[{}]", (Object)string, (Object)new Date(l));
        if (GlueStaticContext.isAudit() && glueContext.getAuditAttributes() == null) {
            glueContext.setAuditAttributes(new GlueAuditAttributes(glueContext));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string22;
            GlueService glueService = this.d.getService(string);
            Map<String, Boolean> map = glueService.getTransactionManagers();
            for (String string22 : map.keySet()) {
                arrayList.add(string22);
            }
            this.a(arrayList);
            glueContext.put(string, glueService);
            Object object2 = glueService.a(glueService.a());
            string22 = null;
            while (true) {
                glueContext.put("ServiceName", string);
                string22 = ((GlueService.GlueActivityHandler)object2).runActivity(glueContext);
                if ("end".equals(string22)) break;
                object2 = glueService.a(string22);
            }
            this.a(map, arrayList);
        }
        catch (Throwable throwable) {
            if (glueContext.getException() == null) {
                glueContext.setException(throwable);
            }
            this.c.error(MarkerFactory.getMarker((String)"FATAL"), "error", throwable);
            this.c(arrayList);
            long l2 = System.currentTimeMillis();
            if (this.e != null) {
                this.e.glueExceptionTransfer(throwable);
            }
            this.c.error(MarkerFactory.getMarker((String)"FATAL"), "Error! ServiceName:[" + string + "] EndTime[" + new Date(l2) + "] RunTime:[" + (l2 - l) + "]", throwable);
            if (throwable instanceof GlueException) {
                throw (GlueException)throwable;
            }
            throw new GlueException(throwable.getMessage(), throwable);
        }
        finally {
            if (this.e != null) {
                this.e.endMonitoring(object);
            }
        }
        long l3 = System.currentTimeMillis();
        this.c.info("ServiceName:[{}] EndTime[{}] RunTime:[{}]", new Object[]{string, new Date(l3), l3 - l});
        return glueContext;
    }

    @Override
    public GlueContext doSubController(GlueContext glueContext, boolean bl) {
        Map<String, TransactionStatus> map = null;
        String string = (String)glueContext.get("ServiceName");
        long l = System.currentTimeMillis();
        this.c.info("SubServiceName:[{}] StartTime[{}]", (Object)string, (Object)new Date(l));
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string22;
            if (string == null) {
                throw new Exception("ServiceName isn't exist");
            }
            GlueService glueService = this.d.getService(string);
            Map<String, Boolean> map2 = glueService.getTransactionManagers();
            for (String string22 : map2.keySet()) {
                arrayList.add(string22);
            }
            if (bl && arrayList.size() > 0) {
                map = this.b(arrayList);
            }
            glueContext.put(string, glueService);
            Object object = glueService.a(glueService.a());
            string22 = null;
            while (true) {
                glueContext.put("ServiceName", string);
                string22 = ((GlueService.GlueActivityHandler)object).runActivity(glueContext);
                if ("end".equals(string22)) break;
                object = glueService.a(string22);
            }
            if (bl && arrayList.size() > 0) {
                this.a(map2, arrayList);
            }
        }
        catch (Throwable throwable) {
            if (bl && arrayList.size() > 0) {
                this.c(arrayList);
            }
            long l2 = System.currentTimeMillis();
            this.c.error(MarkerFactory.getMarker((String)"FATAL"), "Error! SubServiceName:[" + string + "] EndTime[" + new Date(l2) + "] RunTime:[" + (l2 - l) + "]", throwable);
            throw new GlueException(throwable.getMessage(), throwable);
        }
        finally {
            if (bl && arrayList.size() > 0) {
                this.a(map);
            }
        }
        long l3 = System.currentTimeMillis();
        this.c.info("SubServiceName:[{}] EndTime[{}] RunTime:[{}]", new Object[]{string, new Date(l3), l3 - l});
        return glueContext;
    }
}

