/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.biz.activity;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.biz.activity.GlueActivity;
import com.poscoict.glueframework.biz.control.GlueBizController;
import com.poscoict.glueframework.biz.control.GlueBizProvider;
import com.poscoict.glueframework.context.GlueContext;
import com.poscoict.glueframework.context.GlueDefaultContext;
import com.poscoict.glueframework.context.GluePortletContext;
import com.poscoict.glueframework.context.GlueWebContext;
import org.slf4j.MDC;
import org.slf4j.MarkerFactory;

public class GlueSubService
extends GlueActivity<GlueContext> {
    @Override
    public String runActivity(GlueContext glueContext) {
        String string = this.getProperty("service-name");
        String string2 = this.getProperty("new-transaction");
        String string3 = this.getProperty("new-thread-join");
        if (string2 != null && string3 != null) {
            throw new GlueException("DO NOT USE 'new-transaction' and 'new-thread' together.");
        }
        boolean bl = Boolean.valueOf(string2);
        boolean bl2 = Boolean.valueOf(string3);
        if (string3 != null) {
            GlueUserThread glueUserThread = new GlueUserThread();
            glueUserThread.setContext(glueContext, string);
            glueUserThread.start();
            if (bl2) {
                try {
                    glueUserThread.join();
                }
                catch (InterruptedException interruptedException) {
                    this.logger.error("InterruptedException", (Throwable)interruptedException);
                }
            }
        } else {
            if (bl && !this.getTransition().containsKey("failure")) {
                this.logger.warn("this activity needs both 'success' and 'failure' transitions because its 'new-transaction' property is true");
            }
            try {
                glueContext.put("ServiceName", string);
                MDC.put((String)"Sub-ServiceName", (String)string);
                GlueBizController glueBizController = GlueBizProvider.getController();
                glueBizController.doSubController(glueContext, bl);
                MDC.remove((String)"Sub-ServiceName");
            }
            catch (GlueException glueException) {
                if (!bl) {
                    throw glueException;
                }
                this.logger.error(MarkerFactory.getMarker((String)"FATAL"), "Sub Service[" + this.getName() + "] Transaction is Fail!", (Throwable)glueException);
                glueContext.setException(glueException);
                return "failure";
            }
        }
        return "success";
    }

    protected class GlueUserThread
    extends Thread {
        GlueContext a = null;

        protected GlueUserThread() {
        }

        public void setContext(GlueContext glueContext, String string) {
            this.a.setAuditAttributes(glueContext.getAuditAttributes());
            if (GlueContext.EventType.WEB_BROWSER == glueContext.getEventSourceType()) {
                if (glueContext instanceof GlueWebContext) {
                    this.a = new GlueWebContext();
                    glueContext.putAll(glueContext.getDataAsMap(GlueContext.WebContentType.HTTP_REQUEST_PARAM), GlueContext.WebContentType.HTTP_REQUEST_PARAM);
                    glueContext.putAll(glueContext.getDataAsMap(GlueContext.WebContentType.HTTP_REQUEST_ATTR), GlueContext.WebContentType.HTTP_REQUEST_ATTR);
                    glueContext.putAll(glueContext.getDataAsMap(GlueContext.WebContentType.HTTP_HEADER), GlueContext.WebContentType.HTTP_HEADER);
                    glueContext.putAll(glueContext.getDataAsMap(GlueContext.WebContentType.COOKIE), GlueContext.WebContentType.COOKIE);
                    glueContext.putAll(glueContext.getDataAsMap(GlueContext.WebContentType.SESSION_ATTR), GlueContext.WebContentType.SESSION_ATTR);
                } else {
                    this.a = new GluePortletContext();
                    glueContext.putAll(glueContext.getDataAsMap(GlueContext.PortletContentType.PORTLET_REQUEST_PARAM_PUBLIC), GlueContext.PortletContentType.PORTLET_REQUEST_PARAM_PUBLIC);
                    glueContext.putAll(glueContext.getDataAsMap(GlueContext.PortletContentType.PORTLET_REQUEST_PARAM_PRIVATE), GlueContext.PortletContentType.PORTLET_REQUEST_PARAM_PRIVATE);
                    glueContext.putAll(glueContext.getDataAsMap(GlueContext.PortletContentType.PORTLET_REQUEST_ATTR), GlueContext.PortletContentType.PORTLET_REQUEST_ATTR);
                    glueContext.putAll(glueContext.getDataAsMap(GlueContext.PortletContentType.HTTP_HEADER), GlueContext.PortletContentType.HTTP_HEADER);
                    glueContext.putAll(glueContext.getDataAsMap(GlueContext.PortletContentType.COOKIE), GlueContext.PortletContentType.COOKIE);
                    glueContext.putAll(glueContext.getDataAsMap(GlueContext.PortletContentType.SESSION_ATTR_APPLICATION_SCOPE), GlueContext.PortletContentType.SESSION_ATTR_APPLICATION_SCOPE);
                    glueContext.putAll(glueContext.getDataAsMap(GlueContext.PortletContentType.SESSION_ATTR_PORTLET_SCOPE), GlueContext.PortletContentType.SESSION_ATTR_PORTLET_SCOPE);
                }
            } else {
                this.a = new GlueDefaultContext();
            }
            for (String string2 : glueContext.keySet()) {
                this.a.put(string2, glueContext.get(string2));
            }
            this.a.put("ServiceName", string);
        }

        @Override
        public void run() {
            MDC.put((String)"ServiceName", (String)((String)this.a.get("ServiceName")));
            GlueBizController glueBizController = GlueBizProvider.getController();
            glueBizController.doAction(this.a);
            MDC.remove((String)"ServiceName");
        }
    }
}

