/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.biz.activity;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.biz.activity.GlueActivity;
import com.poscoict.glueframework.context.GlueContext;
import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.message.GlueMessage;
import com.poscoict.glueframework.message.GlueMessageDefinition;
import com.poscoict.glueframework.message.layout.GlueAbstractFixedLengthMessageLayout;
import com.poscoict.glueframework.message.layout.GlueMessageLayout;
import com.poscoict.glueframework.message.layout.GlueMessageParserException;
import com.poscoict.glueframework.util.GlueFileResourceUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GlueMessageParse
extends GlueActivity<GlueContext> {
    public static final int DEFAULT_MSG_ID_LENGTH = 8;

    @Override
    public String runActivity(GlueContext glueContext) {
        int n;
        String string = this.getProperty("layout");
        String string2 = this.getProperty("id-length");
        String string3 = this.getProperty("charset-name");
        String string4 = this.getProperty("charset");
        String string5 = this.getProperty("message-id");
        GlueMessageLayout glueMessageLayout = GlueStaticContext.getBeanFactory().getBeanObject(string, GlueMessageLayout.class);
        Charset charset = ((GlueAbstractFixedLengthMessageLayout)glueMessageLayout).getCharset();
        if (string3 != null) {
            if (glueContext.get(string3) != null) {
                Object object = glueContext.get(string3);
                if (object instanceof String) {
                    charset = Charset.isSupported((String)object) ? Charset.forName((String)object) : charset;
                } else if (object instanceof String[]) {
                    charset = Charset.isSupported(((String[])object)[0]) ? Charset.forName(((String[])object)[0]) : charset;
                } else if (object instanceof Charset) {
                    charset = (Charset)object;
                }
            } else {
                charset = string4 != null && Charset.isSupported(string4) ? Charset.forName(string4) : charset;
            }
        } else {
            charset = string4 != null && Charset.isSupported(string4) ? Charset.forName(string4) : charset;
        }
        ((GlueAbstractFixedLengthMessageLayout)glueMessageLayout).setCharset(charset);
        this.logger.debug("Message Parsing starts...");
        int n2 = n = string2 == null ? 8 : Integer.parseInt(string2);
        if ("F".equals(glueContext.get("ReceiveTCType"))) {
            File file = (File)glueContext.get("ReceiveTC");
            if (file == null) {
                throw new GlueMessageParserException("File is null !!");
            }
            if (string5 == null) {
                if (file.exists() && file.isFile()) {
                    string5 = file.getName().substring(0, n);
                } else {
                    throw new GlueException("wrong file : " + file);
                }
            }
            List<String> list = GlueFileResourceUtil.readFile(file, charset);
            ArrayList<GlueMessage> arrayList = new ArrayList<GlueMessage>();
            GlueMessageDefinition glueMessageDefinition = glueMessageLayout.getAttributes(string5);
            int n3 = list.size();
            for (int i = 0; i < n3; ++i) {
                GlueMessage glueMessage = glueMessageLayout.makeMessageParsing(glueMessageDefinition, list.get(i));
                glueMessage.setTCID(string5);
                arrayList.add(glueMessage);
            }
            glueContext.setMessages(arrayList);
        } else {
            String string6 = (String)glueContext.get("ReceiveTC");
            if (string6 == null) {
                throw new GlueMessageParserException("TC is null !!");
            }
            if (string5 == null) {
                string5 = string6.substring(0, n);
            }
            GlueMessage glueMessage = glueMessageLayout.makeMessageParsing(glueMessageLayout.getAttributes(string5), string6);
            glueMessage.setTCID(string5);
            glueContext.putAll((Map<? extends String, ? extends Object>)glueMessage.getAttributes());
            glueContext.setMessage(glueMessage);
        }
        this.logger.debug("Message Parsing is completed...");
        return "success";
    }
}

