/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.batch.item;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.dao.manager.GlueQueryDefinition;
import com.poscoict.glueframework.dao.manager.GlueQueryManager;
import javax.sql.DataSource;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamReader;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.mapping.BeanWrapperFieldSetMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.DelimitedLineTokenizer;
import org.springframework.batch.item.file.transform.FixedLengthTokenizer;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.batch.item.file.transform.Range;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;

public class GlueDefaultItemReader<T>
implements ItemStreamReader<T> {
    public static final String READER_RESOURCE_TYPE_KEY = ".reader.resource.type";
    public static final String READER_RESOURCE_NAME_KEY = ".reader.resource.name";
    public static final String READER_FIELD_NAMES_KEY = ".reader.field.names";
    public static final String READER_VO_TYPE_KEY = ".reader.vo.type";
    public static final String READER_DELIMITER_KEY = ".reader.delimiter";
    public static final String READER_COLUMNS_KEY = ".reader.columns";
    public static final String READER_SQL_KEY = ".reader.sql";
    public static final String READER_QUERY_ID_KEY = ".reader.query.id";
    public static final String DELIMITED_FILE_TYPE = "delimitedFile";
    public static final String FIXED_LENGTH_FILE_TYPE = "fixedLengthFile";
    public static final String JDBC_DB_TYPE = "jdbcDb";
    private ItemReader<T> a;
    private String b;
    private Class c;
    private String d;
    private Resource e;
    private String[] f;
    private String g;
    private Range[] h;
    private DataSource i;
    private GlueQueryManager j;

    public void setDataSource(DataSource dataSource) {
        this.i = dataSource;
    }

    public void setQueryManager(GlueQueryManager glueQueryManager) {
        this.j = glueQueryManager;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) throws Exception {
        String string = stepExecution.getStepName();
        JobParameters jobParameters = stepExecution.getJobParameters();
        if (jobParameters.getString(string + READER_RESOURCE_TYPE_KEY) == null) {
            throw new GlueException("check '" + string + READER_RESOURCE_TYPE_KEY + "'.");
        }
        this.b = jobParameters.getString(string + READER_RESOURCE_TYPE_KEY);
        if (DELIMITED_FILE_TYPE.equalsIgnoreCase(this.b) || FIXED_LENGTH_FILE_TYPE.equalsIgnoreCase(this.b)) {
            if (jobParameters.getString(string + READER_RESOURCE_NAME_KEY) == null) {
                throw new GlueException("check '" + string + READER_RESOURCE_NAME_KEY + "'.");
            }
            this.e = new FileSystemResource(jobParameters.getString(string + READER_RESOURCE_NAME_KEY));
            if (jobParameters.getString(string + READER_FIELD_NAMES_KEY) == null) {
                throw new GlueException("check '" + string + READER_FIELD_NAMES_KEY + "'.");
            }
            this.f = jobParameters.getString(string + READER_FIELD_NAMES_KEY).split(",");
            if (jobParameters.getString(string + READER_VO_TYPE_KEY) == null) {
                throw new GlueException("check '" + string + READER_VO_TYPE_KEY + "'.");
            }
            this.c = Class.forName(jobParameters.getString(string + READER_VO_TYPE_KEY));
            if (DELIMITED_FILE_TYPE.equalsIgnoreCase(this.b)) {
                if (jobParameters.getString(string + READER_DELIMITER_KEY) == null) {
                    throw new GlueException("check '" + string + READER_DELIMITER_KEY + "'.");
                }
                this.g = jobParameters.getString(string + READER_DELIMITER_KEY);
            } else {
                if (jobParameters.getString(string + READER_COLUMNS_KEY) == null) {
                    throw new GlueException("check '" + string + READER_COLUMNS_KEY + "'.");
                }
                String[] stringArray = jobParameters.getString(string + READER_COLUMNS_KEY).split(",");
                this.h = new Range[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.h[i] = new Range(Integer.parseInt(stringArray[i].split("-")[0]), Integer.parseInt(stringArray[i].split("-")[1]));
                }
            }
        } else if (JDBC_DB_TYPE.equalsIgnoreCase(this.b)) {
            String string2;
            String string3 = null;
            this.d = jobParameters.getString(string + READER_SQL_KEY);
            string3 = jobParameters.getString(string + READER_VO_TYPE_KEY);
            if (this.j != null && (string2 = jobParameters.getString(string + READER_QUERY_ID_KEY)) != null) {
                GlueQueryDefinition glueQueryDefinition = this.j.getQueryDefinition(string2);
                this.d = glueQueryDefinition.getQueryStatement();
                if (glueQueryDefinition.getMappedClassName() != null && glueQueryDefinition.getMappedClassName().trim().length() != 0) {
                    string3 = glueQueryDefinition.getMappedClassName();
                }
            }
            if (this.d == null) {
                throw new GlueException("check '" + string + READER_SQL_KEY + "' or '" + string + READER_QUERY_ID_KEY + "'.");
            }
            if (string3 == null) {
                throw new GlueException("check '" + string + READER_VO_TYPE_KEY + "' or '" + string + READER_QUERY_ID_KEY + "'.");
            }
            this.c = Class.forName(string3);
        } else {
            throw new GlueException("check '" + string + READER_RESOURCE_TYPE_KEY + "' : " + this.b);
        }
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.a();
        if (this.a instanceof ItemStream) {
            ((ItemStream)this.a).open(executionContext);
        }
    }

    public void close() throws ItemStreamException {
        if (this.a instanceof ItemStream) {
            ((ItemStream)this.a).close();
        }
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.a instanceof ItemStream) {
            ((ItemStream)this.a).update(executionContext);
        }
    }

    public T read() throws Exception, UnexpectedInputException, ParseException, NonTransientResourceException {
        return (T)this.a.read();
    }

    private void a() {
        if (DELIMITED_FILE_TYPE.equalsIgnoreCase(this.b) || FIXED_LENGTH_FILE_TYPE.equalsIgnoreCase(this.b)) {
            this.a = new FlatFileItemReader();
            try {
                LineTokenizer lineTokenizer = null;
                lineTokenizer = DELIMITED_FILE_TYPE.equalsIgnoreCase(this.b) ? this.b() : this.c();
                ((FlatFileItemReader)this.a).setLineMapper(this.a(lineTokenizer));
                ((FlatFileItemReader)this.a).setResource(this.e);
                ((FlatFileItemReader)this.a).afterPropertiesSet();
            }
            catch (Exception exception) {
                throw new GlueException("fail to create FlatFileItemReader");
            }
        }
        this.a = new JdbcCursorItemReader();
        try {
            ((JdbcCursorItemReader)this.a).setDataSource(this.i);
            ((JdbcCursorItemReader)this.a).setRowMapper((RowMapper)new BeanPropertyRowMapper(this.c));
            ((JdbcCursorItemReader)this.a).setSql(this.d);
            ((JdbcCursorItemReader)this.a).afterPropertiesSet();
        }
        catch (Exception exception) {
            throw new GlueException("fail to create JdbcCursorItemReader");
        }
    }

    private LineTokenizer b() {
        DelimitedLineTokenizer delimitedLineTokenizer = new DelimitedLineTokenizer();
        delimitedLineTokenizer.setNames(this.f);
        delimitedLineTokenizer.setDelimiter(this.g);
        return delimitedLineTokenizer;
    }

    private LineTokenizer c() {
        FixedLengthTokenizer fixedLengthTokenizer = new FixedLengthTokenizer();
        fixedLengthTokenizer.setNames(this.f);
        fixedLengthTokenizer.setColumns(this.h);
        return fixedLengthTokenizer;
    }

    private DefaultLineMapper<T> a(LineTokenizer lineTokenizer) throws Exception {
        BeanWrapperFieldSetMapper beanWrapperFieldSetMapper = new BeanWrapperFieldSetMapper();
        beanWrapperFieldSetMapper.setTargetType(this.c);
        beanWrapperFieldSetMapper.afterPropertiesSet();
        DefaultLineMapper defaultLineMapper = new DefaultLineMapper();
        defaultLineMapper.setLineTokenizer(lineTokenizer);
        defaultLineMapper.setFieldSetMapper((FieldSetMapper)beanWrapperFieldSetMapper);
        defaultLineMapper.afterPropertiesSet();
        return defaultLineMapper;
    }
}

