/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.dao.hbase;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.util.log.GlueLog;
import com.poscoict.glueframework.util.log.GlueLogFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.data.hadoop.hbase.RowMapper;
import org.springframework.data.hadoop.hbase.TableCallback;
import org.springframework.util.Assert;

public class GlueHbaseDao
implements InitializingBean {
    private final GlueLog a = GlueLogFactory.getLogger(this.getClass());
    private HbaseTemplate b;
    private String c = "cfInfo";
    private String d = "ROW_ID";

    public void setHbaseTemplate(HbaseTemplate hbaseTemplate) {
        this.b = hbaseTemplate;
    }

    public void setDefaultCf(String string) {
        this.c = string;
    }

    public List<Map<String, Object>> find(String string) {
        return this.find(string, null, null);
    }

    public List<Map<String, Object>> find(String string, String string2) {
        return this.find(string, string2, null);
    }

    public List<Map<String, Object>> find(String string, String string2, Scan scan) {
        if (scan == null) {
            scan = new Scan();
        }
        if (string2 == null) {
            string2 = this.c;
        }
        final byte[] byArray = Bytes.toBytes((String)string2);
        scan.addFamily(byArray);
        this.a.debug("column family : " + string2);
        return this.b.find(string, scan, (RowMapper)new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(Result result, int n) throws Exception {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                List list = result.listCells();
                for (Cell cell : list) {
                    String string = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                    String string2 = Bytes.toString((byte[])result.getValue(byArray, CellUtil.cloneQualifier((Cell)cell)));
                    hashMap.put(string, string2);
                }
                hashMap.put(GlueHbaseDao.this.d, Bytes.toString((byte[])result.getRow()));
                return hashMap;
            }
        });
    }

    public Map<String, Object> save(String string, Map<String, Object> map) {
        return this.save(string, null, map);
    }

    public Map<String, Object> save(String string, String string2, final Map<String, Object> map) {
        if (string2 == null) {
            string2 = this.c;
        }
        this.a.debug("column family : " + string2);
        final byte[] byArray = Bytes.toBytes((String)string2);
        return (Map)this.b.execute(string, (TableCallback)new TableCallback<Map<String, Object>>(){

            public Map<String, Object> doInTable(HTableInterface hTableInterface) throws Throwable {
                String string = (String)map.get(GlueHbaseDao.this.d);
                if (string == null || string.trim().equals("")) {
                    throw new GlueException("ROW_ID IS NULL!!");
                }
                Put put = new Put(Bytes.toBytes((String)string));
                Set set = map.keySet();
                for (String string2 : set) {
                    put.add(byArray, Bytes.toBytes((String)string2), Bytes.toBytes((String)((String)map.get(string2))));
                }
                hTableInterface.put(put);
                return map;
            }
        });
    }

    public String delete(String string, final String string2) {
        return (String)this.b.execute(string, (TableCallback)new TableCallback<String>(){

            public String doInTable(HTableInterface hTableInterface) throws Throwable {
                if (string2 == null || string2.trim().equals("")) {
                    throw new GlueException("ROW_ID IS NULL!!");
                }
                GlueHbaseDao.this.a.debug("delete row key : " + string2);
                Delete delete = new Delete(Bytes.toBytes((String)string2));
                hTableInterface.delete(delete);
                return string2;
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.b, (String)"HbaseTemplate must be provided");
    }
}

