/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.license.util;

import com.poscoict.license.parser.LicenseInfo;
import com.poscoict.license.util.LicenseUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAKey;
import java.security.spec.RSAPrivateKeySpec;
import java.util.List;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class LicenseAPICipher {
    public static final String RSA = "RSA";
    public static final String RSA_ALGORITHM = "RSA/NONE/PKCS1Padding";
    public static final String JCE_PROVIDER = "BC";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey readRSAPrivateKeyFromFile(String fileName) throws Exception {
        PrivateKey privateKey;
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        try {
            RSAPrivateKeySpec rsaPublicKeySpec = new RSAPrivateKeySpec((BigInteger)ois.readObject(), (BigInteger)ois.readObject());
            privateKey = KeyFactory.getInstance(RSA, JCE_PROVIDER).generatePrivate(rsaPublicKeySpec);
        }
        finally {
            ois.close();
        }
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey readRSAPrivateKeyFromJar(Class<?> clazz, String keyExtension) throws Exception {
        PrivateKey privateKey;
        List<InputStream> isList = LicenseUtil.getResourceFromJar(clazz, keyExtension);
        if (isList.size() == 1) {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(isList.get(0)));
            try {
                RSAPrivateKeySpec rsaPublicKeySpec = new RSAPrivateKeySpec((BigInteger)ois.readObject(), (BigInteger)ois.readObject());
                privateKey = KeyFactory.getInstance(RSA, JCE_PROVIDER).generatePrivate(rsaPublicKeySpec);
            }
            finally {
                ois.close();
            }
        } else {
            if (isList.size() > 1) {
                throw new Exception("Please check jar file. License keys are ambiguous.");
            }
            throw new Exception("Please check jar file. No License key is found.");
        }
        return privateKey;
    }

    public static PrivateKey readRSAPrivateKeyFromFile(URL fileUrl) throws Exception {
        return LicenseAPICipher.readRSAPrivateKeyFromFile(fileUrl.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readLicenseFromFile(String fileName) throws Exception {
        String encryptLicense;
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        try {
            encryptLicense = (String)ois.readObject();
        }
        finally {
            ois.close();
        }
        return encryptLicense;
    }

    public static LicenseInfo decryptLicense(PrivateKey privateKey, String encryptLicense) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM, JCE_PROVIDER);
        cipher.init(2, privateKey);
        byte[] decryptData = LicenseAPICipher.processCipher(cipher, Base64.decodeBase64((String)encryptLicense), LicenseAPICipher.getRSAKeyLength(privateKey) / 8);
        return LicenseUtil.convertByteArrayToObject(decryptData, LicenseInfo.class);
    }

    public static byte[] processCipher(Cipher cipher, byte[] data, int length) throws Exception {
        byte[] result = new byte[data.length];
        byte[] temp = new byte[]{};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (data.length > length) {
            int count = data.length / length + 1;
            for (int i = 0; i < count; ++i) {
                temp = new byte[Math.min(data.length - i * length, length)];
                if (temp.length <= 0) continue;
                baos.write(cipher.doFinal(data, i * length, temp.length));
            }
            baos.flush();
            result = baos.toByteArray();
            baos.close();
        } else {
            result = cipher.doFinal(data);
        }
        return result;
    }

    public static int getRSAKeyLength(Key key) {
        int length = 0;
        if (key instanceof RSAKey) {
            length = ((RSAKey)((Object)key)).getModulus().bitLength();
        }
        return length;
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        catch (SecurityException se) {
            System.err.println("Security Permission Fail : " + se.getMessage());
        }
    }
}

