/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.license.parser;

import com.poscoict.license.ObjectFactory;
import com.poscoict.license.PoscoictLicense;
import com.poscoict.license.parser.JAXBHelper;
import com.poscoict.license.parser.LicenseInfo;
import java.io.File;
import java.net.URL;
import java.util.List;

public class LicenseParser {
    private static LicenseParser licenseParser = new LicenseParser();
    private static URL schemaUrl = licenseParser.getClass().getResource("/xsd/PoscoICTLicense.xsd");

    private LicenseParser() {
    }

    public static LicenseParser getInstance() {
        return licenseParser;
    }

    public LicenseInfo parseXml(URL licenseXmlUrl) throws Exception {
        return this.parse(JAXBHelper.unmarshal(PoscoictLicense.class, schemaUrl, licenseXmlUrl));
    }

    public LicenseInfo parseXml(File licenseXmlFile) throws Exception {
        return this.parse(JAXBHelper.unmarshal(PoscoictLicense.class, schemaUrl, licenseXmlFile));
    }

    public LicenseInfo parseXml(String licenseXmlFilePath) throws Exception {
        return this.parse(JAXBHelper.unmarshal(PoscoictLicense.class, schemaUrl, new File(licenseXmlFilePath)));
    }

    public LicenseInfo parseXmlString(String licenseXmlString) throws Exception {
        return this.parse(JAXBHelper.unmarshal(PoscoictLicense.class, schemaUrl, licenseXmlString));
    }

    private LicenseInfo parse(PoscoictLicense license) {
        LicenseInfo licenseInfo = null;
        if (license != null) {
            String strIpAddress;
            String strMacAddress;
            licenseInfo = new LicenseInfo(license.getSolutionName(), license.getCompanyName(), license.getProjectName(), license.getLicenseMode());
            String expireDate = license.getExpireDate();
            if (expireDate != null && expireDate.length() != 0) {
                licenseInfo.setExpireDate(expireDate);
            }
            if ((strMacAddress = license.getMacAddress()) != null) {
                for (String macAddress : strMacAddress.split(",")) {
                    licenseInfo.addMacAddress(macAddress);
                }
            }
            if ((strIpAddress = license.getIpAddress()) != null) {
                for (String ipAddress : strIpAddress.split(",")) {
                    licenseInfo.addIpAddress(ipAddress);
                }
            }
            licenseInfo.setLicenseKey(license.getLicenseKey());
        }
        return licenseInfo;
    }

    public void makeXml(File licenseXmlFile, LicenseInfo licenseInfo) throws Exception {
        JAXBHelper.marshal(PoscoictLicense.class, schemaUrl, (Object)this.make(licenseInfo), licenseXmlFile);
    }

    public String makeXmlString(LicenseInfo licenseInfo) throws Exception {
        return JAXBHelper.marshal(PoscoictLicense.class, schemaUrl, this.make(licenseInfo));
    }

    private PoscoictLicense make(LicenseInfo licenseInfo) {
        List<String> ipAddressList;
        List<String> macAddressList;
        ObjectFactory factory = new ObjectFactory();
        PoscoictLicense license = factory.createPoscoictLicense();
        license.setSolutionName(licenseInfo.getSolutionName());
        license.setCompanyName(licenseInfo.getCompanyName());
        license.setProjectName(licenseInfo.getProjectName());
        license.setLicenseMode(licenseInfo.getLicenseMode());
        String expireDate = licenseInfo.getExpireDate();
        if (expireDate != null && expireDate.length() != 0) {
            license.setExpireDate(expireDate);
        }
        if ((macAddressList = licenseInfo.getMacAddressList()) != null && !macAddressList.isEmpty()) {
            license.setMacAddress(this.join(macAddressList, ","));
        }
        if ((ipAddressList = licenseInfo.getIpAddressList()) != null && !ipAddressList.isEmpty()) {
            license.setIpAddress(this.join(ipAddressList, ","));
        }
        license.setLicenseKey(licenseInfo.getLicenseKey());
        return license;
    }

    private String join(List<String> list, String separator) {
        StringBuilder builder = new StringBuilder();
        for (String str : list) {
            builder.append(str).append(separator);
        }
        builder.delete(builder.length() - 1, builder.length());
        return builder.toString();
    }
}

