/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.license;

import com.poscoict.license.ILicenseLogger;
import com.poscoict.license.LicenseAPI;
import com.poscoict.license.parser.LicenseInfo;
import com.poscoict.license.util.LicenseUtil;
import java.net.NetworkInterface;
import java.text.ParseException;
import java.util.List;

public class License {
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private final LicenseInfo m_licenseInfo;
    private final ILicenseLogger m_licenseLogger;
    private LicenseAPI.LicenseMode m_licenseMode = LicenseAPI.LicenseMode.EDUCATION;
    private long m_expireTime = 0L;
    private boolean m_validProduct = false;

    public License(LicenseInfo licenseInfo, ILicenseLogger licenseLogger) {
        this.m_licenseInfo = licenseInfo;
        this.m_licenseLogger = licenseLogger;
        this.m_licenseMode = LicenseAPI.LicenseMode.valueOf(licenseInfo.getLicenseMode().toUpperCase());
        String expireDate = licenseInfo.getExpireDate();
        if (expireDate != null && expireDate.length() != 0) {
            try {
                this.m_expireTime = LicenseUtil.getTime(expireDate) + 86400000L;
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
    }

    public LicenseAPI.LicenseMode getLicenseMode() {
        return this.m_licenseMode;
    }

    public boolean checkLicense() {
        switch (this.m_licenseMode) {
            case EDUCATION: {
                return false;
            }
            case DEVELOPMENT: {
                return this.checkDevelopmentMode();
            }
            case PRODUCT: {
                return this.checkProductMode();
            }
        }
        return false;
    }

    private boolean checkDevelopmentMode() {
        if (this.m_expireTime == 0L) {
            return false;
        }
        long validTime = this.m_expireTime - System.currentTimeMillis();
        if (validTime >= 604800000L) {
            return true;
        }
        if (validTime >= 86400000L) {
            this.log(LogLevel.info, "Expire date is [" + this.m_licenseInfo.getExpireDate() + "]! Please update license!");
            return true;
        }
        if (validTime > 0L) {
            this.log(LogLevel.error, "Expire date is [" + this.m_licenseInfo.getExpireDate() + "]! Please update license!");
            return true;
        }
        this.log(LogLevel.error, "License was expired!!!");
        return false;
    }

    private boolean checkProductMode() {
        if (this.m_validProduct) {
            return true;
        }
        List<String> licenseMacAddrList = this.m_licenseInfo.getMacAddressList();
        if (licenseMacAddrList != null && !licenseMacAddrList.isEmpty()) {
            if (this.checkMethod(NetworkInterface.class, "getHardwareAddress", new Class[0])) {
                List<String> macAddrList = LicenseUtil.getMACAddress();
                this.log(LogLevel.debug, "System MAC Address = " + macAddrList);
                if (!macAddrList.isEmpty()) {
                    for (String macAddress : macAddrList) {
                        if (!licenseMacAddrList.contains(macAddress)) continue;
                        this.m_validProduct = true;
                        break;
                    }
                    if (!this.m_validProduct) {
                        this.log(LogLevel.error, "All NIC card's mac address are invalid!! Please check license file!!!");
                    }
                } else {
                    this.log(LogLevel.error, "Can not obtain NIC card's mac addresses!! Skip check the license!!");
                    this.m_validProduct = true;
                }
            } else {
                this.log(LogLevel.error, "Java version[" + System.getProperty("java.version") + "] can not check hardware mac address!!!");
            }
        }
        if (this.m_validProduct) {
            return true;
        }
        List<String> licenseIpAddrList = this.m_licenseInfo.getIpAddressList();
        if (licenseIpAddrList != null && !licenseIpAddrList.isEmpty()) {
            List<String> ipAddrList = LicenseUtil.getIPAddress();
            this.m_licenseLogger.debug("[LICENSE] System IP Address = " + ipAddrList);
            if (!ipAddrList.isEmpty()) {
                for (String ipAddress : ipAddrList) {
                    if (!licenseIpAddrList.contains(ipAddress)) continue;
                    this.m_validProduct = true;
                    break;
                }
                if (!this.m_validProduct) {
                    this.log(LogLevel.error, "All IP address are invalid!! Please check license file!!!");
                }
            } else {
                this.log(LogLevel.error, "Can not obtain IP addresses!! Skip check the license!!");
                this.m_validProduct = true;
            }
        }
        if (!this.m_validProduct) {
            this.m_validProduct = this.m_licenseInfo.useAnyMacAddress();
            if (this.m_validProduct) {
                this.log(LogLevel.info, "Skip the license check!!!");
            } else {
                this.log(LogLevel.error, "License invalid!!!");
            }
        }
        return this.m_validProduct;
    }

    private boolean checkMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        try {
            clazz.getDeclaredMethod(methodName, params);
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    private void log(LogLevel level, String message) {
        String prefix = "[LICENSE] ";
        switch (level) {
            case debug: {
                this.m_licenseLogger.debug(prefix + message);
                break;
            }
            case info: {
                this.m_licenseLogger.info(prefix + message);
                break;
            }
            case error: {
                this.m_licenseLogger.error(prefix + message);
            }
        }
    }

    private static enum LogLevel {
        debug,
        info,
        error;

    }
}

