/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.nexacro17.common;

import com.nexacro17.xapi.data.ColumnHeader;
import com.nexacro17.xapi.data.DataSet;
import com.poscoict.glueframework.dao.vo.GlueColumnDef;
import com.poscoict.glueframework.dao.vo.GlueRow;
import com.poscoict.glueframework.dao.vo.GlueRowSet;
import com.poscoict.glueframework.util.log.GlueLog;
import com.poscoict.glueframework.util.log.GlueLogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Converter {
    private static GlueLog a = GlueLogFactory.getLogger(Converter.class);

    public static DataSet convertGlueSetToDataSet(String string, GlueRowSet<?> glueRowSet) {
        if (glueRowSet == null) {
            return null;
        }
        DataSet dataSet = new DataSet(string);
        GlueColumnDef[] glueColumnDefArray = glueRowSet.getColumnDefs();
        for (int i = 0; i < glueColumnDefArray.length; ++i) {
            dataSet.addColumn(glueColumnDefArray[i].getName(), Converter.typeConvertGlueSetToNexacroform(glueColumnDefArray[i].getType()));
        }
        GlueRow[] glueRowArray = glueRowSet.getAllRow();
        GlueRow glueRow = null;
        int n = -1;
        for (int i = 0; i < glueRowArray.length; ++i) {
            glueRow = glueRowArray[i];
            n = dataSet.newRow();
            for (int j = 0; j < glueColumnDefArray.length; ++j) {
                dataSet.set(n, glueColumnDefArray[j].getName(), glueRow.getAttribute((Object)glueColumnDefArray[j].getName()));
            }
        }
        return dataSet;
    }

    public static List<Map<String, Object>> convertDataSetToList(DataSet dataSet) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        ColumnHeader columnHeader = null;
        for (int i = 0; i < dataSet.getRowCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (int j = 0; j < dataSet.getColumnCount(); ++j) {
                columnHeader = dataSet.getColumn(j);
                hashMap.put(columnHeader.getName(), dataSet.getObject(i, columnHeader.getName()));
            }
            a.debug("Row: {}", (Object)((Object)hashMap).toString());
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    public static List<Map<String, Object>> convertDataSetToInsertList(DataSet dataSet) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        ColumnHeader columnHeader = null;
        for (int i = 0; i < dataSet.getRowCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (dataSet.getRowType(i) != 1) continue;
            for (int j = 0; j < dataSet.getColumnCount(); ++j) {
                columnHeader = dataSet.getColumn(j);
                hashMap.put(columnHeader.getName(), dataSet.getObject(i, columnHeader.getName()));
            }
            a.debug("Insert Row : {}", (Object)((Object)hashMap).toString());
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    public static List<Map<String, Object>> convertDataSetToUpdateList(DataSet dataSet) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        ColumnHeader columnHeader = null;
        for (int i = 0; i < dataSet.getRowCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (dataSet.getRowType(i) != 2) continue;
            for (int j = 0; j < dataSet.getColumnCount(); ++j) {
                columnHeader = dataSet.getColumn(j);
                hashMap.put(columnHeader.getName(), dataSet.getObject(i, columnHeader.getName()));
            }
            a.debug("Update Row : {}", (Object)((Object)hashMap).toString());
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    public static List<Map<String, Object>> convertDataSetToDeleteList(DataSet dataSet) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        ColumnHeader columnHeader = null;
        for (int i = 0; i < dataSet.getRemovedRowCount(); ++i) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (int j = 0; j < dataSet.getColumnCount(); ++j) {
                columnHeader = dataSet.getColumn(j);
                hashMap.put(columnHeader.getName(), dataSet.getRemovedData(i, columnHeader.getName()));
            }
            a.debug("Delete Row : {}", (Object)((Object)hashMap).toString());
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    public static int typeConvertGlueSetToNexacroform(int n) {
        int n2 = -1;
        switch (n) {
            case -5: {
                n2 = 5;
                break;
            }
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                n2 = 7;
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                n2 = 2;
                break;
            }
            case 92: {
                n2 = 10;
                break;
            }
            case 91: {
                n2 = 9;
                break;
            }
            case 93: {
                n2 = 11;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                n2 = 12;
                break;
            }
            case 16: {
                n2 = 4;
                break;
            }
            case 2003: {
                break;
            }
            case 70: {
                break;
            }
            case 2001: {
                break;
            }
            case 2000: {
                break;
            }
            case 1111: {
                break;
            }
            case 7: {
                break;
            }
            case 2006: {
                break;
            }
            case 2002: {
                break;
            }
            default: {
                n2 = 2;
            }
        }
        return n2;
    }

    public static int typeConvertNexacroToGlueSet(int n) {
        int n2 = -1;
        switch (n) {
            case 2: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 16;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
            case 9: {
                n2 = 91;
                break;
            }
            case 10: {
                n2 = 92;
                break;
            }
            case 11: {
                n2 = 93;
                break;
            }
            case 12: {
                n2 = 2004;
                break;
            }
        }
        return n2;
    }
}

