/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.dao.redis;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.dao.redis.GlueGenericRedisDao;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.RedisSerializer;

public class GlueRedisDao
implements GlueGenericRedisDao {
    private final Logger a = LoggerFactory.getLogger(this.getClass());
    private RedisTemplate<String, Object> b;
    private RedisConnectionFactory c;
    private RedisSerializer<?> d = null;
    private ValueOperations<String, Object> e;
    private ListOperations<String, Object> f;
    private SetOperations<String, Object> g;
    private ZSetOperations<String, Object> h;
    private HashOperations<String, String, Object> i;

    public void setConnectionFactory(RedisConnectionFactory redisConnectionFactory) {
        this.c = redisConnectionFactory;
    }

    public void setSerializer(RedisSerializer<?> redisSerializer) {
        this.d = redisSerializer;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.c == null) {
            throw new GlueException("ConnectionFactory must not be null!");
        }
        this.b = new RedisTemplate();
        this.b.setConnectionFactory(this.c);
        if (this.d != null) {
            this.b.setDefaultSerializer(this.d);
        }
        this.b.afterPropertiesSet();
        this.e = this.b.opsForValue();
        this.f = this.b.opsForList();
        this.g = this.b.opsForSet();
        this.h = this.b.opsForZSet();
        this.i = this.b.opsForHash();
    }

    @Override
    public ValueOperations<String, Object> getOpsForValue() {
        return this.e;
    }

    @Override
    public ListOperations<String, Object> getOpsForList() {
        return this.f;
    }

    @Override
    public SetOperations<String, Object> getOpsForSet() {
        return this.g;
    }

    @Override
    public ZSetOperations<String, Object> getOpsForZSet() {
        return this.h;
    }

    @Override
    public HashOperations<String, String, Object> getOpsForHash() {
        return this.i;
    }

    @Override
    public DataType getDataType(String string) {
        return this.b.type((Object)string);
    }

    @Override
    public void delete(String string) {
        this.b.delete((Object)string);
    }

    @Override
    public long size(String string) {
        DataType dataType = this.b.type((Object)string);
        long l = -1L;
        switch (dataType) {
            case STRING: {
                this.a.warn("Invalid Type!(STRING)");
                break;
            }
            case LIST: {
                l = this.f.size((Object)string);
                break;
            }
            case SET: {
                l = this.g.size((Object)string);
                break;
            }
            case ZSET: {
                l = this.h.size((Object)string);
                break;
            }
            case HASH: {
                l = this.i.size((Object)string);
                break;
            }
        }
        return l;
    }

    @Override
    public Object opsValueGetObject(String string) {
        Object object = this.e.get((Object)string);
        return object;
    }

    @Override
    public void opsValueSetObject(String string, Object object) {
        this.e.set((Object)string, object);
    }

    @Override
    public List<Object> opsListGetList(String string) {
        return this.f.range((Object)string, 0L, -1L);
    }

    @Override
    public List<Object> opsListGetList(String string, long l, long l2) {
        return this.f.range((Object)string, l, l2);
    }

    @Override
    public long opsListAddObject(String string, Object object) {
        return this.f.rightPush((Object)string, object);
    }

    @Override
    public long opsListAddListAll(String string, List<Object> list) {
        long l = -1L;
        for (Object object : list) {
            l = this.f.rightPush((Object)string, object);
        }
        return l;
    }

    @Override
    public Set<Object> opsSetGetSet(String string) {
        return this.g.members((Object)string);
    }

    @Override
    public long opsSetAddObject(String string, Object object) {
        return this.g.add((Object)string, new Object[]{object});
    }

    @Override
    public long opsSetAddSet(String string, Set<Object> set) {
        long l = 0L;
        for (Object object : set) {
            l += this.g.add((Object)string, new Object[]{object}).longValue();
        }
        return l;
    }

    @Override
    public Set<Object> opsZSetGetSet(String string) {
        return this.h.range((Object)string, 0L, -1L);
    }

    @Override
    public Set<Object> opsZSetGetSet(String string, long l, long l2) {
        return this.h.range((Object)string, l, l2);
    }

    @Override
    public Set<Object> opsZSetGetSetByScore(String string, double d, double d2) {
        return this.h.rangeByScore((Object)string, d, d2);
    }

    @Override
    public boolean opsZSetAddObject(String string, Object object, double d) {
        return this.h.add((Object)string, object, d);
    }

    @Override
    public double opsZSetGetScore(String string, Object object) {
        return this.h.score((Object)string, object);
    }

    @Override
    public long opsZSetRank(String string, Object object) {
        return this.h.rank((Object)string, object);
    }

    @Override
    public long opsZSetRemoveByScore(String string, double d, double d2) {
        return this.h.removeRangeByScore((Object)string, d, d2);
    }

    @Override
    public Map<String, Object> opsHashGetMap(String string) {
        return this.i.entries((Object)string);
    }

    @Override
    public Object opsHashGetObject(String string, String string2) {
        return this.i.get((Object)string, (Object)string2);
    }

    @Override
    public void opsHashAddObject(String string, String string2, Object object) {
        this.i.put((Object)string, (Object)string2, object);
    }

    @Override
    public void opsHashAddMap(String string, Map<String, Object> map) {
        this.i.putAll((Object)string, map);
    }

    @Override
    public Set<String> opsHashKeys(String string) {
        return this.i.keys((Object)string);
    }
}

