/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.scheduling.store;

import com.poscoict.glueframework.scheduling.GlueSchedulerException;
import com.poscoict.glueframework.scheduling.store.GlueLoggigQuery;
import com.poscoict.glueframework.scheduling.store.GlueScheduledTaskLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;

public class GlueScheduledTaskDBLoggerImpl
implements GlueScheduledTaskLogger,
InitializingBean {
    private final Logger a = LoggerFactory.getLogger(this.getClass());
    private DataSource b;
    private GlueLoggigQuery c;

    public void setDataSource(DataSource dataSource) {
        this.b = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object startTask(Object object) {
        Object object2;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)this.b);
            preparedStatement = connection.prepareStatement(this.c.getInsertQuery());
            preparedStatement.setObject(1, object);
            preparedStatement.setObject(2, "RUNNING");
            preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement(this.c.getSelectQuery());
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            object2 = resultSet.getObject(1);
        }
        catch (SQLException sQLException) {
            try {
                this.a.error("fail to log on db", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement(preparedStatement);
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.b);
                throw throwable;
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement((Statement)preparedStatement);
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.b);
            return null;
        }
        JdbcUtils.closeResultSet((ResultSet)resultSet);
        JdbcUtils.closeStatement((Statement)preparedStatement);
        DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.b);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endTask(Object object) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)this.b);
            preparedStatement = connection.prepareStatement(this.c.getUpdateQuery());
            preparedStatement.setObject(1, "COMPLETED");
            preparedStatement.setObject(2, "");
            preparedStatement.setObject(3, object);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                this.a.error("fail to log on db", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(preparedStatement);
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.b);
                throw throwable;
            }
            JdbcUtils.closeStatement((Statement)preparedStatement);
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.b);
        }
        JdbcUtils.closeStatement((Statement)preparedStatement);
        DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endTask(Object object, Throwable throwable) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)this.b);
            preparedStatement = connection.prepareStatement(this.c.getUpdateQuery());
            preparedStatement.setObject(1, "ERROR");
            preparedStatement.setObject(2, throwable.getMessage());
            preparedStatement.setObject(3, object);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                this.a.error("fail to log on db", (Throwable)sQLException);
            }
            catch (Throwable throwable2) {
                JdbcUtils.closeStatement(preparedStatement);
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.b);
                throw throwable2;
            }
            JdbcUtils.closeStatement((Statement)preparedStatement);
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.b);
        }
        JdbcUtils.closeStatement((Statement)preparedStatement);
        DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.b, (String)"DataSource must be provided");
        Connection connection = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)this.b);
            String string = connection.getMetaData().getDatabaseProductName();
            this.a.debug("Loaded JDBC Driver: {}", (Object)this.b.getConnection().getMetaData().getDriverName());
            this.a.debug("Loaded JDBC Driver Version: {}", (Object)this.b.getConnection().getMetaData().getDriverVersion());
            this.a.debug("DBMS Name: {}", (Object)this.b.getConnection().getMetaData().getDatabaseProductName());
            this.a.debug("DBMS Version: {}", (Object)this.b.getConnection().getMetaData().getDatabaseProductVersion());
            this.a.debug("DBMS URL: {}", (Object)this.b.getConnection().getMetaData().getURL());
            this.a.debug("auto commit: {}", (Object)this.b.getConnection().getAutoCommit());
            for (TaskLoggingQuery taskLoggingQuery : TaskLoggingQuery.values()) {
                if (!string.equals(taskLoggingQuery.toString())) continue;
                this.c = taskLoggingQuery;
            }
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.b);
        }
        if (this.c == null) {
            throw new GlueSchedulerException("not supported..");
        }
    }

    public static enum TaskLoggingQuery implements GlueLoggigQuery
    {
        Oracle("Oracle"){

            @Override
            public String getSelectQuery() {
                return "select GLUE_SCHEDULER_SEQ.currval from dual";
            }

            @Override
            public String getInsertQuery() {
                return "INSERT INTO GLUE_SCHEDULER_HISTORY (JOB_ID,SERVICE_NAME,START_TIME,STATUS,LAST_UPDATED) VALUES(GLUE_SCHEDULER_SEQ.nextval,?,CURRENT_TIMESTAMP,?,CURRENT_TIMESTAMP)";
            }

            @Override
            public String getUpdateQuery() {
                return "UPDATE GLUE_SCHEDULER_HISTORY SET END_TIME=CURRENT_TIMESTAMP, LAST_UPDATED=CURRENT_TIMESTAMP, STATUS=?, ERROR_MESSAGE=? WHERE JOB_ID=?";
            }
        };

        private final String a;

        private TaskLoggingQuery(String string2) {
            this.a = string2;
        }

        public String toString() {
            return this.a;
        }
    }
}

