/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.scheduling.store;

import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.scheduling.GlueSchedulerException;
import com.poscoict.glueframework.scheduling.store.GlueLoggigQuery;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;

public class GlueScheduledJobInfoLogger
implements JobListener,
InitializingBean {
    private final Logger b = LoggerFactory.getLogger(this.getClass());
    private DataSource c;
    private GlueLoggigQuery d;
    protected static final String a = "__primary_key__";

    public void setDataSource(DataSource dataSource) {
        this.c = dataSource;
    }

    public String getName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void jobToBeExecuted(JobExecutionContext jobExecutionContext) {
        Trigger trigger = jobExecutionContext.getTrigger();
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        this.b.trace("jobToBeExecuted {}", (Object)jobDetail.getName());
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)this.c);
            preparedStatement = connection.prepareStatement(this.d.getInsertQuery());
            preparedStatement.setObject(1, jobExecutionContext.getScheduler().getSchedulerInstanceId());
            preparedStatement.setObject(2, trigger.getKey().getName());
            preparedStatement.setObject(3, trigger.getKey().getGroup());
            preparedStatement.setObject(4, jobDetail.getKey().getName());
            preparedStatement.setObject(5, jobDetail.getKey().getGroup());
            preparedStatement.setObject(6, this.a(trigger.isVolatile()));
            preparedStatement.setObject(7, this.a(jobDetail.isStateful()));
            preparedStatement.setObject(8, this.a(jobDetail.requestsRecovery()));
            preparedStatement.setObject(9, "RUNNING");
            preparedStatement.setObject(10, new Timestamp(jobExecutionContext.getNextFireTime().getTime()));
            preparedStatement.setObject(11, new Timestamp(jobExecutionContext.getFireTime().getTime()));
            preparedStatement.setObject(12, jobDetail.getJobDataMap().getWrappedMap().toString());
            preparedStatement.setObject(13, GlueStaticContext.getSystemProperty((String)"glue.scheduler.server.address"));
            preparedStatement.setObject(14, GlueStaticContext.getSystemProperty((String)"glue.scheduler.server.port"));
            preparedStatement.executeUpdate();
            JdbcUtils.closeStatement((Statement)preparedStatement);
            preparedStatement = connection.prepareStatement(this.d.getSelectQuery());
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            jobExecutionContext.put((Object)a, resultSet.getObject(1));
        }
        catch (SQLException sQLException) {
            this.b.error("fail to log on db", (Throwable)sQLException);
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement((Statement)preparedStatement);
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
        }
        catch (SchedulerException schedulerException) {
            this.b.error("fail to get Scheduler Instance Id", (Throwable)schedulerException);
            {
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(resultSet);
                    JdbcUtils.closeStatement(preparedStatement);
                    DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
                    throw throwable;
                }
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement((Statement)preparedStatement);
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
        }
        JdbcUtils.closeResultSet((ResultSet)resultSet);
        JdbcUtils.closeStatement((Statement)preparedStatement);
        DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void jobExecutionVetoed(JobExecutionContext jobExecutionContext) {
        Trigger trigger = jobExecutionContext.getTrigger();
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        this.b.trace("jobExecutionVetoed {}", (Object)jobDetail.getName());
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)this.c);
            preparedStatement = connection.prepareStatement(this.d.getInsertQuery());
            preparedStatement.setObject(1, jobExecutionContext.getScheduler().getSchedulerInstanceId());
            preparedStatement.setObject(2, trigger.getKey().getName());
            preparedStatement.setObject(3, trigger.getKey().getGroup());
            preparedStatement.setObject(4, jobDetail.getKey().getName());
            preparedStatement.setObject(5, jobDetail.getKey().getGroup());
            preparedStatement.setObject(6, this.a(trigger.isVolatile()));
            preparedStatement.setObject(7, this.a(jobDetail.isStateful()));
            preparedStatement.setObject(8, this.a(jobDetail.requestsRecovery()));
            preparedStatement.setObject(9, "VETOED");
            preparedStatement.setObject(10, new Timestamp(jobExecutionContext.getNextFireTime().getTime()));
            preparedStatement.setObject(11, null);
            preparedStatement.setObject(12, jobDetail.getJobDataMap().getWrappedMap().toString());
            preparedStatement.setObject(13, GlueStaticContext.getSystemProperty((String)"glue.scheduler.server.address"));
            preparedStatement.setObject(14, GlueStaticContext.getSystemProperty((String)"glue.scheduler.server.port"));
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            this.b.error("fail to log on db", (Throwable)sQLException);
            JdbcUtils.closeStatement((Statement)preparedStatement);
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
        }
        catch (SchedulerException schedulerException) {
            this.b.error("fail to get Scheduler Instance Id", (Throwable)schedulerException);
            {
                catch (Throwable throwable) {
                    JdbcUtils.closeStatement(preparedStatement);
                    DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
                    throw throwable;
                }
            }
            JdbcUtils.closeStatement((Statement)preparedStatement);
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
        }
        JdbcUtils.closeStatement((Statement)preparedStatement);
        DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        this.b.trace("jobExecutionVetoed {}", (Object)jobDetail.getName());
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)this.c);
            preparedStatement = connection.prepareStatement(this.d.getUpdateQuery());
            preparedStatement.setObject(1, jobExecutionException == null ? "COMPLETED" : "ERROR");
            preparedStatement.setObject(2, jobExecutionException == null ? "S" : "F");
            preparedStatement.setObject(3, new Timestamp(jobExecutionContext.getFireTime().getTime() + jobExecutionContext.getJobRunTime()));
            preparedStatement.setObject(4, jobExecutionContext.get((Object)a));
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                this.b.error("fail to log on db", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(preparedStatement);
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
                throw throwable;
            }
            JdbcUtils.closeStatement((Statement)preparedStatement);
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
        }
        JdbcUtils.closeStatement((Statement)preparedStatement);
        DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
    }

    private String a(boolean bl) {
        return bl ? "Y" : "N";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.c, (String)"DataSource must be provided");
        Connection connection = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)this.c);
            String string = connection.getMetaData().getDatabaseProductName();
            this.b.debug("Loaded JDBC Driver: {}", (Object)this.c.getConnection().getMetaData().getDriverName());
            this.b.debug("Loaded JDBC Driver Version: {}", (Object)this.c.getConnection().getMetaData().getDriverVersion());
            this.b.debug("DBMS Name: {}", (Object)this.c.getConnection().getMetaData().getDatabaseProductName());
            this.b.debug("DBMS Version: {}", (Object)this.c.getConnection().getMetaData().getDatabaseProductVersion());
            this.b.debug("DBMS URL: {}", (Object)this.c.getConnection().getMetaData().getURL());
            for (JobLoggingQuery jobLoggingQuery : JobLoggingQuery.values()) {
                if (!string.equals(jobLoggingQuery.toString())) continue;
                this.d = jobLoggingQuery;
            }
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.c);
        }
        if (this.d == null) {
            throw new GlueSchedulerException("not supported..");
        }
        if (this.c == null) {
            throw new GlueSchedulerException("Set property 'dataSource'");
        }
        this.b.info("ScheduledJob Info Logger is initialized...");
    }

    public static enum JobLoggingQuery implements GlueLoggigQuery
    {
        Oracle("Oracle"){

            @Override
            public String getSelectQuery() {
                return "select SQ_JOB_EXECUTION_ID.currval from dual";
            }

            @Override
            public String getInsertQuery() {
                return "insert into SCHEDULED_JOB_HISTORY (EXECUTION_ID,INSTANCE_NAME,TRIGGER_NAME,TRIGGER_GROUP,JOB_NAME,JOB_GROUP,IS_VOLATILE,IS_STATEFUL,REQUESTS_RECOVERY,STATUS,NEXT_START_TIME,START_TIME,LAST_UPDATED,JOB_DATA,SERVER_ADDRESS,SERVER_PORT) values (SQ_JOB_EXECUTION_ID.nextval,?,?,?,?, ?,?,?,?, ?,?,?,CURRENT_TIMESTAMP,?,?,?)";
            }

            @Override
            public String getUpdateQuery() {
                return "update SCHEDULED_JOB_HISTORY set STATUS=?, RESULT_FLAG=?, END_TIME=?, LAST_UPDATED=CURRENT_TIMESTAMP where EXECUTION_ID=?";
            }
        };

        private final String a;

        private JobLoggingQuery(String string2) {
            this.a = string2;
        }

        public String toString() {
            return this.a;
        }
    }
}

