/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.scheduling.server;

import com.poscoict.glueframework.scheduling.remote.GlueJobDefinition;
import com.poscoict.glueframework.scheduling.remote.GlueJobEventReceiver;
import com.poscoict.glueframework.scheduling.server.GlueHttpRequestMessage;
import com.poscoict.glueframework.scheduling.server.GlueHttpResponseMessage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.SessionLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlueServerHandler
extends IoHandlerAdapter {
    private final Logger b = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final int DEFAULT_IDLE_TIME = 60;
    protected static final String a = "@jobParam-";
    private GlueJobEventReceiver c;

    public GlueServerHandler() {
    }

    public GlueServerHandler(GlueJobEventReceiver glueJobEventReceiver) {
        this.c = glueJobEventReceiver;
    }

    public void sessionOpened(IoSession ioSession) {
        ioSession.setIdleTime(IdleStatus.BOTH_IDLE, 60);
    }

    private void a(IoSession ioSession, Object object) {
        Object object22;
        Set set = ioSession.getAttributeKeys();
        for (Object object22 : set) {
            String string = object22 != null ? object22.toString() : null;
            this.b.info("session attr: key[{}], value[{}]", (Object)string, ioSession.getAttribute(string));
        }
        object22 = (GlueHttpRequestMessage)object;
        for (String string : ((GlueHttpRequestMessage)object22).getHeaders().keySet()) {
            if (!string.startsWith("@")) continue;
            string = string.substring(1);
            this.b.debug("request param: key[{}], value[{}]", (Object)string, (Object)((GlueHttpRequestMessage)object22).getParameter(string));
        }
    }

    protected GlueJobDefinition a(GlueHttpRequestMessage glueHttpRequestMessage) {
        String string = glueHttpRequestMessage.getParameter("request_id");
        String string2 = glueHttpRequestMessage.getParameter("job_name");
        GlueJobDefinition glueJobDefinition = new GlueJobDefinition(string, string2);
        glueJobDefinition.setClientIp(glueHttpRequestMessage.getParameter("client_ip"));
        Map<String, String[]> map = glueHttpRequestMessage.getHeaders();
        Iterator<String> iterator = map.keySet().iterator();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (iterator.hasNext()) {
            String string3 = iterator.next();
            if (!string3.startsWith(a)) continue;
            Object object = map.get(string3);
            if (object instanceof String[]) {
                String[] stringArray = object;
                object = stringArray.length == 0 ? "" : stringArray[0];
            }
            try {
                string3 = string3.replaceAll(a, "");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.b.warn("Cannot convert key [{}]", (Object)string3);
                this.b.warn(stringIndexOutOfBoundsException.getMessage());
            }
            hashMap.put(string3, object);
        }
        if (hashMap.containsKey("_user_id_")) {
            hashMap.put("_user_id_", hashMap.get("_user_id_").toString());
        } else {
            hashMap.put("_user_id_", "Anonymous");
        }
        hashMap.put("request_id", string);
        hashMap.put("client_ip", glueJobDefinition.getClientIp());
        glueJobDefinition.setParameters(hashMap);
        this.b.info("JobDefinition Parameters :{}", hashMap);
        return glueJobDefinition;
    }

    public void messageReceived(IoSession ioSession, Object object) {
        if (this.b.isDebugEnabled()) {
            this.a(ioSession, object);
        }
        GlueHttpResponseMessage glueHttpResponseMessage = new GlueHttpResponseMessage();
        glueHttpResponseMessage.setContentType("text/plain");
        try {
            GlueJobDefinition glueJobDefinition = this.a((GlueHttpRequestMessage)object);
            this.c.receiveJobEvent(glueJobDefinition);
            glueHttpResponseMessage.setResponseCode(700);
            glueHttpResponseMessage.appendBody("SUCCESS");
        }
        catch (Exception exception) {
            this.b.error("Fail to execute Job", (Throwable)exception);
            glueHttpResponseMessage.setResponseCode(800);
            glueHttpResponseMessage.appendBody("FAILURE");
        }
        if (glueHttpResponseMessage != null) {
            ioSession.write((Object)glueHttpResponseMessage).join();
        }
    }

    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) {
        SessionLog.info((IoSession)ioSession, (String)"Disconnecting the idle.");
        ioSession.close();
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        SessionLog.info((IoSession)ioSession, (String)("exception caught -> " + throwable.getMessage()));
        ioSession.close();
    }
}

