/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.scheduling;

import com.poscoict.glueframework.biz.control.GlueBizController;
import com.poscoict.glueframework.biz.control.GlueBizProvider;
import com.poscoict.glueframework.context.GlueContext;
import com.poscoict.glueframework.context.GlueDefaultContext;
import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.dao.vo.GlueAuditAttributes;
import java.util.Map;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class GlueQuartzJobBean
extends QuartzJobBean {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("{} is starting by {}.", (Object)jobExecutionContext.getJobDetail().getKey(), (Object)jobExecutionContext.getTrigger().getKey());
                this.logger.trace("{}", (Object)jobExecutionContext.getJobDetail().getJobDataMap());
                this.logger.trace("{}", (Object)jobExecutionContext.getMergedJobDataMap());
            }
            this.beforeExecuteJob(jobExecutionContext);
            this.executeJob(jobExecutionContext);
            this.afterExecuteJob(jobExecutionContext);
        }
        finally {
            this.logger.info("Job Elasped time... [{}]ms", (Object)jobExecutionContext.getJobRunTime());
        }
    }

    protected void executeJob(JobExecutionContext jobExecutionContext) {
        GlueDefaultContext glueDefaultContext = new GlueDefaultContext();
        glueDefaultContext.putAll((Map)jobExecutionContext.getJobDetail().getJobDataMap());
        for (Object e : jobExecutionContext.getJobDetail().getJobDataMap().keySet()) {
            if (!jobExecutionContext.getMergedJobDataMap().containsKey(e)) continue;
            glueDefaultContext.put(e.toString(), jobExecutionContext.getMergedJobDataMap().get(e));
        }
        if (GlueStaticContext.isAudit()) {
            glueDefaultContext.setAuditAttributes(new GlueAuditAttributes((GlueContext)glueDefaultContext));
        }
        MDC.put((String)"ServiceName", (String)((String)glueDefaultContext.get((Object)"ServiceName")));
        GlueBizController glueBizController = GlueBizProvider.getController();
        glueBizController.doAction((GlueContext)glueDefaultContext);
        MDC.remove((String)"ServiceName");
    }

    protected void beforeExecuteJob(JobExecutionContext jobExecutionContext) {
    }

    protected void afterExecuteJob(JobExecutionContext jobExecutionContext) {
    }
}

