/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.batch.item;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.dao.manager.GlueQueryDefinition;
import com.poscoict.glueframework.dao.manager.GlueQueryManager;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.BeanPropertyItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.JdbcBatchItemWriter;
import org.springframework.batch.item.file.FlatFileItemWriter;
import org.springframework.batch.item.file.transform.BeanWrapperFieldExtractor;
import org.springframework.batch.item.file.transform.DelimitedLineAggregator;
import org.springframework.batch.item.file.transform.FieldExtractor;
import org.springframework.batch.item.file.transform.FormatterLineAggregator;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class GlueDefaultItemWriter<T>
implements ItemStreamWriter<T> {
    public static final String WRITER_RESOURCE_TYPE_KEY = ".writer.resource.type";
    public static final String WRITER_RESOURCE_NAME_KEY = ".writer.resource.name";
    public static final String WRITER_FIELD_NAMES_KEY = ".writer.field.names";
    public static final String WRITER_FIELD_FORMAT = ".writer.field.format";
    public static final String WRITER_DELIMITER_KEY = ".writer.delimiter";
    public static final String WRITER_SQL_KEY = ".writer.sql";
    public static final String WRITER_QUERY_ID_KEY = ".writer.query.id";
    public static final String DELIMITED_FILE_TYPE = "delimitedFile";
    public static final String FORMAT_FILE_TYPE = "formatFile";
    public static final String JDBC_DB_TYPE = "jdbcDb";
    private ItemWriter<T> a;
    private String b;
    private String c;
    private Resource d;
    private String[] e;
    private String f;
    private String g;
    private DataSource h;
    private GlueQueryManager i;

    public void setDataSource(DataSource dataSource) {
        this.h = dataSource;
    }

    public void setQueryManager(GlueQueryManager glueQueryManager) {
        this.i = glueQueryManager;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) throws ClassNotFoundException {
        String string = stepExecution.getStepName();
        JobParameters jobParameters = stepExecution.getJobParameters();
        if (jobParameters.getString(string + WRITER_RESOURCE_TYPE_KEY) == null) {
            throw new GlueException("check '" + string + WRITER_RESOURCE_TYPE_KEY + "'.");
        }
        this.b = jobParameters.getString(string + WRITER_RESOURCE_TYPE_KEY);
        if (DELIMITED_FILE_TYPE.equalsIgnoreCase(this.b) || FORMAT_FILE_TYPE.equalsIgnoreCase(this.b)) {
            if (jobParameters.getString(string + WRITER_RESOURCE_NAME_KEY) == null) {
                throw new GlueException("check '" + string + WRITER_RESOURCE_NAME_KEY + "'.");
            }
            this.d = new FileSystemResource(jobParameters.getString(string + WRITER_RESOURCE_NAME_KEY));
            if (jobParameters.getString(string + WRITER_FIELD_NAMES_KEY) == null) {
                throw new GlueException("check '" + string + WRITER_FIELD_NAMES_KEY + "'.");
            }
            this.e = jobParameters.getString(string + WRITER_FIELD_NAMES_KEY).split(",");
            if (DELIMITED_FILE_TYPE.equalsIgnoreCase(this.b)) {
                if (jobParameters.getString(string + WRITER_DELIMITER_KEY) == null) {
                    throw new GlueException("check '" + string + WRITER_DELIMITER_KEY + "'.");
                }
                this.f = jobParameters.getString(string + WRITER_DELIMITER_KEY);
            } else {
                if (jobParameters.getString(string + WRITER_FIELD_FORMAT) == null) {
                    throw new GlueException("check '" + string + WRITER_FIELD_FORMAT + "'.");
                }
                this.g = jobParameters.getString(string + WRITER_FIELD_FORMAT);
            }
        } else if (JDBC_DB_TYPE.equalsIgnoreCase(this.b)) {
            String string2;
            this.c = jobParameters.getString(string + WRITER_SQL_KEY);
            if (this.i != null && (string2 = jobParameters.getString(string + WRITER_QUERY_ID_KEY)) != null) {
                GlueQueryDefinition glueQueryDefinition = this.i.getQueryDefinition(string2);
                this.c = glueQueryDefinition.getQueryStatement();
            }
            if (this.c == null) {
                throw new GlueException("check '" + string + WRITER_SQL_KEY + "' or '" + string + WRITER_QUERY_ID_KEY + "'.");
            }
        } else {
            throw new GlueException("check '" + string + WRITER_RESOURCE_TYPE_KEY + "' : " + this.b);
        }
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.a();
        if (this.a instanceof ItemStream) {
            ((ItemStream)this.a).open(executionContext);
        }
    }

    public void close() throws ItemStreamException {
        if (this.a instanceof ItemStream) {
            ((ItemStream)this.a).close();
        }
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.a instanceof ItemStream) {
            ((ItemStream)this.a).update(executionContext);
        }
    }

    public void write(List<? extends T> list) throws Exception {
        this.a.write(list);
    }

    private void a() {
        if (DELIMITED_FILE_TYPE.equalsIgnoreCase(this.b) || FORMAT_FILE_TYPE.equalsIgnoreCase(this.b)) {
            this.a = new FlatFileItemWriter();
            try {
                Object object = null;
                object = DELIMITED_FILE_TYPE.equalsIgnoreCase(this.b) ? this.a(this.b()) : this.b(this.b());
                ((FlatFileItemWriter)this.a).setResource(this.d);
                ((FlatFileItemWriter)this.a).setLineAggregator(object);
                ((FlatFileItemWriter)this.a).afterPropertiesSet();
            }
            catch (Exception exception) {
                throw new GlueException("fail to create FlatFileItemWriter");
            }
        }
        this.a = new JdbcBatchItemWriter();
        try {
            ((JdbcBatchItemWriter)this.a).setDataSource(this.h);
            ((JdbcBatchItemWriter)this.a).setSql(this.c);
            ((JdbcBatchItemWriter)this.a).setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
            ((JdbcBatchItemWriter)this.a).setAssertUpdates(true);
            ((JdbcBatchItemWriter)this.a).afterPropertiesSet();
        }
        catch (Exception exception) {
            throw new GlueException("fail to create JdbcBatchItemWriter");
        }
    }

    private FieldExtractor<T> b() {
        BeanWrapperFieldExtractor beanWrapperFieldExtractor = new BeanWrapperFieldExtractor();
        beanWrapperFieldExtractor.setNames(this.e);
        beanWrapperFieldExtractor.afterPropertiesSet();
        return beanWrapperFieldExtractor;
    }

    private DelimitedLineAggregator<T> a(FieldExtractor<T> fieldExtractor) {
        DelimitedLineAggregator delimitedLineAggregator = new DelimitedLineAggregator();
        delimitedLineAggregator.setFieldExtractor(fieldExtractor);
        delimitedLineAggregator.setDelimiter(this.f);
        return delimitedLineAggregator;
    }

    private LineAggregator<T> b(FieldExtractor<T> fieldExtractor) {
        FormatterLineAggregator formatterLineAggregator = new FormatterLineAggregator();
        formatterLineAggregator.setFieldExtractor(fieldExtractor);
        formatterLineAggregator.setFormat(this.g);
        return formatterLineAggregator;
    }
}

