/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.struct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.control.group.GroupAttrName;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;
import org.apache.jcs.utils.struct.DoubleLinkedList;
import org.apache.jcs.utils.struct.LRUElementDescriptor;
import org.apache.jcs.utils.struct.LRUMapEntry;

public class LRUMap
implements Map {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$utils$struct$LRUMap == null ? (class$org$apache$jcs$utils$struct$LRUMap = LRUMap.class$("org.apache.jcs.utils.struct.LRUMap")) : class$org$apache$jcs$utils$struct$LRUMap));
    private DoubleLinkedList list = new DoubleLinkedList();
    protected Map map = new Hashtable();
    int hitCnt = 0;
    int missCnt = 0;
    int putCnt = 0;
    int maxObjects = -1;
    private int chunkSize = 1;
    static /* synthetic */ Class class$org$apache$jcs$utils$struct$LRUMap;

    public LRUMap() {
    }

    public LRUMap(int maxObjects) {
        this();
        this.maxObjects = maxObjects;
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
        this.list.removeAll();
    }

    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Collection values() {
        return this.map.values();
    }

    public void putAll(Map source) {
        if (source != null) {
            Set entries = source.entrySet();
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Object get(Object key) {
        LRUElementDescriptor me;
        Object retVal = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting item  for key " + key));
        }
        if ((me = (LRUElementDescriptor)this.map.get(key)) != null) {
            ++this.hitCnt;
            if (log.isDebugEnabled()) {
                log.debug((Object)("LRUMap hit for " + key));
            }
            retVal = me.getPayload();
            this.list.makeFirst(me);
        } else {
            ++this.missCnt;
            log.debug((Object)("LRUMap miss for " + key));
        }
        return retVal;
    }

    public Object getQuiet(Object key) {
        Object ce = null;
        LRUElementDescriptor me = (LRUElementDescriptor)this.map.get(key);
        if (me != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("LRUMap quiet hit for " + key));
            }
            ce = me.getPayload();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("LRUMap quiet miss for " + key));
        }
        return ce;
    }

    public Object remove(Object key) {
        LRUElementDescriptor me;
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing item for key: " + key));
        }
        if ((me = (LRUElementDescriptor)this.map.remove(key)) != null) {
            this.list.remove(me);
            return me.getPayload();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object put(Object key, Object value) {
        ++this.putCnt;
        LRUElementDescriptor old = null;
        LRUMap lRUMap = this;
        synchronized (lRUMap) {
            this.addFirst(key, value);
            old = (LRUElementDescriptor)this.map.put(((LRUElementDescriptor)this.list.getFirst()).getKey(), this.list.getFirst());
            if (old != null && ((LRUElementDescriptor)this.list.getFirst()).getKey().equals(old.getKey())) {
                this.list.remove(old);
            }
        }
        int size = this.map.size();
        if (this.maxObjects >= 0 && size > this.maxObjects) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"In memory limit reached, removing least recently used.");
            }
            int chunkSizeCorrected = Math.min(size, this.getChunkSize());
            if (log.isDebugEnabled()) {
                log.debug((Object)("About to remove the least recently used. map size: " + size + ", max objects: " + this.maxObjects + ", items to spool: " + chunkSizeCorrected));
            }
            for (int i = 0; i < chunkSizeCorrected; ++i) {
                LRUMap lRUMap2 = this;
                synchronized (lRUMap2) {
                    if (this.list.getLast() != null) {
                        if ((LRUElementDescriptor)this.list.getLast() == null) throw new Error("update: last.ce is null!");
                        this.processRemovedLRU(((LRUElementDescriptor)this.list.getLast()).getKey(), ((LRUElementDescriptor)this.list.getLast()).getPayload());
                        if (!this.map.containsKey(((LRUElementDescriptor)this.list.getLast()).getKey())) {
                            log.error((Object)("update: map does not contain key: " + ((LRUElementDescriptor)this.list.getLast()).getKey()));
                            this.verifyCache();
                        }
                        if (this.map.remove(((LRUElementDescriptor)this.list.getLast()).getKey()) == null) {
                            log.warn((Object)("update: remove failed for key: " + ((LRUElementDescriptor)this.list.getLast()).getKey()));
                            this.verifyCache();
                        }
                    } else {
                        this.verifyCache();
                        throw new Error("update: last is null!");
                    }
                    this.list.removeLast();
                    continue;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("update: After spool map size: " + this.map.size()));
            }
            if (this.map.size() != this.dumpCacheSize()) {
                log.error((Object)("update: After spool, size mismatch: map.size() = " + this.map.size() + ", linked list size = " + this.dumpCacheSize()));
            }
        }
        if (old == null) return null;
        return old.getPayload();
    }

    private synchronized void addFirst(Object key, Object val) {
        LRUElementDescriptor me = new LRUElementDescriptor(key, val);
        this.list.addFirst(me);
    }

    private int dumpCacheSize() {
        return this.list.size();
    }

    public void dumpCacheEntries() {
        log.debug((Object)"dumpingCacheEntries");
        LRUElementDescriptor me = (LRUElementDescriptor)this.list.getFirst();
        while (me != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("dumpCacheEntries> key=" + me.getKey() + ", val=" + me.getPayload()));
            }
            me = (LRUElementDescriptor)me.next;
        }
    }

    public void dumpMap() {
        log.debug((Object)"dumpingMap");
        Iterator itr = this.map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            LRUElementDescriptor me = (LRUElementDescriptor)e.getValue();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("dumpMap> key=" + e.getKey() + ", val=" + me.getPayload()));
        }
    }

    protected void verifyCache() {
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean found = false;
        log.debug((Object)("verifycache: mapContains " + this.map.size() + " elements, linked list contains " + this.dumpCacheSize() + " elements"));
        log.debug((Object)"verifycache: checking linked list by key ");
        LRUElementDescriptor li = (LRUElementDescriptor)this.list.getFirst();
        while (li != null) {
            Object key = li.getKey();
            if (!this.map.containsKey(key)) {
                log.error((Object)("verifycache: map does not contain key : " + li.getKey()));
                log.error((Object)("li.hashcode=" + li.getKey().hashCode()));
                log.error((Object)("key class=" + key.getClass()));
                log.error((Object)("key hashcode=" + key.hashCode()));
                log.error((Object)("key toString=" + key.toString()));
                if (key instanceof GroupAttrName) {
                    GroupAttrName name = (GroupAttrName)key;
                    log.error((Object)("GroupID hashcode=" + name.groupId.hashCode()));
                    log.error((Object)("GroupID.class=" + name.groupId.getClass()));
                    log.error((Object)("AttrName hashcode=" + name.attrName.hashCode()));
                    log.error((Object)("AttrName.class=" + name.attrName.getClass()));
                }
                this.dumpMap();
            } else if (this.map.get(li.getKey()) == null) {
                log.error((Object)("verifycache: linked list retrieval returned null for key: " + li.getKey()));
            }
            li = (LRUElementDescriptor)li.next;
        }
        log.debug((Object)"verifycache: checking linked list by value ");
        LRUElementDescriptor li3 = (LRUElementDescriptor)this.list.getFirst();
        while (li3 != null) {
            if (!this.map.containsValue(li3)) {
                log.error((Object)("verifycache: map does not contain value : " + li3));
                this.dumpMap();
            }
            li3 = (LRUElementDescriptor)li3.next;
        }
        log.debug((Object)"verifycache: checking via keysets!");
        Iterator itr2 = this.map.keySet().iterator();
        while (itr2.hasNext()) {
            found = false;
            Serializable val = null;
            try {
                val = (Serializable)itr2.next();
            }
            catch (NoSuchElementException nse) {
                log.error((Object)"verifycache: no such element exception");
            }
            LRUElementDescriptor li2 = (LRUElementDescriptor)this.list.getFirst();
            while (li2 != null) {
                if (val.equals(li2.getKey())) {
                    found = true;
                    break;
                }
                li2 = (LRUElementDescriptor)li2.next;
            }
            if (found) continue;
            log.error((Object)("verifycache: key not found in list : " + val));
            this.dumpCacheEntries();
            if (this.map.containsKey(val)) {
                log.error((Object)"verifycache: map contains key");
                continue;
            }
            log.error((Object)"verifycache: map does NOT contain key, what the HECK!");
        }
    }

    protected void verifyCache(Object key) {
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean found = false;
        LRUElementDescriptor li = (LRUElementDescriptor)this.list.getFirst();
        while (li != null) {
            if (li.getKey() == key) {
                found = true;
                log.debug((Object)("verifycache(key) key match: " + key));
                break;
            }
            li = (LRUElementDescriptor)li.next;
        }
        if (!found) {
            log.error((Object)("verifycache(key), couldn't find key! : " + key));
        }
    }

    protected void processRemovedLRU(Object key, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing key: [" + key + "] from LRUMap store, value = [" + value + "]"));
            log.debug((Object)("LRUMap store size: '" + this.size() + "'."));
        }
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("LRUMap");
        ArrayList<StatElement> elems = new ArrayList<StatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("List Size");
        se.setData("" + this.list.size());
        elems.add(se);
        se = new StatElement();
        se.setName("Map Size");
        se.setData("" + this.map.size());
        elems.add(se);
        se = new StatElement();
        se.setName("Put Count");
        se.setData("" + this.putCnt);
        elems.add(se);
        se = new StatElement();
        se.setName("Hit Count");
        se.setData("" + this.hitCnt);
        elems.add(se);
        se = new StatElement();
        se.setName("Miss Count");
        se.setData("" + this.missCnt);
        elems.add(se);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    public synchronized Set entrySet() {
        Set entries = this.map.entrySet();
        HashSet<LRUMapEntry> unWrapped = new HashSet<LRUMapEntry>();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry pre = it.next();
            LRUMapEntry post = new LRUMapEntry(pre.getKey(), ((LRUElementDescriptor)pre.getValue()).getPayload());
            unWrapped.add(post);
        }
        return unWrapped;
    }

    public Set keySet() {
        return this.map.keySet();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

