/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.license.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;

public class NetworkInformation {
    private static String convertMACAddress(byte[] byteMacAddress) {
        StringBuilder builder = new StringBuilder();
        if (byteMacAddress != null) {
            for (byte b : byteMacAddress) {
                builder.append(String.format("%02X", b)).append('-');
            }
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString().toUpperCase();
    }

    public static void main(String[] args) throws SocketException {
        StringBuilder builder = new StringBuilder();
        for (NetworkInterface ni : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            byte[] byteMacAddress;
            if (ni == null || !ni.isUp() || ni.isVirtual() || ni.isLoopback() || ni.isPointToPoint() || (byteMacAddress = ni.getHardwareAddress()) == null || byteMacAddress.length <= 0) continue;
            builder.append("Network Interface [" + ni.getDisplayName() + "]").append('\n');
            builder.append("    MAC Address : " + NetworkInformation.convertMACAddress(byteMacAddress)).append('\n');
            builder.append("     IP Address : ");
            for (InterfaceAddress interfaceAddress : ni.getInterfaceAddresses()) {
                InetAddress address = interfaceAddress.getAddress();
                if (!(address instanceof Inet4Address)) continue;
                builder.append(address.getHostAddress()).append(',');
            }
            builder.delete(builder.length() - 1, builder.length());
            builder.append('\n');
        }
        System.out.println(builder.toString());
    }
}

