/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.license.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.text.MaskFormatter;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualJarInputStream;

public class LicenseUtil {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final Platform PLATFORM;

    public static byte[] convertObjectToByteArray(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        byte[] keyBytes = baos.toByteArray();
        oos.close();
        baos.close();
        return keyBytes;
    }

    public static <T> T convertByteArrayToObject(byte[] objectBytes, Class<T> paramClass) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(objectBytes));
        Object object = ois.readObject();
        ois.close();
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTime(String date) throws ParseException {
        long time = 0L;
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            time = dateFormat.parse(date).getTime();
        }
        return time;
    }

    public static List<String> getMACAddress() {
        ArrayList<String> macAddressList = new ArrayList<String>();
        try {
            for (NetworkInterface ni : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                byte[] byteMacAddress;
                if (ni == null || !ni.isUp() || ni.isVirtual() || ni.isLoopback() || ni.isPointToPoint() || (byteMacAddress = ni.getHardwareAddress()) == null || byteMacAddress.length <= 0) continue;
                macAddressList.add(LicenseUtil.convertMACAddress(byteMacAddress));
            }
        }
        catch (SocketException ex) {
            throw new RuntimeException(ex);
        }
        return macAddressList;
    }

    public static List<String> getMACAddressFor15() throws Exception {
        ArrayList<String> macAddressList = new ArrayList<String>();
        if (PLATFORM == Platform.Unknown) {
            throw new Exception("Could not determine host platform, no Network Interfaces found.");
        }
        BufferedReader reader = null;
        try {
            Process conf = Runtime.getRuntime().exec(PLATFORM.command);
            reader = new BufferedReader(new InputStreamReader(conf.getInputStream()));
            String regex = "[a-f0-9]{2}([:-][a-f0-9]{2}){5,}";
            Pattern pattern = Pattern.compile(regex, 2);
            String line = reader.readLine();
            while (line != null) {
                Matcher matcher = pattern.matcher(line);
                while (matcher.find()) {
                    String address = matcher.group(0);
                    if ((address = address.trim().replaceAll("[:-]", "")).length() == 11) {
                        address = "0" + address;
                    }
                    if (address.length() != 12) continue;
                    MaskFormatter formatter = new MaskFormatter("HH-HH-HH-HH-HH-HH");
                    formatter.setValueContainsLiteralCharacters(false);
                    macAddressList.add(formatter.valueToString(address));
                }
                line = reader.readLine();
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return macAddressList;
    }

    public static List<String> getIPAddress() {
        ArrayList<String> ipAddressList = new ArrayList<String>();
        try {
            for (NetworkInterface ni : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (ni == null || !ni.isUp() || ni.isVirtual() || ni.isLoopback() || ni.isPointToPoint()) continue;
                for (InterfaceAddress interfaceAddress : ni.getInterfaceAddresses()) {
                    InetAddress address = interfaceAddress.getAddress();
                    if (!(address instanceof Inet4Address)) continue;
                    ipAddressList.add(address.getHostAddress());
                }
            }
        }
        catch (SocketException ex) {
            throw new RuntimeException(ex);
        }
        return ipAddressList;
    }

    private static String convertMACAddress(byte[] byteMacAddress) {
        StringBuilder builder = new StringBuilder();
        if (byteMacAddress != null) {
            for (byte mac : byteMacAddress) {
                builder.append(String.format("%02X", mac)).append('-');
            }
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString().toUpperCase();
    }

    public static List<InputStream> getResourceFromJar(Class<?> clazz, final String extension) throws IOException, URISyntaxException {
        ArrayList<InputStream> isList = new ArrayList<InputStream>();
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            URL jarUrl = codeSource.getLocation();
            if (jarUrl.toExternalForm().startsWith("vfs")) {
                ZipEntry entry;
                VirtualJarInputStream jarInputStream = new VirtualJarInputStream(VFS.getChild((URI)jarUrl.toURI()));
                while ((entry = jarInputStream.getNextEntry()) != null) {
                    String entryName = entry.getName();
                    if (!entryName.endsWith(extension)) continue;
                    isList.add(clazz.getResourceAsStream("/" + entryName));
                }
                jarInputStream.close();
            } else {
                int idx = jarUrl.getPath().indexOf(".jar");
                if (idx != -1) {
                    ZipEntry entry;
                    String jarUrlPath = jarUrl.getPath();
                    if (jarUrlPath.length() > idx + 4) {
                        jarUrl = new URL(jarUrlPath.substring(0, idx + 4));
                    }
                    ZipInputStream zipInputStream = new ZipInputStream(jarUrl.openStream());
                    while ((entry = zipInputStream.getNextEntry()) != null) {
                        String entryName = entry.getName();
                        if (!entryName.endsWith(extension)) continue;
                        isList.add(clazz.getResourceAsStream("/" + entryName));
                    }
                    zipInputStream.close();
                } else {
                    String[] fileNames;
                    for (String fileName : fileNames = new File(clazz.getResource("").getPath()).list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(extension);
                        }
                    })) {
                        isList.add(clazz.getResourceAsStream(fileName));
                    }
                }
            }
        }
        return isList;
    }

    static {
        String osName = System.getProperty("os.name").trim().toLowerCase();
        PLATFORM = osName.indexOf("windows") >= 0 ? Platform.Windows : (osName.indexOf("linux") >= 0 ? Platform.Linux : (osName.indexOf("mac os x") >= 0 || osName.indexOf("macosx") >= 0 ? Platform.MacOS : (osName.indexOf("solaris") >= 0 || osName.indexOf("sunos") >= 0 ? Platform.Solaris : (osName.indexOf("bsd") >= 0 ? Platform.Bsd : Platform.Unknown))));
    }

    private static enum Platform {
        Unknown(null),
        Windows("ipconfig /all"),
        Linux("/sbin/ifconfig"),
        MacOS("ifconfig"),
        Solaris("/usr/sbin/arp"),
        Bsd("ifconfig");

        private final String command;

        private Platform(String command) {
            this.command = command;
        }
    }
}

