/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.license.parser;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class JAXBHelper {
    private static Logger logger = Logger.getLogger(JAXBHelper.class.getName());
    private static ValidationEventHandler eventHandler = new ValidationEventHandler(){

        public boolean handleEvent(ValidationEvent event) {
            if (event.getSeverity() > 0) {
                ValidationEventLocator locator = event.getLocator();
                String errorMessage = event.getMessage() + " on Node[" + locator.getNode() + "], Line:Column[" + locator.getLineNumber() + ":" + locator.getColumnNumber() + "]";
                throw new RuntimeException(errorMessage, event.getLinkedException());
            }
            logger.log(Level.WARNING, event.getMessage());
            return true;
        }
    };

    public static Schema getSchema(URL schemaUrl) throws SAXException {
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
    }

    public static Schema getSchema(File schemaFile) throws SAXException {
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaFile);
    }

    public static <T> Marshaller getMarshaller(Class<T> classToBeBound, URL schemaUrl) throws SAXException, JAXBException {
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{classToBeBound}).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        if (schemaUrl != null) {
            marshaller.setSchema(JAXBHelper.getSchema(schemaUrl));
        }
        marshaller.setEventHandler(eventHandler);
        return marshaller;
    }

    public static <T> Marshaller getMarshaller(Class<T> classToBeBound, File schemaFile) throws SAXException, JAXBException, MalformedURLException {
        return JAXBHelper.getMarshaller(classToBeBound, schemaFile.toURI().toURL());
    }

    public static <T> Unmarshaller getUnmarshaller(Class<T> classToBeBound, URL schemaUrl) throws JAXBException, SAXException {
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{classToBeBound}).createUnmarshaller();
        if (schemaUrl != null) {
            unmarshaller.setSchema(JAXBHelper.getSchema(schemaUrl));
        }
        unmarshaller.setEventHandler(eventHandler);
        return unmarshaller;
    }

    public static <T> Unmarshaller getUnmarshaller(Class<T> classToBeBound, File schemaFile) throws JAXBException, SAXException, MalformedURLException {
        return JAXBHelper.getUnmarshaller(classToBeBound, schemaFile.toURI().toURL());
    }

    public static <T> void marshal(Class<T> classToBeBound, URL schemaUrl, Object jaxbElement, File outputXmlFile) throws SAXException, JAXBException {
        JAXBHelper.getMarshaller(classToBeBound, schemaUrl).marshal(jaxbElement, outputXmlFile);
    }

    public static <T> void marshal(Class<T> classToBeBound, File schemaFile, Object jaxbElement, File outputXmlFile) throws SAXException, JAXBException, MalformedURLException {
        JAXBHelper.marshal(classToBeBound, schemaFile.toURI().toURL(), jaxbElement, outputXmlFile);
    }

    public static <T> String marshal(Class<T> classToBeBound, URL schemaUrl, Object jaxbElement) throws SAXException, JAXBException {
        StringWriter writer = new StringWriter();
        JAXBHelper.getMarshaller(classToBeBound, schemaUrl).marshal(jaxbElement, (Writer)writer);
        return writer.toString();
    }

    public static <T> T unmarshal(Class<T> classToBeBound, URL schemaUrl, URL xmlUrl) throws JAXBException, SAXException {
        Object object = JAXBHelper.getUnmarshaller(classToBeBound, schemaUrl).unmarshal(xmlUrl);
        if (object != null && classToBeBound.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        return null;
    }

    public static <T> T unmarshal(Class<T> classToBeBound, File schemaFile, URL xmlUrl) throws JAXBException, SAXException, MalformedURLException {
        return JAXBHelper.unmarshal(classToBeBound, schemaFile.toURI().toURL(), xmlUrl);
    }

    public static <T> T unmarshal(Class<T> classToBeBound, URL schemaUrl, File xmlFile) throws JAXBException, SAXException, MalformedURLException {
        return JAXBHelper.unmarshal(classToBeBound, schemaUrl, xmlFile.toURI().toURL());
    }

    public static <T> T unmarshal(Class<T> classToBeBound, File schemaFile, File xmlFile) throws JAXBException, SAXException, MalformedURLException {
        return JAXBHelper.unmarshal(classToBeBound, schemaFile.toURI().toURL(), xmlFile.toURI().toURL());
    }

    public static <T> T unmarshal(Class<T> classToBeBound, URL schemaUrl, String xmlString) throws JAXBException, SAXException, MalformedURLException {
        Object object = JAXBHelper.getUnmarshaller(classToBeBound, schemaUrl).unmarshal((Reader)new StringReader(xmlString));
        if (object != null && classToBeBound.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        return null;
    }

    public static <T> T unmarshal(Class<T> classToBeBound, File schemaFile, String xmlString) throws JAXBException, SAXException, MalformedURLException {
        return JAXBHelper.unmarshal(classToBeBound, schemaFile.toURI().toURL(), xmlString);
    }
}

