/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.license;

import com.poscoict.license.ILicenseLogger;
import com.poscoict.license.License;
import com.poscoict.license.parser.LicenseInfo;
import com.poscoict.license.parser.LicenseParser;
import com.poscoict.license.util.LicenseAPICipher;
import java.io.File;
import java.security.PrivateKey;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LicenseAPI {
    private static LicenseAPI m_licenseAPI = new LicenseAPI();
    private static final ConcurrentMap<Solution, License> licenses = new ConcurrentHashMap<Solution, License>();
    private static final ConcurrentMap<String, LicenseInfo> infos = new ConcurrentHashMap<String, LicenseInfo>();

    public static String getSolutionName(String licenseXmlFilePath) throws Exception {
        return LicenseAPI.parseLicense(licenseXmlFilePath).getSolutionName();
    }

    public static void initialize(ILicenseLogger licenseLogger, String licenseXmlFilePath, Class<?> clazz) throws Exception {
        PrivateKey privateKey = LicenseAPICipher.readRSAPrivateKeyFromJar(clazz, ".private_key");
        LicenseAPI.initializeInternal(licenseLogger, licenseXmlFilePath, privateKey);
    }

    public static void initialize(ILicenseLogger licenseLogger, String licenseXmlFilePath, String privateKeyPath) throws Exception {
        PrivateKey privateKey = LicenseAPICipher.readRSAPrivateKeyFromFile(privateKeyPath);
        LicenseAPI.initializeInternal(licenseLogger, licenseXmlFilePath, privateKey);
    }

    private static void initializeInternal(ILicenseLogger licenseLogger, String licenseXmlFilePath, PrivateKey privateKey) throws Exception {
        LicenseInfo licenseInfo = LicenseAPI.parseLicense(licenseXmlFilePath);
        String licenseFileName = licenseInfo.getLicenseKey();
        if (!new File(licenseFileName).exists()) {
            licenseFileName = new File(licenseXmlFilePath).getParent() + File.separator + licenseFileName;
        }
        String encryptLicense = LicenseAPICipher.readLicenseFromFile(licenseFileName);
        licenseInfo = LicenseAPICipher.decryptLicense(privateKey, encryptLicense);
        StringBuilder sb = new StringBuilder("================ LICENSE INFORMATION ================").append("\n");
        sb.append("\t").append("Solution Name : ").append(licenseInfo.getSolutionName()).append("\n");
        sb.append("\t").append("Company Name  : ").append(licenseInfo.getCompanyName()).append("\n");
        sb.append("\t").append("Project Name  : ").append(licenseInfo.getProjectName()).append("\n");
        sb.append("\t").append("License Mode  : ").append(licenseInfo.getLicenseMode()).append("\n");
        licenseLogger.info(sb.toString());
        Solution solution = Solution.valueOf(licenseInfo.getSolutionName().replaceAll("\\s+", ""));
        licenses.putIfAbsent(solution, new License(licenseInfo, licenseLogger));
        licenseLogger.debug("[LICENSE] LicenseAPI initialize success for " + (Object)((Object)solution) + "!!");
    }

    public static LicenseAPI getInstance() {
        return m_licenseAPI;
    }

    public LicenseMode getLicenseMode(Solution solution) {
        return this.getLicense(solution).getLicenseMode();
    }

    public boolean checkLicense(Solution solution) {
        return this.getLicense(solution).checkLicense();
    }

    public void runtimeCheckLicense(Solution solution) throws Exception {
        this.checkLicense(solution);
    }

    private static LicenseInfo parseLicense(String licenseXmlFilePath) throws Exception {
        if (!infos.containsKey(licenseXmlFilePath)) {
            LicenseInfo licenseInfo = LicenseParser.getInstance().parseXml(licenseXmlFilePath);
            infos.put(licenseXmlFilePath, licenseInfo);
        }
        return (LicenseInfo)infos.get(licenseXmlFilePath);
    }

    private License getLicense(Solution solution) {
        if (licenses.containsKey((Object)solution)) {
            return (License)licenses.get((Object)solution);
        }
        throw new RuntimeException("Can not find the License for Solution[" + solution.toString() + "]. Initialize license file for solution.");
    }

    public static enum LicenseMode {
        EDUCATION,
        DEVELOPMENT,
        PRODUCT;

    }

    public static enum Solution {
        uCUBE,
        Glue,
        GlueMaster,
        PosBee;

    }
}

