/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.schema.parser;

import com.poscoict.glueframework.schema.parser.GlueServiceInfo;
import com.poscoict.glueframework.schema.service.ServiceDocumentXmlObj;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.xmlbeans.XmlOptions;

public class GlueServiceParser {
    private static GlueServiceParser a;
    private final Map<String, String> b = new HashMap<String, String>();

    private GlueServiceParser() {
        this.b.put("", "http://www.poscoict.com/glueframework/service");
    }

    public static GlueServiceParser getInstance() {
        if (a == null) {
            a = new GlueServiceParser();
        }
        return a;
    }

    public GlueServiceInfo parseXml(URL uRL) throws Exception {
        GlueServiceInfo glueServiceInfo;
        block7: {
            ArrayList arrayList = new ArrayList();
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setErrorListener(arrayList);
            xmlOptions.setLoadLineNumbers();
            xmlOptions.setLoadSubstituteNamespaces(this.b);
            ServiceDocumentXmlObj serviceDocumentXmlObj = ServiceDocumentXmlObj.Factory.parse(uRL, xmlOptions);
            if (serviceDocumentXmlObj != null && serviceDocumentXmlObj.validate(xmlOptions)) {
                ServiceDocumentXmlObj.Service service = serviceDocumentXmlObj.getService();
                glueServiceInfo = new GlueServiceInfo(service.getName(), service.getInitial());
                for (ServiceDocumentXmlObj.Service.Activity object : service.getActivityArray()) {
                    glueServiceInfo.addActivityInfo(object.getName(), object.getClass1());
                    for (ServiceDocumentXmlObj.Service.Activity.Transition transition : object.getTransitionArray()) {
                        glueServiceInfo.putActivityTransition(object.getName(), transition.getName(), transition.getValue());
                    }
                    for (ServiceDocumentXmlObj.Service.Activity.Property property : object.getPropertyArray()) {
                        glueServiceInfo.putActivityProperty(object.getName(), property.getName(), property.getValue());
                    }
                }
                for (ServiceDocumentXmlObj.Service.TransactionManager transactionManager : service.getTransactionManagerArray()) {
                    glueServiceInfo.putTransaction(transactionManager.getId(), transactionManager.getCommit());
                }
                break block7;
            }
            throw new Exception("Glue Service XML File[" + uRL.getPath() + "] Validation Fail!! ERROR = " + arrayList);
        }
        return glueServiceInfo;
    }

    public GlueServiceInfo parseXml(File file) throws Exception {
        return this.parseXml(file.toURI().toURL());
    }

    public void makeXml(File file, GlueServiceInfo glueServiceInfo) throws IOException {
        Object object;
        ServiceDocumentXmlObj serviceDocumentXmlObj = ServiceDocumentXmlObj.Factory.newInstance();
        ServiceDocumentXmlObj.Service service = serviceDocumentXmlObj.addNewService();
        service.setName(glueServiceInfo.getName());
        service.setInitial(glueServiceInfo.getInitial());
        for (Map.Entry<String, GlueServiceInfo.GlueActivityInfo> entry : glueServiceInfo.getActivityInfoMap().entrySet()) {
            Object object2;
            object = service.addNewActivity();
            GlueServiceInfo.GlueActivityInfo glueActivityInfo = entry.getValue();
            object.setName(glueActivityInfo.getName());
            object.setClass1(glueActivityInfo.getClazz());
            for (Map.Entry<String, String> entry2 : glueActivityInfo.getTransitionMap().entrySet()) {
                object2 = object.addNewTransition();
                object2.setName(entry2.getKey());
                object2.setValue(entry2.getValue());
            }
            for (Map.Entry<String, String> entry2 : glueActivityInfo.getPropertyMap().entrySet()) {
                if (entry2.getKey().equals("class")) continue;
                object2 = object.addNewProperty();
                object2.setName(entry2.getKey());
                object2.setValue(entry2.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : glueServiceInfo.getTransactionMap().entrySet()) {
            object = service.addNewTransactionManager();
            object.setId(entry.getKey());
            object.setCommit((Boolean)entry.getValue());
        }
        if (serviceDocumentXmlObj.validate()) {
            Iterator<Map.Entry<String, Object>> iterator = new XmlOptions();
            iterator.setSavePrettyPrint();
            iterator.setSavePrettyPrintIndent(4);
            iterator.setUseDefaultNamespace();
            serviceDocumentXmlObj.save(file, (XmlOptions)iterator);
        }
    }
}

