/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Update {
    private Set<String> keysToUpdate = new HashSet<String>();
    private Map<String, Object> modifierOps = new LinkedHashMap<String, Object>();
    private Map<String, PushOperatorBuilder> pushCommandBuilders = new LinkedHashMap<String, PushOperatorBuilder>(1);

    public static Update update(String key, Object value) {
        return new Update().set(key, value);
    }

    public static Update fromDBObject(DBObject object, String ... exclude) {
        Update update = new Update();
        List<String> excludeList = Arrays.asList(exclude);
        for (String key : object.keySet()) {
            if (excludeList.contains(key)) continue;
            Object value = object.get(key);
            update.modifierOps.put(key, value);
            if (Update.isKeyword(key) && value instanceof DBObject) {
                update.keysToUpdate.addAll(((DBObject)value).keySet());
                continue;
            }
            update.keysToUpdate.add(key);
        }
        return update;
    }

    public Update set(String key, Object value) {
        this.addMultiFieldOperation("$set", key, value);
        return this;
    }

    public Update setOnInsert(String key, Object value) {
        this.addMultiFieldOperation("$setOnInsert", key, value);
        return this;
    }

    public Update unset(String key) {
        this.addMultiFieldOperation("$unset", key, 1);
        return this;
    }

    public Update inc(String key, Number inc) {
        this.addMultiFieldOperation("$inc", key, inc);
        return this;
    }

    public Update push(String key, Object value) {
        this.addMultiFieldOperation("$push", key, value);
        return this;
    }

    public PushOperatorBuilder push(String key) {
        if (!this.pushCommandBuilders.containsKey(key)) {
            this.pushCommandBuilders.put(key, new PushOperatorBuilder(key));
        }
        return this.pushCommandBuilders.get(key);
    }

    public Update pushAll(String key, Object[] values) {
        Object[] convertedValues = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            convertedValues[i] = values[i];
        }
        this.addMultiFieldOperation("$pushAll", key, convertedValues);
        return this;
    }

    public Update addToSet(String key, Object value) {
        this.addMultiFieldOperation("$addToSet", key, value);
        return this;
    }

    public Update pop(String key, Position pos) {
        this.addMultiFieldOperation("$pop", key, pos == Position.FIRST ? -1 : 1);
        return this;
    }

    public Update pull(String key, Object value) {
        this.addMultiFieldOperation("$pull", key, value);
        return this;
    }

    public Update pullAll(String key, Object[] values) {
        Object[] convertedValues = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            convertedValues[i] = values[i];
        }
        this.addFieldOperation("$pullAll", key, convertedValues);
        return this;
    }

    public Update rename(String oldName, String newName) {
        this.addMultiFieldOperation("$rename", oldName, newName);
        return this;
    }

    public DBObject getUpdateObject() {
        BasicDBObject dbo = new BasicDBObject();
        for (String k : this.modifierOps.keySet()) {
            dbo.put(k, this.modifierOps.get(k));
        }
        return dbo;
    }

    protected void addFieldOperation(String operator, String key, Object value) {
        Assert.hasText((String)key, (String)"Key/Path for update must not be null or blank.");
        this.modifierOps.put(operator, new BasicDBObject(key, value));
        this.keysToUpdate.add(key);
    }

    protected void addMultiFieldOperation(String operator, String key, Object value) {
        BasicDBObject keyValueMap;
        Assert.hasText((String)key, (String)"Key/Path for update must not be null or blank.");
        Object existingValue = this.modifierOps.get(operator);
        if (existingValue == null) {
            keyValueMap = new BasicDBObject();
            this.modifierOps.put(operator, keyValueMap);
        } else if (existingValue instanceof BasicDBObject) {
            keyValueMap = (BasicDBObject)existingValue;
        } else {
            throw new InvalidDataAccessApiUsageException("Modifier Operations should be a LinkedHashMap but was " + existingValue.getClass());
        }
        keyValueMap.put(key, value);
        this.keysToUpdate.add(key);
    }

    public boolean modifies(String key) {
        return this.keysToUpdate.contains(key);
    }

    private static boolean isKeyword(String key) {
        return StringUtils.startsWithIgnoreCase((String)key, (String)"$");
    }

    public class PushOperatorBuilder {
        private final String key;
        private final Modifiers modifiers;

        PushOperatorBuilder(String key) {
            this.key = key;
            this.modifiers = new Modifiers();
        }

        public Update each(Object ... values) {
            this.modifiers.addModifier(new Each(values));
            return Update.this.push(this.key, this.modifiers);
        }

        public Update value(Object value) {
            return Update.this.push(this.key, value);
        }
    }

    private static class Each
    implements Modifier {
        private Object[] values;

        public Each(Object ... values) {
            this.values = this.extractValues(values);
        }

        private Object[] extractValues(Object[] values) {
            if (values == null || values.length == 0) {
                return values;
            }
            if (values.length == 1 && values[0] instanceof Collection) {
                return ((Collection)values[0]).toArray();
            }
            Object[] convertedValues = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                convertedValues[i] = values[i];
            }
            return convertedValues;
        }

        @Override
        public String getKey() {
            return "$each";
        }

        @Override
        public Object getValue() {
            return this.values;
        }
    }

    public static interface Modifier {
        public String getKey();

        public Object getValue();
    }

    public static class Modifiers {
        private HashMap<String, Modifier> modifiers = new LinkedHashMap<String, Modifier>(1);

        public Collection<Modifier> getModifiers() {
            return Collections.unmodifiableCollection(this.modifiers.values());
        }

        public void addModifier(Modifier modifier) {
            this.modifiers.put(modifier.getKey(), modifier);
        }
    }

    public static enum Position {
        LAST,
        FIRST;

    }
}

