/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoURI;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoDbUtils;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SimpleMongoDbFactory
implements DisposableBean,
MongoDbFactory {
    private final Mongo mongo;
    private final String databaseName;
    private final boolean mongoInstanceCreated;
    private final UserCredentials credentials;
    private final PersistenceExceptionTranslator exceptionTranslator;
    private final String authenticationDatabaseName;
    private WriteConcern writeConcern;

    public SimpleMongoDbFactory(Mongo mongo, String databaseName) {
        this(mongo, databaseName, null);
    }

    public SimpleMongoDbFactory(Mongo mongo, String databaseName, UserCredentials credentials) {
        this(mongo, databaseName, credentials, false, null);
    }

    public SimpleMongoDbFactory(Mongo mongo, String databaseName, UserCredentials credentials, String authenticationDatabaseName) {
        this(mongo, databaseName, credentials, false, authenticationDatabaseName);
    }

    public SimpleMongoDbFactory(MongoURI uri) throws MongoException, UnknownHostException {
        this(new Mongo(uri), uri.getDatabase(), new UserCredentials(uri.getUsername(), SimpleMongoDbFactory.parseChars(uri.getPassword())), true, uri.getDatabase());
    }

    private SimpleMongoDbFactory(Mongo mongo, String databaseName, UserCredentials credentials, boolean mongoInstanceCreated, String authenticationDatabaseName) {
        Assert.notNull((Object)mongo, (String)"Mongo must not be null");
        Assert.hasText((String)databaseName, (String)"Database name must not be empty");
        Assert.isTrue((boolean)databaseName.matches("[\\w-]+"), (String)"Database name must only contain letters, numbers, underscores and dashes!");
        this.mongo = mongo;
        this.databaseName = databaseName;
        this.mongoInstanceCreated = mongoInstanceCreated;
        this.credentials = credentials == null ? UserCredentials.NO_CREDENTIALS : credentials;
        this.exceptionTranslator = new MongoExceptionTranslator();
        this.authenticationDatabaseName = StringUtils.hasText((String)authenticationDatabaseName) ? authenticationDatabaseName : databaseName;
        Assert.isTrue((boolean)this.authenticationDatabaseName.matches("[\\w-]+"), (String)"Authentication database name must only contain letters, numbers, underscores and dashes!");
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    @Override
    public DB getDb() throws DataAccessException {
        return this.getDb(this.databaseName);
    }

    @Override
    public DB getDb(String dbName) throws DataAccessException {
        Assert.hasText((String)dbName, (String)"Database name must not be empty.");
        DB db = MongoDbUtils.getDB(this.mongo, dbName, this.credentials, this.authenticationDatabaseName);
        if (this.writeConcern != null) {
            db.setWriteConcern(this.writeConcern);
        }
        return db;
    }

    public void destroy() throws Exception {
        if (this.mongoInstanceCreated) {
            this.mongo.close();
        }
    }

    private static String parseChars(char[] chars) {
        return chars == null ? null : String.valueOf(chars);
    }

    @Override
    public PersistenceExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }
}

