/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexField;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.util.Assert;

public class DefaultIndexOperations
implements IndexOperations {
    private static final Double ONE = 1.0;
    private static final Double MINUS_ONE = -1.0;
    private final MongoOperations mongoOperations;
    private final String collectionName;

    public DefaultIndexOperations(MongoOperations mongoOperations, String collectionName) {
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null!");
        Assert.notNull((Object)collectionName, (String)"Collection name can not be null!");
        this.mongoOperations = mongoOperations;
        this.collectionName = collectionName;
    }

    @Override
    public void ensureIndex(final IndexDefinition indexDefinition) {
        this.mongoOperations.execute(this.collectionName, new CollectionCallback<Object>(){

            @Override
            public Object doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                DBObject indexOptions = indexDefinition.getIndexOptions();
                if (indexOptions != null) {
                    collection.ensureIndex(indexDefinition.getIndexKeys(), indexOptions);
                } else {
                    collection.ensureIndex(indexDefinition.getIndexKeys());
                }
                return null;
            }
        });
    }

    @Override
    public void dropIndex(final String name) {
        this.mongoOperations.execute(this.collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                collection.dropIndex(name);
                return null;
            }
        });
    }

    @Override
    public void dropAllIndexes() {
        this.dropIndex("*");
    }

    @Override
    public void resetIndexCache() {
        this.mongoOperations.execute(this.collectionName, new CollectionCallback<Void>(){

            @Override
            public Void doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                collection.resetIndexCache();
                return null;
            }
        });
    }

    @Override
    public List<IndexInfo> getIndexInfo() {
        return this.mongoOperations.execute(this.collectionName, new CollectionCallback<List<IndexInfo>>(){

            @Override
            public List<IndexInfo> doInCollection(DBCollection collection) throws MongoException, DataAccessException {
                List dbObjectList = collection.getIndexInfo();
                return this.getIndexData(dbObjectList);
            }

            private List<IndexInfo> getIndexData(List<DBObject> dbObjectList) {
                ArrayList<IndexInfo> indexInfoList = new ArrayList<IndexInfo>();
                for (DBObject ix : dbObjectList) {
                    DBObject keyDbObject = (DBObject)ix.get("key");
                    int numberOfElements = keyDbObject.keySet().size();
                    ArrayList<IndexField> indexFields = new ArrayList<IndexField>(numberOfElements);
                    for (String key : keyDbObject.keySet()) {
                        Object value = keyDbObject.get(key);
                        if ("2d".equals(value)) {
                            indexFields.add(IndexField.geo(key));
                            continue;
                        }
                        Double keyValue = new Double(value.toString());
                        if (ONE.equals(keyValue)) {
                            indexFields.add(IndexField.create(key, Sort.Direction.ASC));
                            continue;
                        }
                        if (!MINUS_ONE.equals(keyValue)) continue;
                        indexFields.add(IndexField.create(key, Sort.Direction.DESC));
                    }
                    String name = ix.get("name").toString();
                    boolean unique = ix.containsField("unique") ? (Boolean)ix.get("unique") : false;
                    boolean dropDuplicates = ix.containsField("dropDups") ? (Boolean)ix.get("dropDups") : false;
                    boolean sparse = ix.containsField("sparse") ? (Boolean)ix.get("sparse") : false;
                    indexInfoList.add(new IndexInfo(indexFields, name, unique, dropDuplicates, sparse));
                }
                return indexInfoList;
            }
        });
    }
}

