/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.config.BeanComponentDefinitionBuilder;
import org.springframework.data.mapping.context.MappingContextIsNewStrategyFactory;
import org.springframework.data.mongodb.core.convert.CustomConversions;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexCreator;
import org.springframework.data.mongodb.core.mapping.CamelCaseAbbreviatingFieldNamingStrategy;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.event.ValidatingMongoEventListener;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class MappingMongoConverterParser
implements BeanDefinitionParser {
    private static final String BASE_PACKAGE = "base-package";
    private static final boolean JSR_303_PRESENT = ClassUtils.isPresent((String)"javax.validation.Validator", (ClassLoader)MappingMongoConverterParser.class.getClassLoader());

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        if (parserContext.isNested()) {
            parserContext.getReaderContext().error("Mongo Converter must not be defined as nested bean.", (Object)element);
        }
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        String id = element.getAttribute("id");
        id = StringUtils.hasText((String)id) ? id : "mappingConverter";
        parserContext.pushContainingComponent(new CompositeComponentDefinition("Mapping Mongo Converter", (Object)element));
        BeanDefinition conversionsDefinition = this.getCustomConversions(element, parserContext);
        String ctxRef = MappingMongoConverterParser.potentiallyCreateMappingContext(element, parserContext, conversionsDefinition, id);
        MappingMongoConverterParser.createIsNewStrategyFactoryBeanDefinition(ctxRef, parserContext, element);
        String dbFactoryRef = element.getAttribute("db-factory-ref");
        if (!StringUtils.hasText((String)dbFactoryRef)) {
            dbFactoryRef = "mongoDbFactory";
        }
        BeanDefinitionBuilder converterBuilder = BeanDefinitionBuilder.genericBeanDefinition(MappingMongoConverter.class);
        converterBuilder.addConstructorArgReference(dbFactoryRef);
        converterBuilder.addConstructorArgReference(ctxRef);
        String typeMapperRef = element.getAttribute("type-mapper-ref");
        if (StringUtils.hasText((String)typeMapperRef)) {
            converterBuilder.addPropertyReference("typeMapper", typeMapperRef);
        }
        if (conversionsDefinition != null) {
            converterBuilder.addPropertyValue("customConversions", (Object)conversionsDefinition);
        }
        try {
            registry.getBeanDefinition("indexCreationHelper");
        }
        catch (NoSuchBeanDefinitionException ignored) {
            if (!StringUtils.hasText((String)dbFactoryRef)) {
                dbFactoryRef = "mongoDbFactory";
            }
            BeanDefinitionBuilder indexHelperBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoPersistentEntityIndexCreator.class);
            indexHelperBuilder.addConstructorArgReference(ctxRef);
            indexHelperBuilder.addConstructorArgReference(dbFactoryRef);
            indexHelperBuilder.addDependsOn(ctxRef);
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)indexHelperBuilder.getBeanDefinition(), "indexCreationHelper"));
        }
        BeanDefinition validatingMongoEventListener = this.potentiallyCreateValidatingMongoEventListener(element, parserContext);
        if (validatingMongoEventListener != null) {
            parserContext.registerBeanComponent(new BeanComponentDefinition(validatingMongoEventListener, "validatingMongoEventListener"));
        }
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)converterBuilder.getBeanDefinition(), id));
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private BeanDefinition potentiallyCreateValidatingMongoEventListener(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder;
        RuntimeBeanReference validator;
        boolean validationDisabled;
        String disableValidation = element.getAttribute("disable-validation");
        boolean bl = validationDisabled = StringUtils.hasText((String)disableValidation) && Boolean.valueOf(disableValidation) != false;
        if (!validationDisabled && (validator = this.getValidator(builder = BeanDefinitionBuilder.genericBeanDefinition(), parserContext)) != null) {
            builder.getRawBeanDefinition().setBeanClass(ValidatingMongoEventListener.class);
            builder.addConstructorArgValue((Object)validator);
            return builder.getBeanDefinition();
        }
        return null;
    }

    private RuntimeBeanReference getValidator(Object source, ParserContext parserContext) {
        if (!JSR_303_PRESENT) {
            return null;
        }
        RootBeanDefinition validatorDef = new RootBeanDefinition("org.springframework.validation.beanvalidation.LocalValidatorFactoryBean");
        validatorDef.setSource(source);
        validatorDef.setRole(2);
        String validatorName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)validatorDef);
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)validatorDef, validatorName));
        return new RuntimeBeanReference(validatorName);
    }

    static String potentiallyCreateMappingContext(Element element, ParserContext parserContext, BeanDefinition conversionsDefinition, String converterId) {
        String abbreviateFieldNames;
        String ctxRef = element.getAttribute("mapping-context-ref");
        if (StringUtils.hasText((String)ctxRef)) {
            return ctxRef;
        }
        BeanComponentDefinitionBuilder componentDefinitionBuilder = new BeanComponentDefinitionBuilder(element, parserContext);
        BeanDefinitionBuilder mappingContextBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoMappingContext.class);
        Set<String> classesToAdd = MappingMongoConverterParser.getInititalEntityClasses(element);
        if (classesToAdd != null) {
            mappingContextBuilder.addPropertyValue("initialEntitySet", classesToAdd);
        }
        if (conversionsDefinition != null) {
            GenericBeanDefinition simpleTypesDefinition = new GenericBeanDefinition();
            simpleTypesDefinition.setFactoryBeanName("customConversions");
            simpleTypesDefinition.setFactoryMethodName("getSimpleTypeHolder");
            mappingContextBuilder.addPropertyValue("simpleTypeHolder", (Object)simpleTypesDefinition);
        }
        if ("true".equals(abbreviateFieldNames = element.getAttribute("abbreviate-field-names"))) {
            mappingContextBuilder.addPropertyValue("fieldNamingStrategy", (Object)new RootBeanDefinition(CamelCaseAbbreviatingFieldNamingStrategy.class));
        }
        ctxRef = converterId + "." + "mappingContext";
        parserContext.registerBeanComponent(componentDefinitionBuilder.getComponent(mappingContextBuilder, ctxRef));
        return ctxRef;
    }

    private BeanDefinition getCustomConversions(Element element, ParserContext parserContext) {
        List customConvertersElements = DomUtils.getChildElementsByTagName((Element)element, (String)"custom-converters");
        if (customConvertersElements.size() == 1) {
            String packageToScan;
            Element customerConvertersElement = (Element)customConvertersElements.get(0);
            ManagedList converterBeans = new ManagedList();
            List converterElements = DomUtils.getChildElementsByTagName((Element)customerConvertersElement, (String)"converter");
            if (converterElements != null) {
                for (Element listenerElement : converterElements) {
                    converterBeans.add((Object)this.parseConverter(listenerElement, parserContext));
                }
            }
            if (StringUtils.hasText((String)(packageToScan = customerConvertersElement.getAttribute(BASE_PACKAGE)))) {
                ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(true);
                provider.addExcludeFilter((TypeFilter)new NegatingFilter(new TypeFilter[]{new AssignableTypeFilter(Converter.class), new AssignableTypeFilter(GenericConverter.class)}));
                for (BeanDefinition candidate : provider.findCandidateComponents(packageToScan)) {
                    converterBeans.add((Object)candidate);
                }
            }
            BeanDefinitionBuilder conversionsBuilder = BeanDefinitionBuilder.rootBeanDefinition(CustomConversions.class);
            conversionsBuilder.addConstructorArgValue((Object)converterBeans);
            AbstractBeanDefinition conversionsBean = conversionsBuilder.getBeanDefinition();
            conversionsBean.setSource(parserContext.extractSource((Object)element));
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)conversionsBean, "customConversions"));
            return conversionsBean;
        }
        return null;
    }

    private static Set<String> getInititalEntityClasses(Element element) {
        String basePackage = element.getAttribute(BASE_PACKAGE);
        if (!StringUtils.hasText((String)basePackage)) {
            return null;
        }
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Document.class));
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Persistent.class));
        ManagedSet classes = new ManagedSet();
        for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
            classes.add(candidate.getBeanClassName());
        }
        return classes;
    }

    public BeanMetadataElement parseConverter(Element element, ParserContext parserContext) {
        String converterRef = element.getAttribute("ref");
        if (StringUtils.hasText((String)converterRef)) {
            return new RuntimeBeanReference(converterRef);
        }
        Element beanElement = DomUtils.getChildElementByTagName((Element)element, (String)"bean");
        if (beanElement != null) {
            BeanDefinitionHolder beanDef = parserContext.getDelegate().parseBeanDefinitionElement(beanElement);
            beanDef = parserContext.getDelegate().decorateBeanDefinitionIfRequired(beanElement, beanDef);
            return beanDef;
        }
        parserContext.getReaderContext().error("Element <converter> must specify 'ref' or contain a bean definition for the converter", (Object)element);
        return null;
    }

    public static String createIsNewStrategyFactoryBeanDefinition(String mappingContextRef, ParserContext context, Element element) {
        BeanDefinitionBuilder mappingContextStrategyFactoryBuilder = BeanDefinitionBuilder.rootBeanDefinition(MappingContextIsNewStrategyFactory.class);
        mappingContextStrategyFactoryBuilder.addConstructorArgReference(mappingContextRef);
        BeanComponentDefinitionBuilder builder = new BeanComponentDefinitionBuilder(element, context);
        context.registerBeanComponent(builder.getComponent(mappingContextStrategyFactoryBuilder, "isNewStrategyFactory"));
        return "isNewStrategyFactory";
    }

    private static class NegatingFilter
    implements TypeFilter {
        private final Set<TypeFilter> delegates;

        public NegatingFilter(TypeFilter ... filters) {
            Assert.notNull((Object)filters);
            this.delegates = new HashSet<TypeFilter>(Arrays.asList(filters));
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            for (TypeFilter delegate : this.delegates) {
                if (!delegate.match(metadataReader, metadataReaderFactory)) continue;
                return false;
            }
            return true;
        }
    }
}

