/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.web.control.spring;

import com.poscoict.glueframework.context.GlueContext;
import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.context.GlueWebContext;
import com.poscoict.glueframework.dao.vo.GlueAuditAttributes;
import com.poscoict.glueframework.web.control.GlueMultipartRequest;
import com.poscoict.glueframework.web.control.spring.GlueAbstractController;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class GlueXMLViewController
extends GlueAbstractController {
    @Override
    public void preDoAction(GlueWebContext glueWebContext) {
        GlueMultipartRequest glueMultipartRequest;
        if (GlueStaticContext.isAudit()) {
            glueWebContext.setAuditAttributes(new GlueAuditAttributes(glueWebContext));
        }
        if ((glueMultipartRequest = glueWebContext.getMultiPartRequest()) != null) {
            try {
                Iterator<String> iterator = glueMultipartRequest.getFileNames();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    this.a.debug("loaded file-name : {}", (Object)string);
                    if (!string.endsWith(".xls") && !string.endsWith(".xlsx")) continue;
                    this.a(glueWebContext, glueMultipartRequest.getInputStream(string));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void afterDoAction(GlueWebContext glueWebContext) {
    }

    private void a(GlueContext glueContext, InputStream inputStream) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                Sheet sheet = workbook.getSheetAt(i);
                String string = workbook.getSheetName(i);
                this.a.debug("Excel Sheet [{}] is reading ", (Object)string);
                List<Map<String, Object>> list = this.a(sheet);
                glueContext.put(string, list);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private List<Map<String, Object>> a(Sheet sheet) {
        int n = sheet.getFirstRowNum();
        int n2 = sheet.getLastRowNum();
        Row row = sheet.getRow(n);
        String[] stringArray = this.a(row);
        short s = row.getFirstCellNum();
        short s2 = row.getLastCellNum();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(",");
        }
        this.a.debug("firstRowIndex : {} lastRowIndex : {}", (Object)n, (Object)n2);
        this.a.debug("firstColumnIndex : {} lastColumnIndex : {}", (Object)s, (Object)s2);
        this.a.debug("Column Ids : {}", (Object)stringBuffer.toString());
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>(n2 - n);
        for (int i = n + 1; i <= n2; ++i) {
            Row row2 = sheet.getRow(i);
            Map<String, Object> map = this.a(row2, stringArray, s, s2);
            arrayList.add(map);
        }
        return arrayList;
    }

    private Map<String, Object> a(Row row, String[] stringArray, int n, int n2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Cell cell = null;
        int n3 = n;
        int n4 = 0;
        while (n3 <= n2) {
            cell = row.getCell(n3);
            if (cell != null) {
                int n5 = cell.getCellType();
                if (n5 == 1) {
                    hashMap.put(stringArray[n4], cell.getStringCellValue());
                } else if (n5 == 0) {
                    hashMap.put(stringArray[n4], new BigDecimal(cell.getNumericCellValue()));
                } else {
                    this.a.warn("Cell type is not supported! - {}", (Object)n5);
                }
            }
            ++n3;
            ++n4;
        }
        return hashMap;
    }

    private String[] a(Row row) {
        int n = row.getFirstCellNum();
        short s = row.getLastCellNum();
        String[] stringArray = new String[s - n];
        Cell cell = null;
        for (int i = n; i <= s; ++i) {
            cell = row.getCell(i);
            if (cell == null) continue;
            Comment comment = cell.getCellComment();
            stringArray[i] = comment != null ? comment.getString().getString() : cell.getStringCellValue();
        }
        return stringArray;
    }

    @Override
    public ModelAndView setModelAndView(GlueWebContext glueWebContext) {
        if (glueWebContext.get("viewname") == null) {
            Object object;
            String string = null;
            if (glueWebContext.get("forwardname") != null) {
                object = glueWebContext.get("forwardname");
                if (object instanceof String) {
                    string = (String)object;
                } else if (object instanceof String[]) {
                    string = ((String[])object)[0];
                }
            }
            if (string == null && super.getViewPage() != null) {
                string = super.getViewPage();
            }
            if (string == null) {
                object = (String)glueWebContext.get("RequestURI");
                String string2 = (String)glueWebContext.get("ContextPath");
                if (!((String)(object = ((String)object).replaceFirst(string2, ""))).trim().equals("")) {
                    string = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                }
            }
            return new ModelAndView(string);
        }
        Object object = glueWebContext.get("viewname");
        return new ModelAndView(((String[])object)[0], (Map)glueWebContext);
    }
}

