/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.web.control.restful;

import com.poscoict.glueframework.biz.control.GlueBizController;
import com.poscoict.glueframework.biz.control.GlueBizProvider;
import com.poscoict.glueframework.context.GlueDefaultContext;
import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.dao.vo.GlueAuditAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class RestfulController {
    private final Logger a = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/glue/{serviceName}"}, method={RequestMethod.GET})
    public ModelAndView doGlueServiceGet(@PathVariable String string) {
        ModelAndView modelAndView = new ModelAndView("jsonView");
        Map<String, Object> map = this.a(string, "get", null, null);
        modelAndView.addAllObjects(map);
        return modelAndView;
    }

    @RequestMapping(value={"/glue/{serviceName}/data/{gluedata}"}, method={RequestMethod.GET})
    public ModelAndView doGlueServiceGetByData(@PathVariable String string, @PathVariable String string2) {
        ModelAndView modelAndView = new ModelAndView("jsonView");
        Map<String, Object> map = this.a(string, "get", string2, null);
        modelAndView.addAllObjects(map);
        return modelAndView;
    }

    @RequestMapping(value={"/glue/{serviceName}"}, method={RequestMethod.DELETE})
    public ModelAndView doGlueServiceDelete(@PathVariable String string) {
        ModelAndView modelAndView = new ModelAndView("jsonView");
        Map<String, Object> map = this.a(string, "delete", null, null);
        modelAndView.addAllObjects(map);
        return modelAndView;
    }

    @RequestMapping(value={"/glue/{serviceName}/data/{gluedata}"}, method={RequestMethod.DELETE})
    public ModelAndView doGlueServiceDeletetByData(@PathVariable String string, @PathVariable String string2) {
        ModelAndView modelAndView = new ModelAndView("jsonView");
        Map<String, Object> map = this.a(string, "delete", string2, null);
        modelAndView.addAllObjects(map);
        return modelAndView;
    }

    @RequestMapping(value={"/glue/{serviceName}"}, method={RequestMethod.POST})
    public ModelAndView doGlueServicePost(@PathVariable String string, @RequestParam Map<String, Object> map) {
        ModelAndView modelAndView = new ModelAndView("jsonView");
        Map<String, Object> map2 = this.a(string, "post", null, map);
        modelAndView.addAllObjects(map2);
        return modelAndView;
    }

    @RequestMapping(value={"/glue/{serviceName}/data/{gluedata}"}, method={RequestMethod.POST})
    public ModelAndView doGlueServicePostByData(@PathVariable String string, @PathVariable String string2, @RequestParam Map<String, Object> map) {
        ModelAndView modelAndView = new ModelAndView("jsonView");
        Map<String, Object> map2 = this.a(string, "post", string2, map);
        modelAndView.addAllObjects(map2);
        return modelAndView;
    }

    @RequestMapping(value={"/glue/{serviceName}"}, method={RequestMethod.PUT})
    public ModelAndView doGlueServicePut(@PathVariable String string, @RequestBody MultiValueMap<String, String> multiValueMap) {
        ModelAndView modelAndView = new ModelAndView("jsonView");
        Map<String, Object> map = this.a(string, "put", null, (Map<String, ?>)multiValueMap);
        modelAndView.addAllObjects(map);
        return modelAndView;
    }

    @RequestMapping(value={"/glue/{serviceName}/data/{gluedata}"}, method={RequestMethod.PUT})
    public ModelAndView doGlueServicePutByData(@PathVariable String string, @PathVariable String string2, @RequestBody MultiValueMap<String, String> multiValueMap) {
        ModelAndView modelAndView = new ModelAndView("jsonView");
        Map<String, Object> map = this.a(string, "put", string2, (Map<String, ?>)multiValueMap);
        modelAndView.addAllObjects(map);
        return modelAndView;
    }

    private Map<String, Object> a(String string, String string2, String string3, Map<String, ?> map) {
        this.a.debug("Glue ServiceName : {}", (Object)string);
        this.a.debug("RESTful Action : {}", (Object)string2);
        this.a.debug("RESTful Data : {}", (Object)string3);
        this.a.debug("RequestBody : {}", map);
        GlueDefaultContext glueDefaultContext = new GlueDefaultContext();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List list = null;
        if (map != null) {
            glueDefaultContext.putAll((Map<? extends String, ? extends Object>)map);
        }
        glueDefaultContext.put("ServiceName", string);
        glueDefaultContext.put("action", string2);
        glueDefaultContext.put(string2, string2);
        glueDefaultContext.put("restfulData", string3);
        if (GlueStaticContext.isAudit()) {
            glueDefaultContext.setAuditAttributes(new GlueAuditAttributes(glueDefaultContext));
        }
        try {
            MDC.put((String)"ServiceName", (String)string);
            GlueBizController glueBizController = GlueBizProvider.getController();
            glueBizController.doAction(glueDefaultContext);
            MDC.remove((String)"ServiceName");
            list = (List)glueDefaultContext.get("result-keys");
        }
        catch (Exception exception) {
            hashMap.put("ERROR", exception);
            this.a.error(exception.getMessage(), (Throwable)exception);
        }
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                hashMap.put((String)list.get(i), glueDefaultContext.get(list.get(i)));
            }
        }
        return hashMap;
    }
}

