/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.web;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.biz.control.GlueBizProvider;
import com.poscoict.glueframework.context.GlueContext;
import com.poscoict.glueframework.context.GlueDefaultContext;
import com.poscoict.glueframework.context.GlueStaticContext;
import com.poscoict.glueframework.dao.vo.GlueAuditAttributes;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class GlueHttpReceiverAdapter
extends HttpServlet {
    private static final long serialVersionUID = -8422810561307799723L;
    public static final int UD_SC_OK = 900;
    public static final int UD_SC_RESEND = 600;
    public static final int UD_SC_FAILURE = 700;
    public static final int DEFAULT_MSG_ID_LENGTH = 8;
    private final Logger a = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected Hashtable<String, String> requestMap = new Hashtable();
    protected int userDefinedStatusCodeSuccess = 900;
    protected int userDefinedStatusCodeSuccessResend = 600;
    protected int userDefinedStatusCodeSuccessfailure = 700;
    protected int transactionCodeIdLength = 8;
    private String b = "ifd";
    private String c = "timestamp";
    private String d = "sequence";
    private String e = "message";
    private String f = "type";
    private static final boolean g = Boolean.getBoolean("debug.httpreceiver");

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            Enumeration enumeration = servletConfig.getInitParameterNames();
            String string = null;
            String string2 = null;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                string2 = servletConfig.getInitParameter(string);
                this.a.info("paramName={}, paramValue={}", (Object)string, (Object)string2);
                if (string.equalsIgnoreCase("UD_SC_SUCCESS")) {
                    this.userDefinedStatusCodeSuccess = Integer.parseInt(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("UD_SC_RESEND")) {
                    this.userDefinedStatusCodeSuccessResend = Integer.parseInt(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("UD_SC_FAILURE")) {
                    this.userDefinedStatusCodeSuccessfailure = Integer.parseInt(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("TC_LENGTH")) {
                    this.transactionCodeIdLength = Integer.parseInt(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("NAME_IFD")) {
                    this.b = string2;
                    continue;
                }
                if (string.equalsIgnoreCase("NAME_MESSAGE")) {
                    this.e = string2;
                    continue;
                }
                if (string.equalsIgnoreCase("NAME_TIMESTAMP")) {
                    this.c = string2;
                    continue;
                }
                if (string.equalsIgnoreCase("NAME_SEQUENCE")) {
                    this.d = string2;
                    continue;
                }
                if (!string.equalsIgnoreCase("NAME_TYPE")) continue;
                this.f = string2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setStatus(403);
        httpServletResponse.getWriter().println("");
        httpServletResponse.flushBuffer();
        this.a.error("GET Request is forbidden....");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block16: {
            boolean bl = false;
            String string = null;
            int n = this.userDefinedStatusCodeSuccess;
            try {
                block15: {
                    String string2 = httpServletRequest.getParameter(this.b);
                    String string3 = httpServletRequest.getParameter(this.c);
                    String string4 = httpServletRequest.getParameter(this.d);
                    String string5 = httpServletRequest.getParameter(this.e);
                    String string6 = httpServletRequest.getParameter(this.f);
                    if (string6 == null) {
                        string6 = "T";
                    }
                    string = new StringBuffer(60).append(string2).append(" ").append(string3).append(" ").append(string4).toString();
                    bl = this.b(string);
                    if (g) {
                        this.a(httpServletRequest);
                    }
                    if (bl) {
                        this.a.warn("The same request is running : {}", (Object)string);
                        n = this.userDefinedStatusCodeSuccessResend;
                    } else {
                        this.a.info("Received Message from EAI Adapter");
                        boolean bl2 = this.isValidMsg(string5);
                        if (bl2) {
                            this.a.debug("{} : {}, {} : {}, {} : {}, {} : {}", new Object[]{this.b, string2, this.c, string3, this.d, string4, string6, string5});
                            GlueDefaultContext glueDefaultContext = new GlueDefaultContext(GlueContext.EventType.EAI_SERVER);
                            try {
                                Object object;
                                glueDefaultContext.put("ReceiveTCSequence", string4);
                                glueDefaultContext.put("ReceiveTCType", string6);
                                glueDefaultContext.put("ReceiveTCIfd", string2);
                                glueDefaultContext.put("ReceiveTCTimestamp", string3);
                                glueDefaultContext.put("ReceiveTCMsg", string5);
                                String string7 = null;
                                if ("F".equalsIgnoreCase(httpServletRequest.getParameter(this.f))) {
                                    object = this.a(string5);
                                    string7 = ((File)object).getName().substring(0, this.transactionCodeIdLength) + "-service";
                                    glueDefaultContext.put("ServiceName", string7);
                                    glueDefaultContext.put("ReceiveTC", object);
                                } else {
                                    string7 = string5.substring(0, this.transactionCodeIdLength) + "-service";
                                    glueDefaultContext.put("ServiceName", string7);
                                    glueDefaultContext.put("ReceiveTC", string5);
                                }
                                glueDefaultContext.setAuditAttributes(this.createGlueAtuditAttribute(httpServletRequest, glueDefaultContext));
                                MDC.put((String)"ServiceName", (String)string7);
                                object = GlueBizProvider.getController();
                                object.doAction(glueDefaultContext);
                                MDC.remove((String)"ServiceName");
                                if (glueDefaultContext.get("HttpServletResponseCode") != null) {
                                    n = Integer.parseInt((String)glueDefaultContext.get("HttpServletResponseCode"));
                                }
                            }
                            catch (Throwable throwable) {
                                this.a.error(throwable.getMessage());
                                if (glueDefaultContext.get("HttpServletResponseCode") != null) {
                                    n = Integer.parseInt((String)glueDefaultContext.get("HttpServletResponseCode"));
                                    break block15;
                                }
                                n = this.userDefinedStatusCodeSuccessfailure;
                            }
                        } else {
                            n = this.userDefinedStatusCodeSuccessfailure;
                        }
                    }
                }
                this.a.info("Send Code to EAI Adapter[{}]", (Object)n);
                httpServletResponse.setStatus(n);
                httpServletResponse.getWriter().println("");
                httpServletResponse.flushBuffer();
                if (bl) break block16;
                this.requestMap.remove(string);
            }
            catch (Throwable throwable) {
                if (!bl) {
                    this.requestMap.remove(string);
                }
                throw throwable;
            }
        }
    }

    private File a(String string) {
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            return file;
        }
        file = new File(string.substring(this.transactionCodeIdLength + 1));
        if (file.exists() && file.isFile()) {
            return file;
        }
        file = new File(string.substring(this.transactionCodeIdLength));
        if (file.exists() && file.isFile()) {
            return file;
        }
        throw new GlueException("no file : " + this.e);
    }

    private synchronized boolean b(String string) {
        if (this.requestMap.get(string) != null) {
            return true;
        }
        this.requestMap.put(string, Thread.currentThread().getName());
        return false;
    }

    private void a(String string, String string2) {
        System.out.print(string);
        System.out.print(" = [");
        System.out.print(string2);
        System.out.print("]");
        System.out.println("");
    }

    private void a(HttpServletRequest httpServletRequest) {
        this.a("received time", new Timestamp(System.currentTimeMillis()).toString());
        this.a("request CharacterEncoding", httpServletRequest.getCharacterEncoding());
        this.a(this.b, httpServletRequest.getParameter(this.b));
        this.a(this.c, httpServletRequest.getParameter(this.c));
        this.a(this.d, httpServletRequest.getParameter(this.d));
        this.a(this.f, httpServletRequest.getParameter(this.f));
        this.a(this.e, httpServletRequest.getParameter(this.e));
    }

    protected boolean isValidMsg(String string) {
        if (string == null || string.length() < this.transactionCodeIdLength) {
            this.a.error("Invalid TransactionCodeId");
            this.a.info("Send Code to EAI Adapter[{}]", (Object)this.userDefinedStatusCodeSuccessfailure);
            return false;
        }
        return true;
    }

    protected GlueAuditAttributes createGlueAtuditAttribute(HttpServletRequest httpServletRequest, GlueContext glueContext) {
        if (GlueStaticContext.isAudit()) {
            String[] stringArray;
            String string = GlueStaticContext.getGlueProperty("audit.insert.key");
            String string2 = GlueStaticContext.getGlueProperty("audit.update.key");
            Map map = httpServletRequest.getParameterMap();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HashSet<String> hashSet = new HashSet<String>();
            for (String string3 : stringArray = (string + "," + string2).split(",")) {
                if (string3.trim().length() <= 0 || !hashSet.add(string3)) continue;
                String[] stringArray2 = (String[])map.get(string3);
                Object object = glueContext.get(string3);
                hashMap.put(string3, stringArray2 != null && stringArray2.length > 0 ? stringArray2[0] : object);
            }
            return new GlueAuditAttributes(hashMap);
        }
        return null;
    }

    public void destroy() {
        super.destroy();
    }
}

