/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.message.layout;

import com.poscoict.glueframework.message.GlueMESMessageImpl;
import com.poscoict.glueframework.message.GlueMessage;
import com.poscoict.glueframework.message.GlueMessageAttributeDefinition;
import com.poscoict.glueframework.message.layout.GlueAbstractFixedLengthMessageLayout;
import com.poscoict.glueframework.message.layout.GlueMessageDefinitionException;
import com.poscoict.glueframework.schema.parser.GlueLayoutInfo;
import com.poscoict.glueframework.schema.parser.GlueLayoutParser;
import com.poscoict.glueframework.util.GlueFileResourceUtil;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class GlueXmlMessageLayout
extends GlueAbstractFixedLengthMessageLayout {
    private String b = "layout";
    public static final String MSG_FILE_NAME = "-msg.xml";

    @Override
    public List<GlueMessageAttributeDefinition> getAttributesDefinition(String string) throws GlueMessageDefinitionException {
        String string2 = this.b + File.separator + string + MSG_FILE_NAME;
        ArrayList<GlueMessageAttributeDefinition> arrayList = new ArrayList<GlueMessageAttributeDefinition>();
        GlueLayoutInfo glueLayoutInfo = null;
        try {
            URL uRL = GlueFileResourceUtil.getResource(string2);
            this.a.debug("Loading layout file : {}", (Object)uRL.toURI());
            glueLayoutInfo = GlueLayoutParser.getInstance().parseXml(uRL);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new GlueMessageDefinitionException("Message Layout loading error!! : " + string2, uRISyntaxException);
        }
        catch (Exception exception) {
            throw new GlueMessageDefinitionException("Message Layout loading error!! : " + string2, exception);
        }
        if (!string.equals(glueLayoutInfo.getId())) {
            throw new GlueMessageDefinitionException("Message Layout loading error!! : " + string2);
        }
        for (GlueLayoutInfo.GlueLayoutAttributeInfo glueLayoutAttributeInfo : glueLayoutInfo.getAttributeList()) {
            arrayList.add(new GlueMessageAttributeDefinition(glueLayoutAttributeInfo.getType(), glueLayoutAttributeInfo.getSeq(), glueLayoutAttributeInfo.getId(), glueLayoutAttributeInfo.getName(), glueLayoutAttributeInfo.getDatatype(), glueLayoutAttributeInfo.getLength(), glueLayoutAttributeInfo.getPrecision()));
        }
        return arrayList;
    }

    @Override
    public GlueMessage createMessageObject(String string) {
        GlueMESMessageImpl glueMESMessageImpl = new GlueMESMessageImpl();
        glueMESMessageImpl.setTC(string);
        return glueMESMessageImpl;
    }
}

