/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.message.layout;

import com.poscoict.glueframework.GlueException;
import com.poscoict.glueframework.message.GlueMessage;
import com.poscoict.glueframework.message.GlueMessageAttributeDefinition;
import com.poscoict.glueframework.message.layout.GlueMessageCreatorException;
import com.poscoict.glueframework.message.layout.GlueMessageParserException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GlueMessageUtil {
    public static final String EMPTY_STRING = "";
    public static final int FORMAT_YYYYMMDDHHMMSS = 14;
    public static final int FORMAT_YYYYMMDDHHMM = 12;
    public static final int FORMAT_YYYYMMDDHH = 10;
    public static final int FORMAT_YYYYMMDD = 8;
    public static final int FORMAT_YYYYMM = 6;
    public static final int FORMAT_YYYY = 4;
    private static final Logger a = LoggerFactory.getLogger(GlueMessageUtil.class);

    private static String a(String string, int n) {
        StringBuffer stringBuffer = string == null ? new StringBuffer(EMPTY_STRING) : new StringBuffer(string);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static char[] a(char c, int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = c;
        }
        return cArray;
    }

    public static int getIntFromString(String string) {
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return 0;
    }

    public static String rightTrim(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        for (n = string.length(); n > 0 && cArray[n - 1] <= ' '; --n) {
        }
        return string.substring(0, n);
    }

    public static String substringByte(byte[] byArray, int n, int n2) {
        int n3 = byArray.length;
        if (null == byArray || n3 == 0) {
            return EMPTY_STRING;
        }
        if (0 <= n && n <= n2 && n2 <= n3) {
            String string = new String(byArray, n, n2 - n);
            if (string.length() == 0 && n2 != n) {
                string = GlueMessageUtil.substringByte(byArray, n, n2 - 1);
            }
            return string;
        }
        return EMPTY_STRING;
    }

    public static String substringByte(String string, int n, int n2) {
        byte[] byArray = string.getBytes();
        return GlueMessageUtil.substringByte(byArray, n, n2);
    }

    public static String getStringFromNumber(BigDecimal bigDecimal, int n, int n2) {
        a.debug("Original Number  :: {}", (Object)bigDecimal.toString());
        a.debug("Truncat Number  :: {}", (Object)bigDecimal.setScale(n2, 1));
        String string = EMPTY_STRING;
        try {
            int n3;
            if (bigDecimal != null) {
                if (n2 > 0) {
                    bigDecimal = bigDecimal.setScale(n2, 1).movePointRight(n2);
                    a.debug("Tru&Shi Number  :: {}" + bigDecimal);
                }
                string = bigDecimal.toString();
            }
            if ((n3 = string.length()) > n) {
                string = string.substring(0, n);
            } else if (n3 < n) {
                string = bigDecimal.longValue() >= 0L ? new String(GlueMessageUtil.a('0', n - n3)) + string : new String(GlueMessageUtil.a('-', 1)) + new String(GlueMessageUtil.a('0', n - n3)) + string.substring(1);
            }
            a.debug("getStringFromNumber() value={}", (Object)string);
        }
        catch (Exception exception) {
            throw new GlueMessageCreatorException("Number message creation error", exception);
        }
        return string;
    }

    public static Date convertStringToDate(String string) throws GlueException {
        try {
            if (string == null || string.trim().length() < 1) {
                return null;
            }
            String string2 = null;
            switch (string.trim().length()) {
                case 14: {
                    string2 = "yyyyMMddHHmmss";
                    break;
                }
                case 12: {
                    string2 = "yyyyMMddHHmm";
                    break;
                }
                case 10: {
                    string2 = "yyyyMMddHH";
                    break;
                }
                case 8: {
                    string2 = "yyyyMMdd";
                    break;
                }
                case 6: {
                    string2 = "yyyyMM";
                    break;
                }
                case 4: {
                    string2 = "yyyy";
                    break;
                }
                default: {
                    a.warn("not support.");
                    return null;
                }
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            simpleDateFormat.setLenient(false);
            return new Timestamp(simpleDateFormat.parse(string).getTime());
        }
        catch (Exception exception) {
            throw new GlueMessageParserException("Error occurrence while convertStringToDate() method accomplishing!!" + exception.getMessage(), exception);
        }
    }

    public static String getToString(String string, String string2, int n) {
        for (int i = 0; i < n; ++i) {
            string = string2 + string;
        }
        return string;
    }

    public static String getMsgString(GlueMessageAttributeDefinition glueMessageAttributeDefinition, GlueMessage glueMessage, int n) {
        String string = EMPTY_STRING;
        String string2 = glueMessageAttributeDefinition.getId();
        int n2 = glueMessageAttributeDefinition.getLength();
        String string3 = null;
        if (glueMessageAttributeDefinition.getType().equals("GE")) {
            String string4 = string2 + String.valueOf(n);
            if (glueMessage.get(string4) == null) {
                if (glueMessage.get(string2) != null) {
                    string3 = (String)((List)glueMessage.get(string2)).get(n);
                }
            } else if (glueMessage.get(string4) != null) {
                string3 = (String)glueMessage.get(string4);
            }
        } else if (glueMessage.get(string2) != null) {
            string3 = (String)glueMessage.get(string2);
        }
        string = string3 == null ? GlueMessageUtil.a(EMPTY_STRING, n2) : (n2 > string3.length() ? GlueMessageUtil.a(string3, n2 - string3.length()) : (n2 < string3.length() ? string3.substring(0, n2) : string3));
        return string;
    }

    public static String getByteMsgString(GlueMessageAttributeDefinition glueMessageAttributeDefinition, GlueMessage glueMessage, int n) {
        return GlueMessageUtil.getByteMsgString(glueMessageAttributeDefinition, glueMessage, n, Charset.defaultCharset());
    }

    public static String getByteMsgString(GlueMessageAttributeDefinition glueMessageAttributeDefinition, GlueMessage glueMessage, int n, Charset charset) {
        Object object;
        String string = EMPTY_STRING;
        String string2 = glueMessageAttributeDefinition.getId();
        int n2 = glueMessageAttributeDefinition.getLength();
        String string3 = null;
        if (glueMessageAttributeDefinition.getType().equals("GE")) {
            object = string2 + String.valueOf(n);
            if (glueMessage.get((String)object) == null) {
                if (glueMessage.get(string2) != null) {
                    string3 = (String)((List)glueMessage.get(string2)).get(n);
                }
            } else if (glueMessage.get((String)object) != null) {
                string3 = (String)glueMessage.get((String)object);
            }
        } else if (glueMessage.get(string2) != null) {
            string3 = (String)glueMessage.get(string2);
        }
        if (string3 == null) {
            string = GlueMessageUtil.a(EMPTY_STRING, n2);
        } else {
            object = string3.getBytes(charset);
            int n3 = ((Object)object).length;
            if (n2 > n3) {
                string = GlueMessageUtil.a(string3, n2 - n3);
            } else if (n2 < n3) {
                byte[] byArray = string3.getBytes(charset);
                string = new String(byArray, 0, n2);
            } else {
                string = string3;
            }
        }
        return string;
    }

    public static String getMsgNumber(GlueMessageAttributeDefinition glueMessageAttributeDefinition, GlueMessage glueMessage, int n) {
        Object object;
        String string = EMPTY_STRING;
        String string2 = glueMessageAttributeDefinition.getId();
        int n2 = glueMessageAttributeDefinition.getLength();
        Number number = null;
        try {
            if (glueMessageAttributeDefinition.getType().equals("GE")) {
                object = string2 + String.valueOf(n);
                if (glueMessage.get((String)object) == null) {
                    if (glueMessage.get(string2) != null && ((List)glueMessage.get(string2)).get(n) != null) {
                        number = (Number)((List)glueMessage.get(string2)).get(n);
                    }
                } else if (glueMessage.get((String)object) != null) {
                    number = (Number)glueMessage.get((String)object);
                }
            } else if (glueMessage.get(string2) != null) {
                number = (Number)glueMessage.get(string2);
            }
        }
        catch (Exception exception) {
            throw new GlueMessageCreatorException("It is Wrong Number : Message Attribute-" + string2 + ", Message Atttribute Value=" + glueMessage.get(string2), exception);
        }
        if (number == null) {
            string = GlueMessageUtil.a(EMPTY_STRING, n2);
        } else {
            object = new BigDecimal(number.toString());
            try {
                string = GlueMessageUtil.getStringFromNumber((BigDecimal)object, n2, glueMessageAttributeDefinition.getPrecision());
            }
            catch (GlueMessageCreatorException glueMessageCreatorException) {
                throw new GlueMessageCreatorException("Number message creation error : Message Attribute-" + string2 + ", Message Atttribute Value=" + glueMessage.get(string2), glueMessageCreatorException);
            }
            catch (Exception exception) {
                throw new GlueMessageCreatorException("Number message creation error : Message Attribute-" + string2 + ", Message Atttribute Value=" + glueMessage.get(string2), exception);
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getMsgDate(GlueMessageAttributeDefinition glueMessageAttributeDefinition, GlueMessage glueMessage, int n) {
        try {
            String string = glueMessageAttributeDefinition.getId();
            Object object = null;
            if (glueMessage.get(string) == null) return GlueMessageUtil.a(EMPTY_STRING, glueMessageAttributeDefinition.getLength());
            if (glueMessageAttributeDefinition.getType().equals("GE")) {
                if (((List)glueMessage.get(string)).get(n) != null) {
                    object = ((List)glueMessage.get(string)).get(n);
                } else {
                    if (glueMessage.get(string + String.valueOf(n)) == null) return GlueMessageUtil.a(EMPTY_STRING, glueMessageAttributeDefinition.getLength());
                    object = glueMessage.get(string + String.valueOf(n));
                }
            } else {
                object = glueMessage.get(string);
            }
            if (object instanceof Timestamp) {
                return GlueMessageUtil.convertDateToString((Timestamp)object, glueMessageAttributeDefinition.getLength());
            }
            if (object instanceof Number) {
                return GlueMessageUtil.convertDateToString(new Timestamp(((Number)object).longValue()), glueMessageAttributeDefinition.getLength());
            }
            String string2 = object.toString();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string2.length(); ++i) {
                if (!Character.isDigit(string2.charAt(i))) continue;
                stringBuilder.append(string2.charAt(i));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            throw new GlueMessageCreatorException("It is Wrong Date : Message Attribute-" + glueMessageAttributeDefinition.getId() + ", Message Atttribute Value=" + glueMessage.get(glueMessageAttributeDefinition.getId()), exception);
        }
    }

    public static String convertDateToString(Timestamp timestamp, int n) {
        switch (n) {
            case 14: {
                return new SimpleDateFormat("yyyyMMddHHmmss").format(timestamp);
            }
            case 12: {
                return new SimpleDateFormat("yyyyMMddHHmm").format(timestamp);
            }
            case 10: {
                return new SimpleDateFormat("yyyyMMddHH").format(timestamp);
            }
            case 8: {
                return new SimpleDateFormat("yyyyMMdd").format(timestamp);
            }
            case 6: {
                return new SimpleDateFormat("yyyyMM").format(timestamp);
            }
            case 4: {
                return new SimpleDateFormat("yyyy").format(timestamp);
            }
        }
        a.warn("not support.");
        return GlueMessageUtil.a(EMPTY_STRING, n);
    }
}

