/*
 * Decompiled with CFR 0.152.
 */
package com.poscoict.glueframework.dao.sequence;

import com.poscoict.glueframework.dao.sequence.GlueAltibaseSequence;
import com.poscoict.glueframework.dao.sequence.GlueDB2Sequence;
import com.poscoict.glueframework.dao.sequence.GlueHsqlSequence;
import com.poscoict.glueframework.dao.sequence.GlueOracleSequence;
import com.poscoict.glueframework.dao.sequence.GluePostgreSQLSequence;
import com.poscoict.glueframework.dao.sequence.GlueSequence;
import com.poscoict.glueframework.dao.sequence.GlueTiberoSequence;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlueSequenceFactory {
    private static final Logger a = LoggerFactory.getLogger(GlueSequenceFactory.class);

    public static GlueSequence createSequence(DataSource dataSource, String string) {
        String string2 = string.toLowerCase();
        GlueSequence glueSequence = null;
        if (string2.indexOf("oracle") >= 0 || string2.indexOf("enterprisedb") >= 0) {
            glueSequence = new GlueOracleSequence(dataSource);
        } else if (string2.indexOf("db2") >= 0 || string2.indexOf("ibm") >= 0 || string2.indexOf("db 2") >= 0) {
            glueSequence = new GlueDB2Sequence(dataSource);
        } else if (string2.indexOf("postgre") >= 0) {
            glueSequence = new GluePostgreSQLSequence(dataSource);
        } else if (string2.indexOf("altibase") >= 0) {
            glueSequence = new GlueAltibaseSequence(dataSource);
        } else if (string2.indexOf("tibero") >= 0) {
            glueSequence = new GlueTiberoSequence(dataSource);
        } else if (string2.indexOf("hsql") >= 0) {
            glueSequence = new GlueHsqlSequence(dataSource);
        }
        if (glueSequence == null) {
            a.warn("Not support a sequence incrementer : {}", (Object)string);
        } else {
            a.info("Sequence Increamenter is constructed successfully... : {}", (Object)glueSequence);
        }
        return glueSequence;
    }
}

